<?php $__env->startSection('title', 'Detail Lembaga'); ?>

<?php $__env->startSection('breadcrumb'); ?>
<li class="breadcrumb-item"><a href="<?php echo e(route('pengawas.lembaga.index')); ?>">Lembaga</a></li>
<li class="breadcrumb-item active">Detail</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            <i class="fas fa-school"></i> Detail Lembaga: <?php echo e($lembaga->nama_lembaga); ?>

        </h3>
        <div class="card-tools">
            <a href="<?php echo e(route('pengawas.lembaga.edit', $lembaga)); ?>" class="btn btn-warning btn-sm">
                <i class="fas fa-edit"></i> Edit
            </a>
            <a href="<?php echo e(route('pengawas.lembaga.index')); ?>" class="btn btn-secondary btn-sm">
                <i class="fas fa-arrow-left"></i> Kembali
            </a>
        </div>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Informasi Umum</h3>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <strong>Nama Lembaga:</strong><br>
                                <span class="text-primary"><?php echo e($lembaga->nama_lembaga); ?></span><br><br>
                                
                                <strong>Jenis:</strong><br>
                                <span class="badge badge-<?php echo e($lembaga->jenis == 'RA' ? 'primary' : ($lembaga->jenis == 'MI' ? 'success' : ($lembaga->jenis == 'MTs' ? 'info' : 'warning'))); ?>">
                                    <?php echo e($lembaga->jenis); ?>

                                </span><br><br>
                                
                                <strong>NPSN/NSM:</strong><br>
                                <span class="text-info"><?php echo e($lembaga->npsn_nsm); ?></span><br><br>
                                
                                <strong>Akreditasi:</strong><br>
                                <span class="text-warning"><?php echo e($lembaga->akreditasi ?? 'Belum terakreditasi'); ?></span><br><br>
                                
                                <strong>Tahun Berdiri:</strong><br>
                                <span class="text-success"><?php echo e($lembaga->tahun_berdiri ?? 'Tidak diketahui'); ?></span>
                            </div>
                            <div class="col-md-6">
                                <strong>Alamat Lengkap:</strong><br>
                                <span class="text-muted"><?php echo e($lembaga->alamat_lengkap); ?></span><br><br>
                                
                                <strong>Kelurahan:</strong> <?php echo e($lembaga->kelurahan_name ?? $lembaga->kelurahan); ?><br>
                                <strong>Kecamatan:</strong> <?php echo e($lembaga->kecamatan_name ?? $lembaga->kecamatan); ?><br>
                                <strong>Kabupaten:</strong> <?php echo e($lembaga->kabupaten_name ?? $lembaga->kabupaten); ?><br>
                                <strong>Provinsi:</strong> <?php echo e($lembaga->provinsi_name ?? $lembaga->provinsi); ?><br>
                                <strong>Kode Pos:</strong> <?php echo e($lembaga->kode_pos ?? 'Tidak ada'); ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Kontak</h3>
                    </div>
                    <div class="card-body">
                        <?php if($lembaga->telepon): ?>
                        <div class="info-box bg-success">
                            <span class="info-box-icon"><i class="fas fa-phone"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text">Telepon</span>
                                <span class="info-box-number"><?php echo e($lembaga->telepon); ?></span>
                            </div>
                        </div>
                        <?php endif; ?>
                        
                        <?php if($lembaga->email): ?>
                        <div class="info-box bg-warning">
                            <span class="info-box-icon"><i class="fas fa-envelope"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text">Email</span>
                                <span class="info-box-number"><?php echo e($lembaga->email); ?></span>
                            </div>
                        </div>
                        <?php endif; ?>
                        
                        <?php if($lembaga->website): ?>
                        <div class="info-box bg-danger">
                            <span class="info-box-icon"><i class="fas fa-globe"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text">Website</span>
                                <span class="info-box-number">
                                    <a href="<?php echo e($lembaga->website); ?>" target="_blank" class="text-white">
                                        <?php echo e($lembaga->website); ?>

                                    </a>
                                </span>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="row mt-3">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Informasi Kepala Madrasah</h3>
                    </div>
                    <div class="card-body">
                        <div class="text-center">
                            <img src="https://adminlte.io/themes/v3/dist/img/user2-160x160.jpg" class="img-circle elevation-2 mb-3" alt="User Image" style="width: 80px; height: 80px;">
                            <h4><?php echo e($lembaga->nama_kepala); ?></h4>
                            <p class="text-muted">NIP: <?php echo e($lembaga->nip_kepala); ?></p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Statistik Guru</h3>
                    </div>
                    <div class="card-body">
                        <div class="info-box bg-primary">
                            <span class="info-box-icon"><i class="fas fa-chalkboard-teacher"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text">Total Guru</span>
                                <span class="info-box-number"><?php echo e($lembaga->guru()->count()); ?></span>
                            </div>
                        </div>
                        
                        <div class="row text-center mt-3">
                            <div class="col-6">
                                <h4><?php echo e($lembaga->guru()->where('status_kepegawaian', 'PNS')->count()); ?></h4>
                                <small class="text-muted">PNS</small>
                            </div>
                            <div class="col-6">
                                <h4><?php echo e($lembaga->guru()->where('status_kepegawaian', '!=', 'PNS')->count()); ?></h4>
                                <small class="text-muted">Non-PNS</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php if($lembaga->guru()->count() > 0): ?>
        <div class="card mt-3">
            <div class="card-header">
                <h3 class="card-title">Daftar Guru (<?php echo e($lembaga->guru()->count()); ?>)</h3>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Nama Guru</th>
                                <th>Mata Pelajaran</th>
                                <th>Kelas</th>
                                <th>Status Kepegawaian</th>
                                <th>Status Sertifikasi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $lembaga->guru()->take(10)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $guru): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($guru->nama_lengkap_with_gelar); ?></td>
                                <td><?php echo e($guru->mata_pelajaran); ?></td>
                                <td><?php echo e($guru->kelas_diampu); ?></td>
                                <td><span class="badge badge-info"><?php echo e($guru->status_kepegawaian); ?></span></td>
                                <td><span class="badge badge-<?php echo e($guru->status_sertifikasi == 'sudah' ? 'success' : 'warning'); ?>"><?php echo e(ucfirst($guru->status_sertifikasi)); ?></span></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
                <?php if($lembaga->guru()->count() > 10): ?>
                <div class="text-center mt-3">
                    <small class="text-muted">Menampilkan 10 dari <?php echo e($lembaga->guru()->count()); ?> guru</small>
                </div>
                <?php endif; ?>
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /www/wwwroot/pkkm.pitchoiriyah.my.id/resources/views/pengawas/lembaga/show.blade.php ENDPATH**/ ?>