<?php $__env->startSection('title', 'Penilaian Kepala'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title"><i class="fas fa-star"></i> Penilaian Kepala: <?php echo e($penilaian->kepala?->name ?? '-'); ?></h3>
                    <div>
                        <?php if(in_array($penilaian->status, ['validated', 'final'])): ?>
                        <a href="<?php echo e(route('pengawas.penilaian.raport', $penilaian->id)); ?>" class="btn btn-success btn-sm" target="_blank" title="Download Raport PDF">
                            <i class="fas fa-file-pdf"></i>
                        </a>
                        <form method="POST" action="<?php echo e(route('pengawas.penilaian.kirim-raport-kepala', $penilaian->id)); ?>" style="display: inline;" onsubmit="return confirm('Apakah Anda yakin ingin mengirim raport ke kepala sekolah? Kepala akan menerima notifikasi.');">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="btn btn-info btn-sm" title="Kirim Raport ke Kepala">
                                <i class="fas fa-paper-plane"></i>
                            </button>
                        </form>
                        <?php endif; ?>
                        <a href="<?php echo e(route('pengawas.penilaian.index')); ?>" class="btn btn-secondary btn-sm" title="Kembali ke Daftar Penilaian"><i class="fas fa-arrow-left"></i></a>
                    </div>
                </div>
                <div class="card-body">
                    <?php if(session('success')): ?>
                        <div class="alert alert-success alert-dismissible"><button type="button" class="close" data-dismiss="alert">&times;</button><?php echo e(session('success')); ?></div>
                    <?php endif; ?>
                    <?php if(session('error')): ?>
                        <div class="alert alert-danger alert-dismissible"><button type="button" class="close" data-dismiss="alert">&times;</button><?php echo e(session('error')); ?></div>
                    <?php endif; ?>

                    <div class="mb-3 d-flex justify-content-between align-items-center">
                        <div>
                            <strong>Instrumen:</strong> <?php echo e($distribusi->instrumen->judul); ?><br>
                            <small class="text-muted">Tahun <?php echo e($distribusi->instrumen->tahun_ajaran); ?> - Semester <?php echo e($distribusi->instrumen->semester); ?></small>
                        </div>
                        <div>
                            <span class="badge badge-<?php echo e($penilaian->status == 'draft' ? 'secondary' : ($penilaian->status == 'submitted' ? 'warning' : 'success')); ?>">Status: <?php echo e(ucfirst($penilaian->status)); ?></span>
                            <?php if($penilaian->status == 'draft'): ?>
                                <div class="mt-2">
                                    <small class="text-muted">
                                        <i class="fas fa-tasks"></i> Progress: <?php echo e($terisi); ?>/<?php echo e($totalItems); ?> item dinilai
                                    </small>
                                    <?php if($isComplete): ?>
                                        <span class="badge badge-success ml-2"><i class="fas fa-check"></i> Siap Finalisasi</span>
                                    <?php else: ?>
                                        <span class="badge badge-warning ml-2"><i class="fas fa-exclamation-triangle"></i> Belum Lengkap</span>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <?php if(session('error')): ?>
                        <div class="alert alert-danger alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            <?php echo e(session('error')); ?>

                        </div>
                    <?php endif; ?>

                    <form method="POST" action="<?php echo e(route('pengawas.penilaian.update', $penilaian->id)); ?>">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>

                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <thead class="thead-light">
                                    <tr>
                                        <th width="6%">No</th>
                                        <th>Indikator</th>
                                        <th width="12%">Nilai Kepala</th>
                                        <th width="18%">Bukti (URL)</th>
                                        <th width="20%">Catatan Kepala</th>
                                        <th width="12%">Nilai Pengawas</th>
                                        <th width="20%">Catatan Pengawas</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $idx => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php 
                                            $j = $jawabanMap[$item->id] ?? null;
                                            $formKey = $j->id ?? 'new_' . $item->id;
                                        ?>
                                        <tr data-item-id="<?php echo e($item->id); ?>" data-jawaban-id="<?php echo e($j->id ?? null); ?>" data-form-key="<?php echo e($formKey); ?>">
                                            <td class="text-center"><?php echo e(($items->currentPage() - 1) * $items->perPage() + $idx + 1); ?></td>
                                            <td>
                                                <div class="font-weight-bold"><?php echo e($item->indikator_kinerja); ?></div>
                                                <?php if($item->evidensi_kinerja): ?>
                                                    <small class="text-muted"><?php echo e($item->evidensi_kinerja); ?></small>
                                                <?php endif; ?>
                                                <?php if($j): ?>
                                                    <small class="text-muted d-block mt-1">(Item ID: <?php echo e($item->id); ?>, Jawaban ID: <?php echo e($j->id); ?>)</small>
                                                <?php else: ?>
                                                    <small class="text-warning d-block mt-1">(Item ID: <?php echo e($item->id); ?>, Jawaban ID: NULL - akan dibuat saat save)</small>
                                                <?php endif; ?>
                                            </td>
                                            <td class="text-center"><?php echo e($j->nilai_guru_self ?? '-'); ?></td>
                                            <td>
                                                <?php if(!empty($j->url_bukti)): ?>
                                                    <a href="<?php echo e($j->url_bukti); ?>" target="_blank"><?php echo e($j->url_bukti); ?></a>
                                                <?php else: ?>
                                                    <span class="text-muted">-</span>
                                                <?php endif; ?>
                                            </td>
                                            <td><?php echo e($j->keterangan_bukti ?? '-'); ?></td>
                                            <td>
                                                <input type="hidden" name="nilai[<?php echo e($formKey); ?>][instrumen_item_id]" value="<?php echo e($item->id); ?>">
                                                <input type="number" name="nilai[<?php echo e($formKey); ?>][nilai_pengawas]" class="form-control nilai-pengawas-input" min="1" max="5" value="<?php echo e(old('nilai.'.$formKey.'.nilai_pengawas', $j->nilai_pengawas ?? '')); ?>" data-item-id="<?php echo e($item->id); ?>" data-jawaban-id="<?php echo e($j->id ?? null); ?>">
                                            </td>
                                            <td>
                                                <textarea name="nilai[<?php echo e($formKey); ?>][catatan_pengawas]" class="form-control" rows="2"><?php echo e(old('nilai.'.$formKey.'.catatan_pengawas', $j->catatan_pengawas ?? '')); ?></textarea>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>

                        <?php if($items->hasPages()): ?>
                        <div class="mt-3">
                            <?php echo e($items->links('pagination::bootstrap-4')); ?>

                        </div>
                        <?php endif; ?>

                        <div class="card mt-3">
                            <div class="card-header"><h3 class="card-title"><i class="fas fa-comment-dots"></i> Review Umum</h3></div>
                            <div class="card-body">
                                <div class="form-group">
                                    <label>Catatan Pengawas (umum)</label>
                                    <textarea name="catatan_pengawas" class="form-control" rows="4" <?php echo e(in_array($penilaian->status, ['validated', 'final']) ? 'readonly' : ''); ?>><?php echo e(old('catatan_pengawas', $penilaian->catatan_pengawas)); ?></textarea>
                                    <?php if(!in_array($penilaian->status, ['validated', 'final'])): ?>
                                    <div class="form-check mt-2">
                                        <input type="checkbox" class="form-check-input" id="genAI" name="generate_ai" value="1">
                                        <label class="form-check-label" for="genAI">Preview: Gunakan analisa AI untuk menghasilkan ringkasan (untuk preview sebelum finalisasi)</label>
                                    </div>
                                    <small class="text-info"><i class="fas fa-info-circle"></i> <strong>Catatan:</strong> Analisis AI lengkap akan <strong>otomatis di-generate saat finalisasi</strong> (status Validated/Final). Proses ini memakan waktu 10-30 detik. Centang checkbox ini hanya untuk preview sebelum finalisasi.</small>
                                    <?php endif; ?>
                                </div>
                                <?php if(in_array($penilaian->status, ['validated', 'final'])): ?>
                                <div class="alert alert-info">
                                    <i class="fas fa-info-circle"></i> Penilaian sudah difinalisasi. Catatan dan nilai tidak dapat diubah lagi.
                                    <div class="mt-2">
                                        <form method="POST" action="<?php echo e(route('pengawas.penilaian.ubah-status', $penilaian->id)); ?>" style="display: inline;" onsubmit="return confirm('Apakah Anda yakin ingin mengubah status penilaian menjadi draft? Penilaian ini akan dapat diedit kembali.');">
                                            <?php echo csrf_field(); ?>
                                            <input type="hidden" name="status" value="draft">
                                            <button type="submit" class="btn btn-warning btn-sm">
                                                <i class="fas fa-undo"></i> Ubah Status ke Draft
                                            </button>
                                        </form>
                                    </div>
                                </div>
                                <?php endif; ?>
                                
                                <?php if(!in_array($penilaian->status, ['validated', 'final'])): ?>
                                <div class="form-group">
                                    <label>Status Finalisasi <span class="text-danger" id="statusRequired">*</span></label>
                                    <select name="final_status" id="final_status" class="form-control">
                                        <option value="">-- Pilih Status Finalisasi --</option>
                                        <option value="validated" <?php echo e(old('final_status') == 'validated' ? 'selected' : ''); ?>>Validated</option>
                                        <option value="final" <?php echo e(old('final_status') == 'final' ? 'selected' : ''); ?>>Final</option>
                                    </select>
                                    <small class="text-muted">Pilih status saat melakukan finalisasi penilaian (wajib dipilih sebelum finalisasi, tidak wajib untuk simpan draft)</small>
                                </div>
                                <?php endif; ?>
                                
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <?php if(!in_array($penilaian->status, ['validated', 'final'])): ?>
                                        <button type="submit" name="action" value="save" class="btn btn-secondary">
                                            <i class="fas fa-save"></i> Simpan Draft
                                        </button>
                                        <?php endif; ?>
                                    </div>
                                    <div>
                                        <?php if(!in_array($penilaian->status, ['validated', 'final'])): ?>
                                        <button type="submit" name="action" value="finalize" id="btnFinalize" class="btn btn-primary" <?php echo e(!$isComplete ? 'disabled' : ''); ?> onclick="return validateFinalize();">
                                            <i class="fas fa-check-circle"></i> Finalisasi Penilaian
                                        </button>
                                        <?php if(!$isComplete): ?>
                                        <small class="d-block text-danger mt-1">
                                            Semua item harus dinilai sebelum finalisasi (<?php echo e($terisi); ?>/<?php echo e($totalItems); ?> sudah dinilai)
                                            <br>
                                            <button type="button" class="btn btn-sm btn-info mt-1" onclick="checkMissingItems()">
                                                <i class="fas fa-search"></i> Cek Item yang Belum Dinilai
                                            </button>
                                        </small>
                                        <?php endif; ?>
                                        <?php else: ?>
                                        <span class="badge badge-success"><i class="fas fa-check"></i> Penilaian Sudah Difinalisasi</span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
function validateFinalize() {
    // Validasi semua item sudah dinilai
    var isComplete = <?php echo e($isComplete ? 'true' : 'false'); ?>;
    var terisi = <?php echo e($terisi); ?>;
    var totalItems = <?php echo e($totalItems); ?>;
    
    if (!isComplete) {
        alert('Semua item harus dinilai sebelum finalisasi (' + terisi + '/' + totalItems + ' sudah dinilai).');
        return false;
    }
    
    // Validasi status sudah dipilih
    var finalStatus = document.getElementById('final_status');
    
    if (!finalStatus) {
        alert('Error: Element Status Finalisasi tidak ditemukan.');
        return false;
    }
    
    if (!finalStatus.value || finalStatus.value === '') {
        alert('Silakan pilih Status Finalisasi terlebih dahulu (Validated atau Final) sebelum melakukan finalisasi.');
        finalStatus.focus();
        return false;
    }
    
    // Konfirmasi finalisasi
    var statusText = finalStatus.options[finalStatus.selectedIndex].text;
    
    var confirmed = confirm('Apakah Anda yakin ingin memfinalisasi penilaian ini dengan status "' + statusText + '"? Setelah finalisasi, data tidak dapat diubah lagi.');
    
    return confirmed;
}

// Disable/enable tombol finalisasi berdasarkan status dropdown
document.addEventListener('DOMContentLoaded', function() {
    var finalStatus = document.getElementById('final_status');
    var btnFinalize = document.getElementById('btnFinalize');
    var isComplete = <?php echo e($isComplete ? 'true' : 'false'); ?>;
    
    if (finalStatus && btnFinalize) {
        // Update tombol saat status berubah
        finalStatus.addEventListener('change', function() {
            if (this.value && isComplete) {
                btnFinalize.disabled = false;
            } else if (!this.value) {
                btnFinalize.disabled = true;
            } else if (!isComplete) {
                btnFinalize.disabled = true;
            }
        });
        
        // Set initial state
        var shouldDisable = !finalStatus.value || !isComplete;
        
        if (shouldDisable) {
            btnFinalize.disabled = true;
        } else {
            btnFinalize.disabled = false;
        }
        
        // Handle form submission - remove required untuk save draft
        var form = document.querySelector('form[method="POST"]');
        if (form) {
            // Handle untuk tombol Simpan Draft - hapus required
            var btnSave = document.querySelector('button[name="action"][value="save"]');
            if (btnSave) {
                btnSave.addEventListener('click', function(e) {
                    // Remove required attribute untuk save draft
                    if (finalStatus) {
                        finalStatus.removeAttribute('required');
                    }
                });
            }
            
            // Handle untuk tombol Finalisasi - tambahkan required
            if (btnFinalize) {
                btnFinalize.addEventListener('click', function(e) {
                    // Add required attribute untuk finalisasi
                    if (finalStatus) {
                        finalStatus.setAttribute('required', 'required');
                    }
                });
            }
        }
    }
});

// Function untuk cek item yang belum dinilai
function checkMissingItems() {
    // Cek dari AJAX ke server (lebih akurat karena cek semua data, bukan hanya halaman saat ini)
    fetch('<?php echo e(route("pengawas.penilaian.debug", $penilaian->id)); ?>')
        .then(response => response.json())
        .then(data => {
            
            var message = '=== RINGKASAN STATUS PENILAIAN ===\n\n';
            message += 'Total Item: ' + data.total_items + '\n';
            message += 'Sudah Dinilai: ' + data.terisi + '\n';
            message += 'Belum Dinilai: ' + (data.total_items - data.terisi) + '\n\n';
            
            var hasMissing = false;
            
            // Item yang belum punya record
            if (data.missing_records && data.missing_records.length > 0) {
                hasMissing = true;
                message += '⚠️ Item yang BELUM PUNYA RECORD di database:\n';
                message += '   ' + data.missing_records.join(', ') + '\n\n';
                message += '📌 SOLUSI: Klik "Simpan Draft" di semua halaman pagination untuk membuat record.\n\n';
            }
            
            // Item yang punya record tapi belum dinilai
            if (data.missing_nilai && data.missing_nilai.length > 0) {
                hasMissing = true;
                message += '⚠️ Item yang BELUM DINILAI (sudah punya record tapi nilai kosong/null):\n\n';
                
                // Group by page number
                var itemsByPage = {};
                data.missing_nilai.forEach(function(item) {
                    var page = item.page_number || 'unknown';
                    if (!itemsByPage[page]) {
                        itemsByPage[page] = [];
                    }
                    itemsByPage[page].push(item);
                });
                
                // Display grouped by page
                Object.keys(itemsByPage).sort().forEach(function(page) {
                    if (page !== 'unknown') {
                        message += '📄 Halaman ' + page + ':\n';
                        itemsByPage[page].forEach(function(item) {
                            // Tampilkan Item ID dengan jelas (ini yang paling penting)
                            var itemInfo = '   • Item ID: ' + item.item_id;
                            if (item.position) {
                                // Hitung nomor urut di halaman (1-10 untuk halaman 1, 11-20 untuk halaman 2, dst)
                                var itemNumberInPage = item.position - ((parseInt(page) - 1) * 10);
                                itemInfo += ' (Posisi #' + item.position + ' dari total, muncul sebagai Item #' + itemNumberInPage + ' di Halaman ' + page + ')';
                            }
                            if (item.no_urutan) itemInfo += ' [No Urut DB: ' + item.no_urutan + ' - PERHATIAN: No Urut DB bisa duplikat!]';
                            if (item.indikator_kinerja) {
                                var indikator = item.indikator_kinerja.length > 80 
                                    ? item.indikator_kinerja.substring(0, 80) + '...' 
                                    : item.indikator_kinerja;
                                itemInfo += '\n     "' + indikator + '"';
                            }
                            itemInfo += '\n     Jawaban ID: ' + item.jawaban_id + ', Nilai Pengawas: ' + (item.nilai_pengawas || 'KOSONG/NULL') + '\n';
                            message += itemInfo;
                        });
                        message += '\n';
                    } else {
                        itemsByPage[page].forEach(function(item) {
                            var itemInfo = '   • Item ID: ' + item.item_id;
                            if (item.indikator_kinerja) {
                                var indikator = item.indikator_kinerja.length > 80 
                                    ? item.indikator_kinerja.substring(0, 80) + '...' 
                                    : item.indikator_kinerja;
                                itemInfo += '\n     "' + indikator + '"';
                            }
                            itemInfo += '\n     Jawaban ID: ' + item.jawaban_id + ', Nilai: ' + (item.nilai_pengawas || 'KOSONG');
                            message += itemInfo + '\n';
                        });
                    }
                });
                
                message += '\n📌 SOLUSI:\n';
                if (itemsByPage['1']) {
                    message += '   → Buka halaman 1 dan isi nilai untuk item-item tersebut\n';
                }
                if (itemsByPage['2']) {
                    message += '   → Buka halaman 2 dan isi nilai untuk item-item tersebut\n';
                }
                if (itemsByPage['3']) {
                    message += '   → Buka halaman 3 dan isi nilai untuk item-item tersebut\n';
                }
                var otherPages = Object.keys(itemsByPage).filter(function(p) {
                    return p !== 'unknown' && !['1', '2', '3'].includes(p);
                });
                if (otherPages.length > 0) {
                    message += '   → Buka halaman ' + otherPages.join(', ') + ' dan isi nilai\n';
                }
                message += '   → Setelah isi nilai, klik "Simpan Draft" di halaman tersebut\n';
                message += '   → Pastikan semua halaman pagination sudah disimpan\n\n';
                
                // Tambahkan link cepat ke halaman dengan Item ID yang jelas
                var uniquePages = Object.keys(itemsByPage).filter(function(p) { return p !== 'unknown'; }).sort();
                if (uniquePages.length > 0) {
                    message += '🔗 Link cepat ke halaman yang perlu diisi:\n';
                    uniquePages.forEach(function(page) {
                        var url = window.location.pathname + '?page=' + page;
                        message += '   • Halaman ' + page + ': ' + url + '\n';
                    });
                    message += '\n';
                }
            }
            
            // Item yang sudah dinilai (untuk info)
            if (data.all_jawaban && data.all_jawaban.length > 0) {
                var filled = data.all_jawaban.filter(function(j) {
                    return j.nilai_pengawas && j.nilai_pengawas > 0;
                });
                message += '✓ Item yang sudah dinilai: ' + filled.length + ' item\n';
            }
            
            if (!hasMissing && data.terisi >= data.total_items) {
                message += '✅ SEMUA ITEM SUDAH DINILAI!\n';
                message += 'Anda bisa melakukan finalisasi sekarang.\n';
            } else if (data.terisi < data.total_items) {
                message += '\n❌ MASIH ADA ' + (data.total_items - data.terisi) + ' ITEM YANG BELUM DINILAI!\n';
            }
            
            alert(message);
        })
        .catch(error => {
            alert('Error: Gagal mengambil data dari server.');
        });
}
</script>
<?php $__env->stopPush(); ?>



<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /www/wwwroot/pkkm.pitchoiriyah.my.id/resources/views/pengawas/penilaian/show.blade.php ENDPATH**/ ?>