<?php $__env->startSection('title', 'Edit Lembaga'); ?>

<?php $__env->startSection('breadcrumb'); ?>
<li class="breadcrumb-item"><a href="<?php echo e(route('pengawas.lembaga.index')); ?>">Lembaga</a></li>
<li class="breadcrumb-item active">Edit</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            <i class="fas fa-school"></i> Edit Lembaga: <?php echo e($lembaga->nama_lembaga); ?>

        </h3>
        <div class="card-tools">
            <a href="<?php echo e(route('pengawas.lembaga.index')); ?>" class="btn btn-secondary btn-sm">
                <i class="fas fa-arrow-left"></i> Kembali
            </a>
        </div>
    </div>
    <div class="card-body">
        <form action="<?php echo e(route('pengawas.lembaga.update', $lembaga)); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>
            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="npsn_nsm">NPSN/NSM <span class="text-danger">*</span></label>
                        <input type="text" class="form-control <?php $__errorArgs = ['npsn_nsm'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="npsn_nsm" name="npsn_nsm" value="<?php echo e(old('npsn_nsm', $lembaga->npsn_nsm)); ?>" required>
                        <?php $__errorArgs = ['npsn_nsm'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        <small class="form-text text-muted">NPSN/NSM harus unik untuk pengawas ini</small>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="nama_lembaga">Nama Lembaga <span class="text-danger">*</span></label>
                        <input type="text" class="form-control <?php $__errorArgs = ['nama_lembaga'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="nama_lembaga" name="nama_lembaga" value="<?php echo e(old('nama_lembaga', $lembaga->nama_lembaga)); ?>" required>
                        <?php $__errorArgs = ['nama_lembaga'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="jenis">Jenis Lembaga <span class="text-danger">*</span></label>
                        <select class="form-control <?php $__errorArgs = ['jenis'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="jenis" name="jenis" required>
                            <option value="">Pilih Jenis</option>
                            <option value="RA" <?php echo e(old('jenis', $lembaga->jenis) == 'RA' ? 'selected' : ''); ?>>RA (Raudhatul Athfal)</option>
                            <option value="MI" <?php echo e(old('jenis', $lembaga->jenis) == 'MI' ? 'selected' : ''); ?>>MI (Madrasah Ibtidaiyah)</option>
                            <option value="MTs" <?php echo e(old('jenis', $lembaga->jenis) == 'MTs' ? 'selected' : ''); ?>>MTs (Madrasah Tsanawiyah)</option>
                            <option value="MA" <?php echo e(old('jenis', $lembaga->jenis) == 'MA' ? 'selected' : ''); ?>>MA (Madrasah Aliyah)</option>
                        </select>
                        <?php $__errorArgs = ['jenis'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="akreditasi">Akreditasi</label>
                        <input type="text" class="form-control <?php $__errorArgs = ['akreditasi'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="akreditasi" name="akreditasi" value="<?php echo e(old('akreditasi', $lembaga->akreditasi)); ?>" placeholder="A, B, C, atau TT">
                        <?php $__errorArgs = ['akreditasi'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <label for="alamat_lengkap">Alamat Lengkap <span class="text-danger">*</span></label>
                <textarea class="form-control <?php $__errorArgs = ['alamat_lengkap'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="alamat_lengkap" name="alamat_lengkap" rows="3" required><?php echo e(old('alamat_lengkap', $lembaga->alamat_lengkap)); ?></textarea>
                <?php $__errorArgs = ['alamat_lengkap'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="row">
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="provinsi">Provinsi <span class="text-danger">*</span></label>
                        <select class="form-control <?php $__errorArgs = ['provinsi'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="provinsi" name="provinsi" required>
                            <option value="">Pilih Provinsi</option>
                        </select>
                        <?php $__errorArgs = ['provinsi'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="kabupaten">Kabupaten <span class="text-danger">*</span></label>
                        <select class="form-control <?php $__errorArgs = ['kabupaten'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="kabupaten" name="kabupaten" required disabled>
                            <option value="">Pilih Kabupaten</option>
                        </select>
                        <?php $__errorArgs = ['kabupaten'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="kecamatan">Kecamatan <span class="text-danger">*</span></label>
                        <select class="form-control <?php $__errorArgs = ['kecamatan'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="kecamatan" name="kecamatan" required disabled>
                            <option value="">Pilih Kecamatan</option>
                        </select>
                        <?php $__errorArgs = ['kecamatan'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="kelurahan">Kelurahan <span class="text-danger">*</span></label>
                        <select class="form-control <?php $__errorArgs = ['kelurahan'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="kelurahan" name="kelurahan" required disabled>
                            <option value="">Pilih Kelurahan</option>
                        </select>
                        <?php $__errorArgs = ['kelurahan'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="kode_pos">Kode Pos</label>
                        <input type="text" class="form-control <?php $__errorArgs = ['kode_pos'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="kode_pos" name="kode_pos" value="<?php echo e(old('kode_pos', $lembaga->kode_pos)); ?>">
                        <?php $__errorArgs = ['kode_pos'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="telepon">Telepon</label>
                        <input type="text" class="form-control <?php $__errorArgs = ['telepon'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="telepon" name="telepon" value="<?php echo e(old('telepon', $lembaga->telepon)); ?>">
                        <?php $__errorArgs = ['telepon'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="email">Email</label>
                        <input type="email" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="email" name="email" value="<?php echo e(old('email', $lembaga->email)); ?>">
                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="tahun_berdiri">Tahun Berdiri</label>
                        <input type="number" class="form-control <?php $__errorArgs = ['tahun_berdiri'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="tahun_berdiri" name="tahun_berdiri" value="<?php echo e(old('tahun_berdiri', $lembaga->tahun_berdiri)); ?>" min="1900" max="<?php echo e(date('Y')); ?>">
                        <?php $__errorArgs = ['tahun_berdiri'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="nama_kepala">Nama Kepala <span class="text-danger">*</span></label>
                        <input type="text" class="form-control <?php $__errorArgs = ['nama_kepala'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="nama_kepala" name="nama_kepala" value="<?php echo e(old('nama_kepala', $lembaga->nama_kepala)); ?>" required>
                        <?php $__errorArgs = ['nama_kepala'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="nip_kepala">NIP Kepala <span class="text-danger">*</span></label>
                        <input type="text" class="form-control <?php $__errorArgs = ['nip_kepala'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="nip_kepala" name="nip_kepala" value="<?php echo e(old('nip_kepala', $lembaga->nip_kepala)); ?>" required>
                        <?php $__errorArgs = ['nip_kepala'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <label for="website">Website</label>
                <input type="url" class="form-control <?php $__errorArgs = ['website'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="website" name="website" value="<?php echo e(old('website', $lembaga->website)); ?>" placeholder="https://">
                <?php $__errorArgs = ['website'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="form-group">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> Update
                </button>
                <a href="<?php echo e(route('pengawas.lembaga.index')); ?>" class="btn btn-secondary">
                    <i class="fas fa-times"></i> Batal
                </a>
            </div>
        </form>
    </div>
</div>

<!-- Hidden inputs to store current values -->
<input type="hidden" id="current_provinsi" value="<?php echo e(old('provinsi', $lembaga->provinsi)); ?>">
<input type="hidden" id="current_kabupaten" value="<?php echo e(old('kabupaten', $lembaga->kabupaten)); ?>">
<input type="hidden" id="current_kecamatan" value="<?php echo e(old('kecamatan', $lembaga->kecamatan)); ?>">
<input type="hidden" id="current_kelurahan" value="<?php echo e(old('kelurahan', $lembaga->kelurahan)); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function() {
    const currentProvinsi = $('#current_provinsi').val();
    const currentKabupaten = $('#current_kabupaten').val();
    const currentKecamatan = $('#current_kecamatan').val();
    const currentKelurahan = $('#current_kelurahan').val();

    // Load provinces
    loadProvinces();

    // Load provinces function
    function loadProvinces() {
        $.get('/api/wilayah/provinsi', function(data) {
            const provinsiSelect = $('#provinsi');
            provinsiSelect.empty().append('<option value="">Pilih Provinsi</option>');
            
            $.each(data, function(index, provinsi) {
                const selected = (provinsi.id == currentProvinsi) ? 'selected' : '';
                provinsiSelect.append(`<option value="${provinsi.id}" ${selected}>${provinsi.name}</option>`);
            });

            if (currentProvinsi) {
                loadKabupaten(currentProvinsi);
            }
        });
    }

    // Load kabupaten function
    function loadKabupaten(provinsiId) {
        if (!provinsiId) {
            $('#kabupaten').empty().append('<option value="">Pilih Kabupaten</option>').prop('disabled', true);
            $('#kecamatan').empty().append('<option value="">Pilih Kecamatan</option>').prop('disabled', true);
            $('#kelurahan').empty().append('<option value="">Pilih Kelurahan</option>').prop('disabled', true);
            return;
        }

        $.get('/api/wilayah/kabupaten', {province_id: provinsiId}, function(data) {
            const kabupatenSelect = $('#kabupaten');
            kabupatenSelect.empty().append('<option value="">Pilih Kabupaten</option>');
            
            $.each(data, function(index, kabupaten) {
                const selected = (kabupaten.id == currentKabupaten) ? 'selected' : '';
                kabupatenSelect.append(`<option value="${kabupaten.id}" ${selected}>${kabupaten.name}</option>`);
            });

            kabupatenSelect.prop('disabled', false);

            if (currentKabupaten) {
                loadKecamatan(currentKabupaten);
            }
        });
    }

    // Load kecamatan function
    function loadKecamatan(kabupatenId) {
        if (!kabupatenId) {
            $('#kecamatan').empty().append('<option value="">Pilih Kecamatan</option>').prop('disabled', true);
            $('#kelurahan').empty().append('<option value="">Pilih Kelurahan</option>').prop('disabled', true);
            return;
        }

        $.get('/api/wilayah/kecamatan', {regency_id: kabupatenId}, function(data) {
            const kecamatanSelect = $('#kecamatan');
            kecamatanSelect.empty().append('<option value="">Pilih Kecamatan</option>');
            
            $.each(data, function(index, kecamatan) {
                const selected = (kecamatan.id == currentKecamatan) ? 'selected' : '';
                kecamatanSelect.append(`<option value="${kecamatan.id}" ${selected}>${kecamatan.name}</option>`);
            });

            kecamatanSelect.prop('disabled', false);

            if (currentKecamatan) {
                loadKelurahan(currentKecamatan);
            }
        });
    }

    // Load kelurahan function
    function loadKelurahan(kecamatanId) {
        if (!kecamatanId) {
            $('#kelurahan').empty().append('<option value="">Pilih Kelurahan</option>').prop('disabled', true);
            return;
        }

        $.get('/api/wilayah/kelurahan', {district_id: kecamatanId}, function(data) {
            const kelurahanSelect = $('#kelurahan');
            kelurahanSelect.empty().append('<option value="">Pilih Kelurahan</option>');
            
            $.each(data, function(index, kelurahan) {
                const selected = (kelurahan.id == currentKelurahan) ? 'selected' : '';
                kelurahanSelect.append(`<option value="${kelurahan.id}" ${selected}>${kelurahan.name}</option>`);
            });

            kelurahanSelect.prop('disabled', false);
        });
    }

    // Event handlers for cascading dropdowns
    $('#provinsi').on('change', function() {
        const provinsiId = $(this).val();
        loadKabupaten(provinsiId);
        $('#kecamatan').empty().append('<option value="">Pilih Kecamatan</option>').prop('disabled', true);
        $('#kelurahan').empty().append('<option value="">Pilih Kelurahan</option>').prop('disabled', true);
    });

    $('#kabupaten').on('change', function() {
        const kabupatenId = $(this).val();
        loadKecamatan(kabupatenId);
        $('#kelurahan').empty().append('<option value="">Pilih Kelurahan</option>').prop('disabled', true);
    });

    $('#kecamatan').on('change', function() {
        const kecamatanId = $(this).val();
        loadKelurahan(kecamatanId);
    });
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /www/wwwroot/pkkm.pitchoiriyah.my.id/resources/views/pengawas/lembaga/edit.blade.php ENDPATH**/ ?>