<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo e(\App\Helpers\AppHelper::getAppName()); ?> — Penilaian Kinerja Kepala Madrasah</title>

    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css"/>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css"/>
    <style>
        :root { --primary: #2563eb; --accent: #22c55e; --ocean1:#00b4db; --ocean2:#0077b6; }
        body { font-family: Inter, system-ui, -apple-system, Segoe UI, Roboto, Ubuntu, Cantarell, Noto Sans, Helvetica Neue, Arial, "Apple Color Emoji", "Segoe UI Emoji"; }
        .gradient-hero { background: radial-gradient(1200px 600px at 0% -20%, rgba(59,130,246,.15), transparent 50%), radial-gradient(1200px 600px at 100% 0%, rgba(96,165,250,.15), transparent 50%), linear-gradient(180deg, #eaf2ff 0%, #ffffff 60%); }
        .hero-title { letter-spacing: -.02em; }
        .glass { backdrop-filter: blur(10px); background: rgba(255,255,255,0.85); border: 1px solid rgba(30,64,175,0.15); }
        .feature-icon { width: 44px; height: 44px; border-radius: 50% !important; display: grid; place-items: center; }
        .shadow-soft { box-shadow: 0 10px 30px rgba(2, 8, 23, .1); }
        .btn-login { background: linear-gradient(135deg, var(--ocean1), var(--ocean2)); border: none; color: #0b132b; }
        .btn-login:hover { filter: brightness(0.95); }
        .badge-soft { background: rgba(59,130,246,.12); color: #1e40af; border: 1px solid rgba(96,165,250,.45); }
    </style>
</head>
<body class="bg-white text-dark">
    <header class="gradient-hero text-dark pb-5">
        <nav class="navbar navbar-expand-lg navbar-light container py-3">
            <a class="navbar-brand d-flex align-items-center gap-2" href="#">
                <img src="<?php echo e(\App\Helpers\AppHelper::getAppLogo()); ?>" alt="Logo" class="rounded-circle" style="width:32px;height:32px;object-fit:cover;">
                <strong><?php echo e(\App\Helpers\AppHelper::getAppName()); ?></strong>
            </a>
            <div class="ms-auto d-flex align-items-center gap-2">
                <span class="badge badge-soft rounded-pill px-3 py-2 small">Penilaian Kinerja Kepala Madrasah</span>
                <button class="btn btn-login px-4 py-2" data-bs-toggle="modal" data-bs-target="#loginModal">
                    <i class="fa-solid fa-right-to-bracket me-2"></i>Masuk
                </button>
            </div>
        </nav>

        <section class="container pt-4 pt-lg-5 pb-4">
            <div class="row align-items-center g-4 g-lg-5">
                <div class="col-lg-7">
                    <h1 class="display-5 fw-bold hero-title">Bangun Mutu Kepemimpinan Madrasah yang Terukur dan Transparan</h1>
                    <p class="lead text-secondary mt-3">Platform ini membantu pengawas menilai kinerja kepala madrasah secara objektif dan terstruktur, sekaligus menjadi ruang refleksi bagi kepala untuk meningkatkan kualitas kepemimpinan, tata kelola, dan layanan pendidikan.</p>
                    <div class="d-flex flex-wrap gap-2 mt-3">
                        <a href="#fitur" class="btn btn-outline-primary px-4"><i class="fa-solid fa-circle-info me-2"></i>Pelajari</a>
                        <button class="btn btn-login px-4" data-bs-toggle="modal" data-bs-target="#loginModal"><i class="fa-solid fa-user-shield me-2"></i>Masuk sebagai Admin/Pengawas/Kepala</button>
                    </div>
                </div>
                <div class="col-lg-5">
                    <div class="glass rounded-4 p-4 shadow-soft">
                        <div class="d-flex align-items-center mb-3">
                            <div class="feature-icon bg-light bg-opacity-10 me-3"><i class="fa-solid fa-crown text-warning"></i></div>
                            <div>
                                <h5 class="mb-1 text-dark">Peran Kepala</h5>
                                <p class="mb-0 text-secondary small">Pemimpin pembelajaran, penggerak budaya mutu, dan manajer sumber daya.</p>
                            </div>
                        </div>
                        <div class="d-flex align-items-center mb-3">
                            <div class="feature-icon bg-light bg-opacity-10 me-3"><i class="fa-solid fa-list-check text-info"></i></div>
                            <div>
                                <h5 class="mb-1 text-dark">Tujuan Penilaian</h5>
                                <p class="mb-0 text-secondary small">Memberi umpan balik komprehensif untuk pengembangan berkelanjutan (PDCA).</p>
                            </div>
                        </div>
                        <div class="d-flex align-items-center">
                            <div class="feature-icon bg-light bg-opacity-10 me-3"><i class="fa-solid fa-shield-heart text-success"></i></div>
                            <div>
                                <h5 class="mb-1 text-dark">Prinsip</h5>
                                <p class="mb-0 text-secondary small">Objektif, transparan, akuntabel, berfokus pada peningkatan layanan peserta didik.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </header>

    <main class="container my-5" id="fitur">
        <div class="row g-4">
            <div class="col-md-4">
                <div class="card bg-white border-0 glass h-100">
                    <div class="card-body">
                        <div class="feature-icon bg-primary bg-opacity-10 mb-3"><i class="fa-solid fa-chart-line text-primary"></i></div>
                        <h5 class="card-title">Instrumen Terstruktur</h5>
                        <p class="text-muted">Indikator kinerja yang jelas meliputi kepemimpinan pembelajaran, manajemen, supervisi, dan pengembangan budaya mutu.</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card bg-white border-0 glass h-100">
                    <div class="card-body">
                        <div class="feature-icon bg-primary bg-opacity-10 mb-3"><i class="fa-solid fa-folder-open text-primary"></i></div>
                        <h5 class="card-title">Dokumentasi & Bukti</h5>
                        <p class="text-muted">Unggah bukti relevan untuk setiap indikator sehingga penilaian dapat dipertanggungjawabkan.</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card bg-white border-0 glass h-100">
                    <div class="card-body">
                        <div class="feature-icon bg-warning bg-opacity-10 mb-3"><i class="fa-solid fa-lightbulb text-warning"></i></div>
                        <h5 class="card-title">Umpan Balik Adaptif</h5>
                        <p class="text-muted">Catatan perbaikan yang spesifik dan terarah membantu kepala menyusun rencana tindak lanjut yang nyata.</p>
                    </div>
                </div>
            </div>
        </div>

        <div class="text-center mt-5">
            <button class="btn btn-login px-5 py-3" data-bs-toggle="modal" data-bs-target="#loginModal">
                <i class="fa-solid fa-right-to-bracket me-2"></i>Masuk untuk Memulai
            </button>
        </div>
    </main>

    <footer class="py-5 text-center text-muted">
        <div><?php echo e(\App\Helpers\AppHelper::getAppName()); ?> • <?php echo e(date('Y')); ?></div>
    </footer>

    <!-- Login Modal -->
    <div class="modal fade" id="loginModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content bg-white text-dark border-0">
                <div class="modal-header border-0">
                    <h5 class="modal-title"><i class="fa-solid fa-lock me-2"></i>Masuk</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form method="POST" action="<?php echo e(route('login')); ?>" id="loginForm">
                        <?php echo csrf_field(); ?>
                        <div class="mb-3">
                            <label for="email" class="form-label">Email</label>
                            <input id="email" type="email" class="form-control" name="email" required autofocus>
                        </div>
                        <div class="mb-3">
                            <label for="password" class="form-label">Password</label>
                            <input id="password" type="password" class="form-control" name="password" required>
                        </div>
                        <button type="submit" class="btn btn-login w-100 py-2">Masuk</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Auto open login modal when hash #login present (query ?login=1 disabled for consistency)
        (function() {
            const url = new URL(window.location.href);
            if (url.hash === '#login') {
                const modal = new bootstrap.Modal(document.getElementById('loginModal'));
                modal.show();
            }
        })();
    </script>
</body>
</html>


<?php /**PATH /www/wwwroot/pkkm.pitchoiriyah.my.id/resources/views/landing.blade.php ENDPATH**/ ?>