<?php $__env->startSection('title', 'Distribusi Instrumen Baru'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
<div class="card">
    <div class="card-header">
        <h3 class="card-title">
                        <i class="fas fa-plus"></i> Distribusi Instrumen Baru
        </h3>
        <div class="card-tools">
                        <a href="<?php echo e(route('pengawas.distribusi.index')); ?>" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Kembali
            </a>
        </div>
                </div>
                <form action="<?php echo e(route('pengawas.distribusi.store')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="card-body">
                        <?php if(session('error')): ?>
                            <div class="alert alert-danger alert-dismissible">
                                <button type="button" class="close" data-dismiss="alert">&times;</button>
                                <?php echo e(session('error')); ?>

                            </div>
                        <?php endif; ?>

                        <div class="row">
                            <!-- Instrumen Selection -->
                            <div class="col-md-6">
                                <div class="card">
                                    <div class="card-header">
                                        <h3 class="card-title">
                                            <i class="fas fa-clipboard-list"></i> Pilih Instrumen
                                        </h3>
    </div>
    <div class="card-body">
                                        <div class="form-group">
                                            <label for="instrumen_id">Instrumen <span class="text-danger">*</span></label>
                                            <select class="form-control <?php $__errorArgs = ['instrumen_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                    id="instrumen_id" name="instrumen_id" required>
                                                <option value="">Pilih Instrumen...</option>
                                                <?php $__currentLoopData = $instrumen; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($item->id); ?>" 
                                                            data-tahun="<?php echo e($item->tahun_ajaran); ?>"
                                                            data-semester="<?php echo e($item->semester); ?>"
                                                            data-deskripsi="<?php echo e($item->deskripsi); ?>">
                                                        <?php echo e($item->judul); ?> (<?php echo e($item->tahun_ajaran); ?> - Semester <?php echo e($item->semester); ?>)
                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                            <?php $__errorArgs = ['instrumen_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <!-- Jenis Distribusi -->
                                        <div class="form-group">
                                            <label>Jenis Distribusi <span class="text-danger">*</span></label>
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="jenis_distribusi" 
                                                       id="semua_komponen" value="semua_komponen" 
                                                       <?php echo e(old('jenis_distribusi', 'semua_komponen') == 'semua_komponen' ? 'checked' : ''); ?>>
                                                <label class="form-check-label" for="semua_komponen">
                                                    <strong>Semua Komponen</strong>
                                                    <br><small class="text-muted">Distribusikan semua komponen dalam instrumen ini</small>
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="jenis_distribusi" 
                                                       id="per_komponen" value="per_komponen"
                                                       <?php echo e(old('jenis_distribusi') == 'per_komponen' ? 'checked' : ''); ?>>
                                                <label class="form-check-label" for="per_komponen">
                                                    <strong>Per Komponen</strong>
                                                    <br><small class="text-muted">Pilih komponen tertentu saja untuk didistribusi</small>
                                                </label>
                                            </div>
                                            <?php $__errorArgs = ['jenis_distribusi'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <!-- Komponen Selection -->
                                        <div id="komponen-selection" class="form-group" style="display: none;">
                                            <label for="komponen_ids">Pilih Komponen <span class="text-danger">*</span></label>
                                            <div id="komponen-list" class="border rounded p-3" style="max-height: 200px; overflow-y: auto;">
                                                <div class="text-center text-muted py-3">
                                                    <i class="fas fa-spinner fa-spin"></i> Memuat komponen...
                                                </div>
                                            </div>
                                            <?php $__errorArgs = ['komponen_ids'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <!-- Instrumen Details -->
                                        <div id="instrumen-details" class="mt-3" style="display: none;">
        <div class="alert alert-info">
                                                <h6><i class="fas fa-info-circle"></i> Detail Instrumen:</h6>
                                                <div id="instrumen-info"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Deadline -->
                            <div class="col-md-6">
                                <div class="card">
                                    <div class="card-header">
                                        <h3 class="card-title">
                                            <i class="fas fa-calendar-alt"></i> Deadline
                                        </h3>
                                    </div>
                                    <div class="card-body">
                                        <div class="form-group">
                                            <label for="deadline">Deadline Pengisian <span class="text-danger">*</span></label>
                                            <input type="date" 
                                                   class="form-control <?php $__errorArgs = ['deadline'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                   id="deadline" 
                                                   name="deadline" 
                                                   value="<?php echo e(old('deadline', now()->addDays(30)->format('Y-m-d'))); ?>"
                                                   min="<?php echo e(now()->addDay()->format('Y-m-d')); ?>"
                                                   required>
                                            <?php $__errorArgs = ['deadline'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            <small class="form-text text-muted">
                                                Deadline minimal 1 hari dari hari ini
                                            </small>
                                        </div>

                                        <div class="form-group">
                                            <label>Durasi Pengisian:</label>
                                            <div class="input-group">
                                                <input type="number" id="duration" class="form-control" value="30" min="1" max="365">
                                                <div class="input-group-append">
                                                    <span class="input-group-text">hari</span>
                                                </div>
                                            </div>
                                            <small class="form-text text-muted">
                                                Klik "Set Deadline" untuk mengatur deadline otomatis
                                            </small>
                                            <button type="button" class="btn btn-sm btn-outline-primary mt-2" id="set-deadline">
                                                <i class="fas fa-calendar-plus"></i> Set Deadline
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Lembaga Selection -->
                        <div class="row mt-4">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header">
                                        <h3 class="card-title">
                                            <i class="fas fa-school"></i> Pilih Lembaga Binaan
                                        </h3>
                                        <div class="card-tools">
                                            <button type="button" class="btn btn-sm btn-outline-primary" id="select-all">
                                                <i class="fas fa-check-square"></i> Pilih Semua
                                            </button>
                                            <button type="button" class="btn btn-sm btn-outline-secondary" id="deselect-all">
                                                <i class="fas fa-square"></i> Batal Semua
                                            </button>
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        <?php $__errorArgs = ['lembaga_ids'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="alert alert-danger">
                                                <?php echo e($message); ?>

                                            </div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                        <div class="row">
                                            <?php $__empty_1 = true; $__currentLoopData = $lembaga; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <div class="col-md-6 col-lg-4 mb-3">
                                                <div class="card lembaga-card">
                                                    <div class="card-body">
                                                        <div class="form-check">
                                                            <input class="form-check-input lembaga-checkbox" 
                                                                   type="checkbox" 
                                                                   name="lembaga_ids[]" 
                                                                   value="<?php echo e($item->id); ?>" 
                                                                   id="lembaga_<?php echo e($item->id); ?>"
                                                                   <?php echo e(in_array($item->id, old('lembaga_ids', [])) ? 'checked' : ''); ?>>
                                                            <label class="form-check-label" for="lembaga_<?php echo e($item->id); ?>">
                                                                <strong><?php echo e($item->nama_lembaga); ?></strong>
                                                            </label>
                                                        </div>
                                                        <div class="mt-2">
                                                            <small class="text-muted">
                                                                <i class="fas fa-tag"></i> <?php echo e($item->jenis); ?><br>
                                                                <i class="fas fa-map-marker-alt"></i> <?php echo e($item->kecamatan_name ?? $item->kecamatan); ?><br>
                                                                <i class="fas fa-users"></i> <?php echo e($item->guru->count()); ?> guru
                                                            </small>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <div class="col-12">
                                                <div class="alert alert-warning">
                                                    <i class="fas fa-exclamation-triangle"></i>
                                                    <strong>Belum ada lembaga binaan!</strong>
                                                    <p class="mb-0">Anda belum diassign ke lembaga manapun. Hubungi admin untuk mengassign lembaga binaan.</p>
                                                </div>
                                            </div>
                                            <?php endif; ?>
                                        </div>

                                        <div class="mt-3">
                                            <small class="text-muted">
                                                <i class="fas fa-info-circle"></i>
                                                Total lembaga yang dipilih: <span id="selected-count">0</span>
                                            </small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card-footer">
                        <div class="d-flex justify-content-between">
                            <a href="<?php echo e(route('pengawas.distribusi.index')); ?>" class="btn btn-secondary">
                                <i class="fas fa-times"></i> Batal
                            </a>
                            <button type="submit" class="btn btn-primary" id="submit-btn" disabled>
                                <i class="fas fa-share-alt"></i> Distribusikan Instrumen
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function() {
    // Show instrument details when selected
    $('#instrumen_id').on('change', function() {
        const selectedOption = $(this).find('option:selected');
        const detailsDiv = $('#instrumen-details');
        const infoDiv = $('#instrumen-info');
        const komponenSelection = $('#komponen-selection');
        
        if ($(this).val()) {
            const tahun = selectedOption.data('tahun');
            const semester = selectedOption.data('semester');
            const deskripsi = selectedOption.data('deskripsi');
            
            infoDiv.html(`
                <strong>Tahun Ajaran:</strong> ${tahun}<br>
                <strong>Semester:</strong> ${semester}<br>
                <strong>Deskripsi:</strong> ${deskripsi || 'Tidak ada deskripsi'}
            `);
            detailsDiv.show();
            
            // Load komponen if per_komponen is selected
            if ($('#per_komponen').is(':checked')) {
                loadKomponen($(this).val());
            }
            
            validateForm();
        } else {
            detailsDiv.hide();
            komponenSelection.hide();
            validateForm();
        }
    });

    // Handle jenis distribusi change
    $('input[name="jenis_distribusi"]').on('change', function() {
        const komponenSelection = $('#komponen-selection');
        
        if ($(this).val() === 'per_komponen') {
            const instrumenId = $('#instrumen_id').val();
            if (instrumenId) {
                loadKomponen(instrumenId);
            }
            komponenSelection.show();
        } else {
            komponenSelection.hide();
        }
        
        validateForm();
    });

    // Load komponen via AJAX
    function loadKomponen(instrumenId) {
        const komponenList = $('#komponen-list');
        
        komponenList.html(`
            <div class="text-center text-muted py-3">
                <i class="fas fa-spinner fa-spin"></i> Memuat komponen...
            </div>
        `);

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        
        $.get('/pengawas/distribusi/komponen', { instrumen_id: instrumenId })
            .done(function(data) {
                if (data.length > 0) {
                    let html = '';
                    data.forEach(function(komponen) {
                        html += `
                            <div class="form-check">
                                <input class="form-check-input komponen-checkbox" type="checkbox" 
                                       name="komponen_ids[]" value="${komponen.id}" 
                                       id="komponen_${komponen.id}">
                                <label class="form-check-label" for="komponen_${komponen.id}">
                                    <strong>${komponen.nama_komponen}</strong>
                                    <br><small class="text-muted">${komponen.deskripsi || 'Tidak ada deskripsi'}</small>
                                </label>
                            </div>
                        `;
                    });
                    
                    html += `
                        <div class="mt-3">
                            <button type="button" class="btn btn-sm btn-outline-primary" id="select-all-komponen">
                                <i class="fas fa-check-square"></i> Pilih Semua
                            </button>
                            <button type="button" class="btn btn-sm btn-outline-secondary" id="deselect-all-komponen">
                                <i class="fas fa-square"></i> Batal Semua
                            </button>
                        </div>
                    `;
                    
                    komponenList.html(html);
                    
                    // Add event handlers for komponen selection
                    $('.komponen-checkbox').on('change', validateForm);
                    $('#select-all-komponen').on('click', function() {
                        $('.komponen-checkbox').prop('checked', true);
                        validateForm();
                    });
                    $('#deselect-all-komponen').on('click', function() {
                        $('.komponen-checkbox').prop('checked', false);
                        validateForm();
                    });
                } else {
                    komponenList.html(`
                        <div class="text-center text-muted py-3">
                            <i class="fas fa-exclamation-triangle"></i>
                            Tidak ada komponen untuk instrumen ini
                        </div>
                    `);
                }
            })
            .fail(function() {
                komponenList.html(`
                    <div class="text-center text-danger py-3">
                        <i class="fas fa-exclamation-circle"></i>
                        Gagal memuat komponen
                    </div>
                `);
            });
    }

    // Set deadline based on duration
    $('#set-deadline').on('click', function() {
        const duration = parseInt($('#duration').val());
        const deadline = new Date();
        deadline.setDate(deadline.getDate() + duration);
        $('#deadline').val(deadline.toISOString().split('T')[0]);
    });

    // Select all lembaga
    $('#select-all').on('click', function() {
        $('.lembaga-checkbox').prop('checked', true);
        updateSelectedCount();
        validateForm();
    });

    // Deselect all lembaga
    $('#deselect-all').on('click', function() {
        $('.lembaga-checkbox').prop('checked', false);
        updateSelectedCount();
        validateForm();
    });

    // Update selected count when checkbox changes
    $('.lembaga-checkbox').on('change', function() {
        updateSelectedCount();
        validateForm();
    });

    // Update selected count
    function updateSelectedCount() {
        const count = $('.lembaga-checkbox:checked').length;
        $('#selected-count').text(count);
    }

    // Validate form
    function validateForm() {
        const instrumenSelected = $('#instrumen_id').val() !== '';
        const lembagaSelected = $('.lembaga-checkbox:checked').length > 0;
        const deadlineSet = $('#deadline').val() !== '';
        
        // Check komponen selection if per_komponen is selected
        let komponenValid = true;
        if ($('#per_komponen').is(':checked')) {
            komponenValid = $('.komponen-checkbox:checked').length > 0;
        }
        
        $('#submit-btn').prop('disabled', !(instrumenSelected && lembagaSelected && deadlineSet && komponenValid));
    }

    // Initial validation
    validateForm();
    updateSelectedCount();

    // Validate on deadline change
    $('#deadline').on('change', validateForm);
});
</script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
<style>
.lembaga-card {
    border: 2px solid #e3e6f0;
    transition: all 0.3s ease;
}

.lembaga-card:hover {
    border-color: #5a5c69;
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(0,0,0,0.1);
}

.lembaga-checkbox:checked + label {
    color: #1cc88a !important;
}

.lembaga-card:has(.lembaga-checkbox:checked) {
    border-color: #1cc88a;
    background-color: #f8fff9;
}
</style>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /www/wwwroot/pkkm.pitchoiriyah.my.id/resources/views/pengawas/distribusi/create.blade.php ENDPATH**/ ?>