<?php $__env->startSection('title', 'Isi Instrumen - Kepala'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title"><i class="fas fa-edit"></i> Isi Instrumen Penilaian</h3>
                    <a href="<?php echo e(route('kepala.instrumen.show', $distribusi->id)); ?>" class="btn btn-secondary btn-sm"><i class="fas fa-arrow-left"></i> Kembali</a>
                </div>
                <div class="card-body">
                    <?php if(session('success')): ?>
                        <div class="alert alert-success alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            <?php echo e(session('success')); ?>

                        </div>
                    <?php endif; ?>

                    <div class="mb-3 d-flex justify-content-between align-items-center">
                        <div>
                            <strong>Instrumen:</strong> <?php echo e($distribusi->instrumen->judul); ?><br>
                            <small class="text-muted">Tahun <?php echo e($distribusi->instrumen->tahun_ajaran); ?> - Semester <?php echo e($distribusi->instrumen->semester); ?></small>
                        </div>
                        <div>
                            <span class="badge badge-<?php echo e($penilaian->status == 'draft' ? 'secondary' : ($penilaian->status == 'submitted' ? 'warning' : 'success')); ?>">
                                Status: <?php echo e(ucfirst($penilaian->status)); ?>

                            </span>
                        </div>
                    </div>
                    <?php if($penilaian->status != 'draft'): ?>
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle"></i> Penilaian telah <?php echo e($penilaian->status); ?>. Isian dikunci dan tidak dapat diubah.
                            <?php if(in_array($penilaian->status, ['submitted', 'revision'])): ?>
                                <form method="POST" action="<?php echo e(route('kepala.instrumen.ubah-status', $distribusi->id)); ?>" class="d-inline mt-2">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="status" value="draft">
                                    <button type="submit" class="btn btn-sm btn-warning" onclick="return confirm('Apakah Anda yakin ingin mengubah status kembali ke draft? Status akan diubah dan Anda dapat mengedit isian instrumen lagi.')">
                                        <i class="fas fa-undo"></i> Ubah Status ke Draft (Buka Edit)
                                    </button>
                                </form>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>

                    <form method="POST" action="<?php echo e(route('kepala.instrumen.isi.simpan', $distribusi->id)); ?>">
                        <?php echo csrf_field(); ?>
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <thead class="thead-light">
                                    <tr>
                                        <th width="6%">No</th>
                                        <th>Indikator</th>
                                        <th width="12%">Nilai Diri</th>
                                        <th width="24%">Bukti (URL)</th>
                                        <th width="24%">Keterangan Bukti</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $idx => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $jawaban = $jawabanMap[$item->id] ?? null;
                                        ?>
                                        <tr>
                                            <td class="text-center"><?php echo e(($items->currentPage() - 1) * $items->perPage() + $idx + 1); ?></td>
                                            <td>
                                                <div class="font-weight-bold"><?php echo e($item->indikator_kinerja); ?></div>
                                                <?php if($item->evidensi_kinerja): ?>
                                                    <small class="text-muted"><?php echo e($item->evidensi_kinerja); ?></small>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <input type="number" name="jawaban[<?php echo e($item->id); ?>][nilai_guru_self]" class="form-control" min="<?php echo e($item->skor_min); ?>" max="<?php echo e($item->skor_max); ?>" value="<?php echo e(old('jawaban.'.$item->id.'.nilai_guru_self', $jawaban->nilai_guru_self ?? '')); ?>" <?php echo e($penilaian->status != 'draft' ? 'disabled' : ''); ?>>
                                            </td>
                                            <td>
                                                <input type="url" name="jawaban[<?php echo e($item->id); ?>][url_bukti]" class="form-control" placeholder="https://" value="<?php echo e(old('jawaban.'.$item->id.'.url_bukti', $jawaban->url_bukti ?? '')); ?>" <?php echo e($penilaian->status != 'draft' ? 'disabled' : ''); ?>>
                                            </td>
                                            <td>
                                                <textarea name="jawaban[<?php echo e($item->id); ?>][keterangan_bukti]" class="form-control" rows="2" placeholder="Keterangan atau catatan" <?php echo e($penilaian->status != 'draft' ? 'disabled' : ''); ?>><?php echo e(old('jawaban.'.$item->id.'.keterangan_bukti', $jawaban->keterangan_bukti ?? '')); ?></textarea>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>

                        <div class="d-flex justify-content-between align-items-center mt-3">
                            <div>
                                <?php echo e($items->links('pagination::bootstrap-4')); ?>

                            </div>
                            <?php if($penilaian->status == 'draft'): ?>
                                <div class="btn-group">
                                    <button type="submit" name="submit_status" value="save" class="btn btn-primary"><i class="fas fa-save"></i> Simpan</button>
                                    <button type="submit" id="btnSubmit" name="submit_status" value="submitted" class="btn btn-success"><i class="fas fa-paper-plane"></i> Simpan & Submit</button>
                                </div>
                            <?php endif; ?>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const btnSubmit = document.getElementById('btnSubmit');
    if (btnSubmit) {
        btnSubmit.addEventListener('click', function(e) {
            if(!confirm('Apakah semua jawaban Anda sudah valid? Setelah Submit, isian akan dikunci dan tidak dapat diubah kecuali dikembalikan untuk revisi.')) {
                e.preventDefault();
            }
        });
    }
});
</script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /www/wwwroot/pkkm.pitchoiriyah.my.id/resources/views/kepala/instrumen/isi.blade.php ENDPATH**/ ?>