<?php $__env->startSection('title', 'Distribusi Instrumen'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-share-alt"></i> Distribusi Instrumen
                    </h3>
                    <div class="card-tools">
                        <a href="<?php echo e(route('pengawas.distribusi.create')); ?>" class="btn btn-primary">
                            <i class="fas fa-plus"></i> Distribusi Baru
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <?php if(session('success')): ?>
                        <div class="alert alert-success alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            <?php echo e(session('success')); ?>

                        </div>
                    <?php endif; ?>

                    <?php if(session('error')): ?>
                        <div class="alert alert-danger alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            <?php echo e(session('error')); ?>

                        </div>
                    <?php endif; ?>

                    <!-- Statistics Cards -->
                    <div class="row mb-4">
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-info">
                                <div class="inner">
                                    <h3><?php echo e($stats['total_distribusi']); ?></h3>
                                    <p>Total Distribusi</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-share-alt"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-success">
                                <div class="inner">
                                    <h3><?php echo e($stats['active_distribusi']); ?></h3>
                                    <p>Distribusi Aktif</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-play-circle"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-warning">
                                <div class="inner">
                                    <h3><?php echo e($stats['completed_penilaian']); ?></h3>
                                    <p>Penilaian Selesai</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-check-circle"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-secondary">
                                <div class="inner">
                                    <h3><?php echo e($stats['in_progress']); ?></h3>
                                    <p>Dalam Proses</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-clock"></i>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Distribusi Table -->
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th width="5%">No</th>
                                    <th>Instrumen</th>
                                    <th>Lembaga</th>
                                    <th>Tanggal Distribusi</th>
                                    <th>Deadline</th>
                                    <th>Status</th>
                                    <th>Progress Penilaian</th>
                                    <th width="15%">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $distribusi; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($loop->iteration + ($distribusi->currentPage() - 1) * $distribusi->perPage()); ?></td>
                                    <td>
                                        <strong><?php echo e($item->instrumen->judul); ?></strong>
                                        <br>
                                        <small class="text-muted"><?php echo e($item->instrumen->tahun_ajaran); ?> - Semester <?php echo e($item->instrumen->semester); ?></small>
                                        <?php if($item->komponen): ?>
                                            <br>
                                            <span class="badge badge-info">
                                                <i class="fas fa-puzzle-piece"></i> <?php echo e($item->komponen->nama_komponen); ?>

                                            </span>
                                        <?php else: ?>
                                            <br>
                                            <span class="badge badge-success">
                                                <i class="fas fa-check-circle"></i> Semua Komponen
                                            </span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <strong><?php echo e($item->lembaga->nama_lembaga); ?></strong>
                                        <br>
                                        <small class="text-muted"><?php echo e($item->lembaga->jenis); ?></small>
                                    </td>
                                    <td><?php echo e($item->tanggal_distribusi->format('d/m/Y')); ?></td>
                                    <td>
                                        <?php echo e($item->deadline->format('d/m/Y')); ?>

                                        <?php if($item->deadline->isPast() && $item->status == 'active'): ?>
                                            <br><small class="text-danger"><i class="fas fa-exclamation-triangle"></i> Terlambat</small>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($item->status == 'active'): ?>
                                            <span class="badge badge-success">Aktif</span>
                                        <?php else: ?>
                                            <span class="badge badge-secondary">Ditutup</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php
                                            $total = $item->penilaianKepala()->count();
                                            $completed = $item->penilaianKepala()->whereIn('status', ['validated', 'final'])->count();
                                            $percentage = $total > 0 ? round(($completed / $total) * 100, 1) : 0;
                                        ?>

                                        <div class="progress mb-1" style="height: 20px;">
                                            <div class="progress-bar" role="progressbar" style="width: <?php echo e($percentage); ?>%" aria-valuenow="<?php echo e($percentage); ?>" aria-valuemin="0" aria-valuemax="100">
                                                <?php echo e($percentage); ?>%
                                            </div>
                                        </div>
                                        <small class="text-muted"><?php echo e($completed); ?>/<?php echo e($total); ?> kepala</small>
                                    </td>
                                    <td>
                                        <a href="<?php echo e(route('pengawas.distribusi.show', $item->id)); ?>" class="btn btn-info btn-sm" title="Lihat Detail">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        
                                        <?php if($item->status == 'active'): ?>
                                            <form action="<?php echo e(route('pengawas.distribusi.close', $item->id)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Apakah Anda yakin ingin menutup distribusi ini?')">
                                                <?php echo csrf_field(); ?>
                                                <button type="submit" class="btn btn-warning btn-sm" title="Tutup Distribusi">
                                                    <i class="fas fa-lock"></i>
                                                </button>
                                            </form>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="8" class="text-center">
                                        <div class="py-4">
                                            <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                                            <h5 class="text-muted">Belum ada distribusi instrumen</h5>
                                            <p class="text-muted">Mulai dengan mendistribusikan instrumen ke lembaga binaan Anda.</p>
                                            <a href="<?php echo e(route('pengawas.distribusi.create')); ?>" class="btn btn-primary">
                                                <i class="fas fa-plus"></i> Distribusi Baru
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <?php if($distribusi->hasPages()): ?>
                    <div class="d-flex justify-content-center">
                        <?php echo e($distribusi->links('pagination::bootstrap-4-custom')); ?>

                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('styles'); ?>
<style>
    /* Hide duplicate pagination if any */
    .card-body > .d-flex:not(:last-child) nav,
    .card-body > nav:not(:last-of-type) {
        display: none !important;
    }
    
    /* Fix pagination arrow button sizes - make all buttons consistent */
    .pagination .page-link {
        min-width: 38px;
        text-align: center;
        padding: 0.5rem 0.75rem;
        font-size: 0.875rem !important;
        line-height: 1.5;
        display: inline-flex;
        align-items: center;
        justify-content: center;
    }
    
    /* Specifically target first and last buttons (prev/next arrows) */
    .pagination .page-item:first-child .page-link,
    .pagination .page-item:last-child .page-link {
        min-width: 38px;
        max-width: 38px;
        font-size: 0.875rem !important;
        padding: 0.5rem 0.5rem;
        font-weight: normal;
    }
    
    /* Ensure all page links have same height */
    .pagination .page-item {
        height: 38px;
    }
    
    .pagination .page-item .page-link {
        height: 38px;
    }
    
    /* Hide duplicate navigation elements */
    .card-body nav ~ nav,
    .d-flex nav ~ nav {
        display: none !important;
    }
</style>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function() {
    // Auto-hide alerts after 5 seconds
    setTimeout(function() {
        $('.alert').fadeOut('slow');
    }, 5000);
});
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /www/wwwroot/pkkm.pitchoiriyah.my.id/resources/views/pengawas/distribusi/index.blade.php ENDPATH**/ ?>