<?php $__env->startSection('title', 'Detail Instrumen Penilaian'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-eye"></i> Detail Instrumen Penilaian
                    </h3>
                    <div class="card-tools">
                        <a href="<?php echo e(route('kepala.instrumen.index')); ?>" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Kembali
                        </a>
                        <a href="<?php echo e(route('kepala.instrumen.isi', $distribusi->id)); ?>" class="btn btn-success">
                            <i class="fas fa-edit"></i> Isi Instrumen
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <?php if(session('success')): ?>
                        <div class="alert alert-success alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            <?php echo e(session('success')); ?>

                        </div>
                    <?php endif; ?>

                    <!-- Instrumen Information -->
                    <div class="row mb-4">
                        <div class="col-md-8">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">
                                        <i class="fas fa-info-circle"></i> Informasi Instrumen
                                    </h4>
                                </div>
                                <div class="card-body">
                                    <dl class="row">
                                        <dt class="col-sm-3">Judul Instrumen:</dt>
                                        <dd class="col-sm-9">
                                            <strong><?php echo e($distribusi->instrumen->judul); ?></strong>
                                        </dd>

                                        <dt class="col-sm-3">Tahun Ajaran:</dt>
                                        <dd class="col-sm-9"><?php echo e($distribusi->instrumen->tahun_ajaran); ?> - Semester <?php echo e($distribusi->instrumen->semester); ?></dd>

                                        <?php if($distribusi->instrumen->deskripsi): ?>
                                        <dt class="col-sm-3">Deskripsi:</dt>
                                        <dd class="col-sm-9"><?php echo e($distribusi->instrumen->deskripsi); ?></dd>
                                        <?php endif; ?>

                                        <dt class="col-sm-3">Tanggal Distribusi:</dt>
                                        <dd class="col-sm-9"><?php echo e($distribusi->tanggal_distribusi->format('d F Y')); ?></dd>

                                        <dt class="col-sm-3">Deadline:</dt>
                                        <dd class="col-sm-9">
                                            <?php echo e($distribusi->deadline->format('d F Y')); ?>

                                            <?php if($distribusi->deadline->isPast() && $distribusi->status == 'active'): ?>
                                                <span class="badge badge-danger ml-2">Terlambat</span>
                                            <?php elseif($distribusi->deadline->diffInDays() <= 7 && $distribusi->status == 'active'): ?>
                                                <span class="badge badge-warning ml-2">Mendekati Deadline</span>
                                            <?php endif; ?>
                                        </dd>

                                        <dt class="col-sm-3">Komponen:</dt>
                                        <dd class="col-sm-9">
                                            <?php if($distribusi->komponen): ?>
                                                <span class="badge badge-info">
                                                    <i class="fas fa-puzzle-piece"></i> <?php echo e($distribusi->komponen->nama_komponen); ?>

                                                </span>
                                                <?php if($distribusi->komponen->deskripsi): ?>
                                                    <br><small class="text-muted"><?php echo e($distribusi->komponen->deskripsi); ?></small>
                                                <?php endif; ?>
                                            <?php else: ?>
                                                <span class="badge badge-success">
                                                    <i class="fas fa-check-circle"></i> Semua Komponen
                                                </span>
                                            <?php endif; ?>
                                        </dd>

                                        <dt class="col-sm-3">Status:</dt>
                                        <dd class="col-sm-9">
                                            <?php if($distribusi->status == 'active'): ?>
                                                <span class="badge badge-success">Aktif</span>
                                            <?php else: ?>
                                                <span class="badge badge-secondary">Ditutup</span>
                                            <?php endif; ?>
                                        </dd>
                                    </dl>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">
                                        <i class="fas fa-chart-pie"></i> Statistik Penilaian
                                    </h4>
                                </div>
                                <div class="card-body">
                                    <div class="row text-center">
                                        <div class="col-6">
                                            <div class="border-right">
                                                <h3 class="text-primary"><?php echo e($penilaianStats['total_kepala']); ?></h3>
                                                <small class="text-muted">Total Penilaian</small>
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <h3 class="text-warning"><?php echo e($penilaianStats['submitted']); ?></h3>
                                            <small class="text-muted">Menunggu Review</small>
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="row">
                                        <div class="col-6">
                                            <small class="text-muted">
                                                <i class="fas fa-clock text-secondary"></i> Draft: <?php echo e($penilaianStats['draft']); ?>

                                            </small>
                                        </div>
                                        <div class="col-6">
                                            <small class="text-muted">
                                                <i class="fas fa-paper-plane text-warning"></i> Submitted: <?php echo e($penilaianStats['submitted']); ?>

                                            </small>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-6">
                                            <small class="text-muted">
                                                <i class="fas fa-edit text-warning"></i> Revision: <?php echo e($penilaianStats['revision']); ?>

                                            </small>
                                        </div>
                                        <div class="col-6">
                                            <small class="text-muted">
                                                <i class="fas fa-check-circle text-success"></i> Validated: <?php echo e($penilaianStats['validated']); ?>

                                            </small>
                                        </div>
                                    </div>
                                    
                                    <?php if($penilaianStats['total_kepala'] > 0): ?>
                                    <?php
                                        $percentage = round(($penilaianStats['validated'] / $penilaianStats['total_kepala']) * 100, 1);
                                    ?>
                                    <div class="mt-3">
                                        <div class="progress" style="height: 20px;">
                                            <div class="progress-bar bg-success" role="progressbar" style="width: <?php echo e($percentage); ?>%" aria-valuenow="<?php echo e($percentage); ?>" aria-valuemin="0" aria-valuemax="100">
                                                <?php echo e($percentage); ?>%
                                            </div>
                                        </div>
                                        <small class="text-muted">Progress Penyelesaian</small>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Struktur Instrumen Hierarkis -->
                    <div class="card mb-4">
                        <div class="card-header">
                            <h4 class="card-title">
                                <i class="fas fa-list-alt"></i> Struktur Instrumen Penilaian
                            </h4>
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <?php if($distribusi->komponen): ?>
                                <!-- Per Komponen Distribution -->
                                <div class="table-responsive">
                                    <table class="table table-bordered table-hover">
                                        <thead class="thead-dark">
                                            <tr>
                                                <th width="8%">No</th>
                                                <th width="35%">Indikator Kerja</th>
                                                <th width="30%">Evidensi Kerja</th>
                                                <th width="8%">Skor Min</th>
                                                <th width="8%">Skor Max</th>
                                                <th width="11%">Jenis</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                                $komponenLetters = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J'];
                                            ?>
                                            
                                            <!-- Komponen Row (Level Tertinggi) -->
                                            <tr class="table-dark">
                                                <td><strong>1</strong></td>
                                                <td>
                                                    <strong><?php echo e($distribusi->komponen->nama_komponen); ?></strong>
                                                    <?php if($distribusi->komponen->deskripsi): ?>
                                                        <br><small class="text-muted"><?php echo e($distribusi->komponen->deskripsi); ?></small>
                                                    <?php endif; ?>
                                                </td>
                                                <td colspan="3">
                                                    <span class="badge badge-dark">Komponen</span>
                                                    <span class="badge badge-secondary"><?php echo e($distribusi->komponen->subKomponens->count()); ?> Sub Komponen</span>
                                                </td>
                                                <td>
                                                    <span class="badge badge-dark">Komponen</span>
                                                </td>
                                            </tr>
                                            
                                            <?php $__currentLoopData = $distribusi->komponen->subKomponens; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subKomponenIndex => $subKomponen): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <!-- Sub Komponen Row (A, B, C, dst.) -->
                                                <tr class="table-primary">
                                                    <td><strong><?php echo e($komponenLetters[$subKomponenIndex]); ?></strong></td>
                                                    <td>
                                                        <strong><?php echo e($subKomponen->nama_sub_komponen); ?></strong>
                                                        <?php if($subKomponen->deskripsi): ?>
                                                            <br><small class="text-muted"><?php echo e($subKomponen->deskripsi); ?></small>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td colspan="3">
                                                        <span class="badge badge-info">Sub Komponen</span>
                                                        <span class="badge badge-light"><?php echo e($subKomponen->instrumenPenilaians->count()); ?> Instrumen</span>
                                                    </td>
                                                    <td>
                                                        <span class="badge badge-primary">Sub Komponen</span>
                                                    </td>
                                                </tr>
                                                
                                                <?php $__currentLoopData = $subKomponen->instrumenPenilaians; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <!-- Instrumen Row (A1, A2, A3, dst.) -->
                                                    <tr class="table-light">
                                                        <td>
                                                            <strong><?php echo e($komponenLetters[$subKomponenIndex]); ?><?php echo e($item->no_urutan); ?></strong>
                                                        </td>
                                                        <td>
                                                            <div class="text-sm">
                                                                <strong><?php echo e($item->indikator_kinerja); ?></strong>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <div class="text-sm">
                                                                <?php echo e($item->evidensi_kinerja ?: '-'); ?>

                                                            </div>
                                                        </td>
                                                        <td class="text-center">
                                                            <span class="badge badge-success"><?php echo e($item->skor_min); ?></span>
                                                        </td>
                                                        <td class="text-center">
                                                            <span class="badge badge-danger"><?php echo e($item->skor_max); ?></span>
                                                        </td>
                                                        <td>
                                                            <span class="badge badge-light">Instrumen</span>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php else: ?>
                                <!-- Semua Komponen Distribution -->
                                <div class="table-responsive">
                                    <table class="table table-bordered table-hover">
                                        <thead class="thead-dark">
                                            <tr>
                                                <th width="8%">No</th>
                                                <th width="35%">Indikator Kerja</th>
                                                <th width="30%">Evidensi Kerja</th>
                                                <th width="8%">Skor Min</th>
                                                <th width="8%">Skor Max</th>
                                                <th width="11%">Jenis</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                                $komponenLetters = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J'];
                                            ?>
                                            
                                            <?php $__currentLoopData = $distribusi->instrumen->komponenPenilaians; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $komponenIndex => $komponen): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <!-- Komponen Row (Level Tertinggi) -->
                                                <tr class="table-dark">
                                                    <td><strong><?php echo e($komponenIndex + 1); ?></strong></td>
                                                    <td>
                                                        <strong><?php echo e($komponen->nama_komponen); ?></strong>
                                                        <?php if($komponen->deskripsi): ?>
                                                            <br><small class="text-muted"><?php echo e($komponen->deskripsi); ?></small>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td colspan="3">
                                                        <span class="badge badge-dark">Komponen</span>
                                                        <span class="badge badge-secondary"><?php echo e($komponen->subKomponens->count()); ?> Sub Komponen</span>
                                                    </td>
                                                    <td>
                                                        <span class="badge badge-dark">Komponen</span>
                                                    </td>
                                                </tr>
                                                
                                                <?php $__currentLoopData = $komponen->subKomponens; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subKomponenIndex => $subKomponen): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <!-- Sub Komponen Row (A, B, C, dst.) -->
                                                    <tr class="table-primary">
                                                        <td><strong><?php echo e($komponenLetters[$subKomponenIndex]); ?></strong></td>
                                                        <td>
                                                            <strong><?php echo e($subKomponen->nama_sub_komponen); ?></strong>
                                                            <?php if($subKomponen->deskripsi): ?>
                                                                <br><small class="text-muted"><?php echo e($subKomponen->deskripsi); ?></small>
                                                            <?php endif; ?>
                                                        </td>
                                                        <td colspan="3">
                                                            <span class="badge badge-info">Sub Komponen</span>
                                                            <span class="badge badge-light"><?php echo e($subKomponen->instrumenPenilaians->count()); ?> Instrumen</span>
                                                        </td>
                                                        <td>
                                                            <span class="badge badge-primary">Sub Komponen</span>
                                                        </td>
                                                    </tr>
                                                    
                                                    <?php $__currentLoopData = $subKomponen->instrumenPenilaians; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <!-- Instrumen Row (A1, A2, A3, dst.) -->
                                                        <tr class="table-light">
                                                            <td>
                                                                <strong><?php echo e($komponenLetters[$subKomponenIndex]); ?><?php echo e($item->no_urutan); ?></strong>
                                                            </td>
                                                            <td>
                                                                <div class="text-sm">
                                                                    <strong><?php echo e($item->indikator_kinerja); ?></strong>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="text-sm">
                                                                    <?php echo e($item->evidensi_kinerja ?: '-'); ?>

                                                                </div>
                                                            </td>
                                                            <td class="text-center">
                                                                <span class="badge badge-success"><?php echo e($item->skor_min); ?></span>
                                                            </td>
                                                            <td class="text-center">
                                                                <span class="badge badge-danger"><?php echo e($item->skor_max); ?></span>
                                                            </td>
                                                            <td>
                                                                <span class="badge badge-light">Instrumen</span>
                                                            </td>
                                                        </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- Penilaian Kepala (oleh Pengawas) -->
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">
                                <i class="fas fa-users"></i> Status Penilaian Kepala
                            </h4>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th width="5%">No</th>
                                            <th>Pengawas Penilai</th>
                                            <th>Status</th>
                                            <th>Tanggal Submit</th>
                                            <th>Nilai</th>
                                            <th width="15%">Aksi</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__empty_1 = true; $__currentLoopData = $penilaianGuru; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $penilaian): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td><?php echo e($loop->iteration); ?></td>
                                            <td>
                                                <strong><?php echo e($penilaian->pengawas?->name ?? '-'); ?></strong>
                                            </td>
                                            <td>
                                                <?php switch($penilaian->status):
                                                    case ('draft'): ?>
                                                        <span class="badge badge-secondary">
                                                            <i class="fas fa-clock"></i> Draft
                                                        </span>
                                                        <br><small class="text-muted">Belum dikirim</small>
                                                        <?php break; ?>
                                                    <?php case ('submitted'): ?>
                                                        <span class="badge badge-warning">
                                                            <i class="fas fa-paper-plane"></i> Menunggu Review
                                                        </span>
                                                        <br><small class="text-muted">Siap untuk direview</small>
                                                        <?php break; ?>
                                                    <?php case ('revision'): ?>
                                                        <span class="badge badge-info">
                                                            <i class="fas fa-edit"></i> Perlu Revisi
                                                        </span>
                                                        <br><small class="text-muted">Perlu perbaikan</small>
                                                        <?php break; ?>
                                                    <?php case ('validated'): ?>
                                                        <span class="badge badge-success">
                                                            <i class="fas fa-check-circle"></i> Validated
                                                        </span>
                                                        <br><small class="text-muted">Sudah disetujui</small>
                                                        <?php break; ?>
                                                <?php endswitch; ?>
                                            </td>
                                            <td>
                                                <?php if($penilaian->tanggal_submit): ?>
                                                    <?php echo e($penilaian->tanggal_submit->format('d/m/Y H:i')); ?>

                                                <?php else: ?>
                                                    <span class="text-muted">-</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if($penilaian->rata_rata): ?>
                                                    <strong class="text-success"><?php echo e(number_format($penilaian->rata_rata, 2)); ?></strong>
                                                    <br><small class="text-muted">Total: <?php echo e($penilaian->total_nilai); ?></small>
                                                <?php else: ?>
                                                    <span class="text-muted">Belum dinilai</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <span class="text-muted">-</span>
                                            </td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="8" class="text-center">
                                                <div class="py-4">
                                                    <i class="fas fa-users fa-3x text-muted mb-3"></i>
                                                    <h5 class="text-muted">Belum ada data penilaian</h5>
                                                    <p class="text-muted">Pengawas belum menilai.</p>
                                                </div>
                                            </td>
                                        </tr>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card-footer">
                    <div class="d-flex justify-content-between">
                        <a href="<?php echo e(route('kepala.instrumen.index')); ?>" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Kembali ke Daftar
                        </a>
                        
                        <div>
                            <?php if($penilaianStats['submitted'] > 0): ?>
                                <a href="<?php echo e(route('kepala.penilaian.review')); ?>" class="btn btn-primary">
                                    <i class="fas fa-edit"></i> Review Semua Penilaian (<?php echo e($penilaianStats['submitted']); ?>)
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function() {
    // Auto-hide alerts after 5 seconds
    setTimeout(function() {
        $('.alert').fadeOut('slow');
    }, 5000);
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /www/wwwroot/pkkm.pitchoiriyah.my.id/resources/views/kepala/instrumen/show.blade.php ENDPATH**/ ?>