<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-4 py-6">
    <div class="flex items-center justify-between mb-4">
        <h1 class="text-xl font-semibold">Detail Penilaian #<?php echo e($penilaian->id); ?></h1>
        <div>
            <?php if(in_array($penilaian->status, ['validated', 'final'])): ?>
            <a href="<?php echo e(route('kepala.penilaian.raport', $penilaian->id)); ?>" class="btn btn-success" target="_blank" title="Download Raport PDF">
                <i class="fas fa-file-pdf"></i>
            </a>
            <?php endif; ?>
            <a href="<?php echo e(route('kepala.penilaian.index')); ?>" class="btn btn-secondary" title="Kembali ke Daftar Penilaian">
                <i class="fas fa-arrow-left"></i>
            </a>
        </div>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
        <div class="card">
            <div class="card-body">
                <div class="mb-2"><strong>Pengawas:</strong> <?php echo e($penilaian->pengawas?->name ?? '-'); ?></div>
                <div class="mb-2"><strong>Status:</strong> <?php echo e(ucfirst($penilaian->status)); ?></div>
                <div class="mb-2"><strong>Tanggal Submit:</strong> <?php echo e(optional($penilaian->tanggal_submit)->format('d/m/Y H:i') ?? '-'); ?></div>
                <?php if($penilaian->catatan_pengawas): ?>
                    <div class="mt-2">
                        <strong>Catatan Pengawas:</strong>
                        <p class="mb-0"><?php echo e($penilaian->catatan_pengawas); ?></p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-body p-0 overflow-x-auto">
            <table class="table w-full">
                <thead>
                    <tr>
                        <th>Item</th>
                        <th>Nilai Pengawas</th>
                        <th>Catatan</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $penilaian->jawabanKepala; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $j): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($j->instrumenItem?->indikator_kinerja ?? 'Item #' . $j->instrumen_item_id); ?></td>
                            <td><?php echo e($j->nilai_pengawas ?? '-'); ?></td>
                            <td><?php echo e($j->catatan_pengawas ?? '-'); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="3" class="text-center py-6">Belum ada jawaban.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /www/wwwroot/pkkm.pitchoiriyah.my.id/resources/views/kepala/penilaian_kepala/show.blade.php ENDPATH**/ ?>