<?php $__env->startSection('title', 'Dashboard Pengawas'); ?>

<?php $__env->startSection('breadcrumb'); ?>
<li class="breadcrumb-item active">Dashboard</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- Info boxes -->
<div class="row">
    <div class="col-12 col-sm-6 col-md-3">
        <div class="info-box">
            <span class="info-box-icon bg-info elevation-1"><i class="fas fa-school"></i></span>
            <div class="info-box-content">
                <span class="info-box-text">Lembaga Binaan</span>
                <span class="info-box-number"><?php echo e(Auth::user()->lembaga()->count()); ?></span>
            </div>
        </div>
    </div>
    <div class="col-12 col-sm-6 col-md-3">
        <div class="info-box mb-3">
            <span class="info-box-icon bg-success elevation-1"><i class="fas fa-clipboard-list"></i></span>
            <div class="info-box-content">
                <span class="info-box-text">Instrumen Aktif</span>
                <span class="info-box-number"><?php echo e(\App\Models\Instrumen::where('is_active', true)->count()); ?></span>
            </div>
        </div>
    </div>
    <div class="clearfix hidden-md-up"></div>
    <div class="col-12 col-sm-6 col-md-3">
        <div class="info-box mb-3">
            <span class="info-box-icon bg-warning elevation-1"><i class="fas fa-share-alt"></i></span>
            <div class="info-box-content">
                <span class="info-box-text">Distribusi Aktif</span>
                <span class="info-box-number"><?php echo e(\App\Models\DistribusiInstrumen::whereHas('lembaga', function($q) { $q->where('pengawas_id', Auth::id()); })->where('status', 'active')->count()); ?></span>
            </div>
        </div>
    </div>
    <div class="col-12 col-sm-6 col-md-3">
        <div class="info-box mb-3">
            <span class="info-box-icon bg-danger elevation-1"><i class="fas fa-check-circle"></i></span>
            <div class="info-box-content">
                <span class="info-box-text">Menunggu Validasi</span>
                <span class="info-box-number"><?php echo e(\App\Models\PenilaianKepala::where('pengawas_id', Auth::id())->where('status', 'submitted')->count()); ?></span>
            </div>
        </div>
    </div>
</div>

<!-- Main row -->
<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Lembaga Binaan</h3>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Nama Lembaga</th>
                                <th>Jenis</th>
                                <th>NPSN/NSM</th>
                                <th>Kepala</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = Auth::user()->lembaga()->take(5)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lembaga): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($lembaga->nama_lembaga); ?></td>
                                <td><span class="badge badge-info"><?php echo e($lembaga->jenis); ?></span></td>
                                <td><?php echo e($lembaga->npsn_nsm); ?></td>
                                <td><?php echo e($lembaga->nama_kepala); ?></td>
                                <td><span class="badge badge-success">Aktif</span></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="5" class="text-center">Belum ada lembaga binaan</td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Instrumen Terbaru</h3>
            </div>
            <div class="card-body">
                <ul class="list-group list-group-flush">
                    <?php $__empty_1 = true; $__currentLoopData = \App\Models\Instrumen::where('is_active', true)->latest()->take(3)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $instrumen): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <li class="list-group-item d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="mb-1"><?php echo e($instrumen->judul); ?></h6>
                            <small class="text-muted"><?php echo e($instrumen->tahun_ajaran); ?> - Semester <?php echo e($instrumen->semester); ?></small>
                        </div>
                        <span class="badge badge-<?php echo e($instrumen->is_active ? 'success' : 'secondary'); ?>">
                            <?php echo e($instrumen->is_active ? 'Aktif' : 'Nonaktif'); ?>

                        </span>
                    </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <li class="list-group-item text-center text-muted">Belum ada instrumen</li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /www/wwwroot/pkkm.pitchoiriyah.my.id/resources/views/pengawas/dashboard.blade.php ENDPATH**/ ?>