<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-4 py-6">
    <div class="flex items-center justify-between mb-4">
        <h1 class="text-xl font-semibold">Daftar Penilaian Kepala</h1>
    </div>

    <?php if(session('success')): ?>
        <div class="alert alert-success mb-4"><?php echo e(session('success')); ?></div>
    <?php endif; ?>
    <?php if(session('error')): ?>
        <div class="alert alert-danger mb-4"><?php echo e(session('error')); ?></div>
    <?php endif; ?>

    <!-- Filter Section -->
    <div class="card mb-4">
        <div class="card-body">
            <form method="GET" action="<?php echo e(route('pengawas.penilaian.index')); ?>" class="row g-3">
                <div class="col-md-4">
                    <label for="status" class="form-label">Status</label>
                    <select name="status" id="status" class="form-select">
                        <option value="">Semua Status</option>
                        <option value="draft" <?php echo e($filters['status'] == 'draft' ? 'selected' : ''); ?>>Draft</option>
                        <option value="submitted" <?php echo e($filters['status'] == 'submitted' ? 'selected' : ''); ?>>Submitted</option>
                        <option value="revision" <?php echo e($filters['status'] == 'revision' ? 'selected' : ''); ?>>Revision</option>
                        <option value="validated" <?php echo e($filters['status'] == 'validated' ? 'selected' : ''); ?>>Validated</option>
                        <option value="final" <?php echo e($filters['status'] == 'final' ? 'selected' : ''); ?>>Final</option>
                    </select>
                </div>
                <div class="col-md-4">
                    <label for="lembaga_id" class="form-label">Lembaga</label>
                    <select name="lembaga_id" id="lembaga_id" class="form-select">
                        <option value="">Semua Lembaga</option>
                        <?php $__currentLoopData = $lembagaList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lembaga): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($lembaga->id); ?>" <?php echo e($filters['lembaga_id'] == $lembaga->id ? 'selected' : ''); ?>>
                                <?php echo e($lembaga->nama_lembaga); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-4 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary me-2">
                        <i class="fas fa-filter"></i> Filter
                    </button>
                    <a href="<?php echo e(route('pengawas.penilaian.index')); ?>" class="btn btn-secondary">
                        <i class="fas fa-times"></i> Reset
                    </a>
                </div>
            </form>
        </div>
    </div>

    <div class="card">
        <div class="card-body p-0">
            <div class="overflow-x-auto">
                <table class="table w-full">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Kepala</th>
                            <th>Lembaga</th>
                            <th>Status</th>
                            <th>Tanggal Submit</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e(($items->currentPage() - 1) * $items->perPage() + $loop->iteration); ?></td>
                                <td><?php echo e($item->kepala?->name ?? '-'); ?></td>
                                <td><?php echo e($item->distribusiInstrumen?->lembaga?->nama_lembaga ?? '-'); ?></td>
                                <td><?php echo e(ucfirst($item->status)); ?></td>
                                <td><?php echo e(optional($item->tanggal_submit)->format('d/m/Y H:i') ?? '-'); ?></td>
                                <td>
                                    <div class="btn-group" role="group">
                                        <a href="<?php echo e(route('pengawas.penilaian.show', $item->id)); ?>" class="btn btn-sm btn-primary" title="Review/Isi Penilaian">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <?php if(in_array($item->status, ['validated', 'final'])): ?>
                                        <a href="<?php echo e(route('pengawas.penilaian.raport', $item->id)); ?>" class="btn btn-sm btn-success" target="_blank" title="Download Raport PDF">
                                            <i class="fas fa-file-pdf"></i>
                                        </a>
                                        <form method="POST" action="<?php echo e(route('pengawas.penilaian.kirim-raport-kepala', $item->id)); ?>" style="display: inline;" onsubmit="return confirm('Apakah Anda yakin ingin mengirim raport ke kepala sekolah? Kepala akan menerima notifikasi.');">
                                            <?php echo csrf_field(); ?>
                                            <button type="submit" class="btn btn-sm btn-info" title="Kirim Raport ke Kepala">
                                                <i class="fas fa-paper-plane"></i>
                                            </button>
                                        </form>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="6" class="text-center py-6">Belum ada penilaian.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <?php if($items->hasPages()): ?>
    <div class="d-flex justify-content-center mt-3">
        <?php echo e($items->appends(request()->query())->links('pagination::bootstrap-4-custom')); ?>

    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /www/wwwroot/pkkm.pitchoiriyah.my.id/resources/views/pengawas/penilaian/index.blade.php ENDPATH**/ ?>