<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Raport Penilaian Kinerja Kepala Madrasah</title>
    <style>
        body {
            font-family: 'Times New Roman', serif;
            font-size: 12px;
            line-height: 1.4;
            margin: 0;
            padding: 20px;
            color: #000;
        }
        
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #000;
            padding-bottom: 15px;
        }
        
        .header h1 {
            font-size: 16px;
            font-weight: bold;
            margin: 0;
            text-transform: uppercase;
        }
        
        .header h2 {
            font-size: 14px;
            font-weight: bold;
            margin: 5px 0;
        }
        
        .header h3 {
            font-size: 12px;
            font-weight: bold;
            margin: 0;
        }
        
        .identitas {
            margin-bottom: 20px;
        }
        
        .identitas table {
            width: 100%;
            border-collapse: collapse;
        }
        
        .identitas td {
            padding: 3px 5px;
            vertical-align: top;
        }
        
        .identitas td:first-child {
            width: 30%;
            font-weight: bold;
        }
        
        .nilai-section {
            margin-bottom: 20px;
        }
        
        .nilai-section h4 {
            font-size: 13px;
            font-weight: bold;
            margin: 10px 0 5px 0;
            text-decoration: underline;
        }
        
        .nilai-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 15px;
        }
        
        .nilai-table th,
        .nilai-table td {
            border: 1px solid #000;
            padding: 5px;
            text-align: center;
            font-size: 11px;
        }
        
        .nilai-table th {
            background-color: #f0f0f0;
            font-weight: bold;
        }
        
        .nilai-table .text-left {
            text-align: left;
        }
        
        .analisis-section {
            margin-bottom: 20px;
        }
        
        .analisis-section h4 {
            font-size: 13px;
            font-weight: bold;
            margin: 15px 0 5px 0;
            text-decoration: underline;
        }
        
        .analisis-content {
            text-align: justify;
            line-height: 1.5;
            margin-bottom: 10px;
        }
        
        .signature-section {
            margin-top: 30px;
            display: table;
            width: 100%;
        }
        
        .signature-box {
            text-align: center;
            width: 45%;
            display: table-cell;
            vertical-align: top;
        }
        
        .signature-box:first-child {
            padding-right: 20px;
        }
        
        .signature-box:last-child {
            padding-left: 20px;
        }
        
        .signature-line {
            border-bottom: 1px solid #000;
            margin-bottom: 5px;
            height: 40px;
        }
        
        .page-break {
            page-break-before: always;
        }
        
        .footer {
            margin-top: 20px;
            text-align: center;
            font-size: 11px;
        }
    </style>
</head>
<body>
    <!-- Header -->
    <div class="header">
        <?php if($lembaga && $lembaga->logo_lembaga): ?>
            <?php
                // Get absolute path to logo file for PDF generation
                $logoPath = storage_path('app/public/' . $lembaga->logo_lembaga);
                // Check if file exists, if not try alternative path
                if (!file_exists($logoPath)) {
                    $logoPath = public_path('storage/' . $lembaga->logo_lembaga);
                }
                // If still not found, try direct storage path
                if (!file_exists($logoPath)) {
                    $logoPath = base_path('storage/app/public/' . $lembaga->logo_lembaga);
                }
                // Convert to base64 for PDF compatibility
                $logoBase64 = null;
                if (file_exists($logoPath)) {
                    $logoData = file_get_contents($logoPath);
                    $logoMime = mime_content_type($logoPath);
                    $logoBase64 = 'data:' . $logoMime . ';base64,' . base64_encode($logoData);
                }
            ?>
            <?php if($logoBase64): ?>
            <div style="text-align: center; margin-bottom: 10px;">
                <img src="<?php echo e($logoBase64); ?>" alt="Logo Lembaga" style="max-height: 60px; max-width: 200px;">
            </div>
            <?php endif; ?>
        <?php endif; ?>
        <h1><?php echo e($lembaga->nama_lembaga ?? 'NAMA LEMBAGA'); ?></h1>
        <h2>RAPORT HASIL PENILAIAN KINERJA KEPALA MADRASAH</h2>
        <h3>Tahun <?php echo e($tahun); ?></h3>
    </div>

    <!-- Identitas -->
    <div class="identitas">
        <table>
            <tr>
                <td>1. Nama Lembaga</td>
                <td>: <?php echo e($lembaga->nama_lembaga ?? 'PLACEHOLDER'); ?></td>
            </tr>
            <tr>
                <td>2. Nama Kepala Madrasah</td>
                <td>: <?php echo e($kepala->name ?? 'PLACEHOLDER'); ?></td>
            </tr>
            <tr>
                <td>3. Nama Pengawas Penilai</td>
                <td>: <?php echo e($pengawas->name ?? 'PLACEHOLDER'); ?></td>
            </tr>
            <tr>
                <td>4. Instrumen Penilaian</td>
                <td>: <?php echo e($instrumen->judul ?? $instrumen->nama_instrumen ?? 'PLACEHOLDER'); ?></td>
            </tr>
            <?php if($komponen): ?>
            <tr>
                <td>5. Komponen</td>
                <td>: <?php echo e($komponen->nama_komponen ?? 'PLACEHOLDER'); ?></td>
            </tr>
            <?php endif; ?>
            <tr>
                <td>6. Status Penilaian</td>
                <td>: <?php echo e(strtoupper($penilaian->status)); ?></td>
            </tr>
            <?php if($penilaian->tanggal_validasi): ?>
            <tr>
                <td>7. Tanggal Validasi</td>
                <td>: <?php echo e(\Carbon\Carbon::parse($penilaian->tanggal_validasi)->format('d F Y H:i')); ?></td>
            </tr>
            <?php endif; ?>
        </table>
    </div>

    <!-- Nilai Lengkap -->
    <div class="nilai-section">
        <h4>8. NILAI LENGKAP</h4>
        
        <?php if(isset($subKomponenAnalysis) && count($subKomponenAnalysis) > 0): ?>
            <?php $__currentLoopData = $subKomponenAnalysis; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $subKomponen): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <h5 style="font-size: 12px; font-weight: bold; margin: 10px 0 5px 0;">
                Sub Komponen <?php echo e($index + 1); ?>: <?php echo e($subKomponen['nama_sub_komponen'] ?? 'Unknown'); ?>

            </h5>
            
            <table class="nilai-table">
                <thead>
                    <tr>
                        <th style="width: 5%;">No</th>
                        <th style="width: 50%;">Indikator Kinerja</th>
                        <th style="width: 15%;">Nilai Pengawas</th>
                        <th style="width: 30%;">Keterangan Bukti</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(isset($subKomponen['indikator_kinerja']) && is_array($subKomponen['indikator_kinerja'])): ?>
                        <?php $__currentLoopData = $subKomponen['indikator_kinerja']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $idx => $indikator): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($idx + 1); ?></td>
                            <td class="text-left"><?php echo e($indikator['indikator'] ?? '-'); ?></td>
                            <td><?php echo e($indikator['nilai_pengawas'] ?? '-'); ?></td>
                            <td class="text-left"><?php echo e($indikator['bukti'] ?? '-'); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                    <tr style="font-weight: bold; background-color: #f9f9f9;">
                        <td colspan="2">Rata-rata Sub Komponen</td>
                        <td><?php echo e(isset($subKomponen['rata_rata_pengawas']) ? number_format($subKomponen['rata_rata_pengawas'], 2) : '-'); ?></td>
                        <td><?php echo e($subKomponen['kategori'] ?? '-'); ?></td>
                    </tr>
                </tbody>
            </table>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php else: ?>
            <p style="font-style: italic; color: #666;">Tidak ada data nilai untuk ditampilkan.</p>
        <?php endif; ?>
        
        <!-- Ringkasan Nilai -->
        <table class="nilai-table" style="margin-top: 15px;">
            <tr style="font-weight: bold; background-color: #e0e0e0;">
                <td colspan="2">TOTAL NILAI (Pengawas)</td>
                <td><?php echo e($totalNilai); ?></td>
                <td>Rata-rata: <?php echo e($rataRata); ?>/5.00</td>
            </tr>
        </table>
    </div>

    <!-- Analisis Pengawas -->
    <div class="analisis-section">
        <h4>9. ANALISIS PENGAWAS MADRASAH</h4>
        <div class="analisis-content">
            <?php if($analisisPengawas && $analisisPengawas !== 'Terjadi kesalahan dalam menghasilkan analisis. Silakan coba lagi.'): ?>
                <?php echo nl2br(e($analisisPengawas)); ?>

            <?php else: ?>
                <p style="font-style: italic; color: #666;">
                    Analisis pengawas belum tersedia.
                </p>
            <?php endif; ?>
        </div>
    </div>

    <!-- Footer -->
    <div class="footer">
        <p><?php echo e($kabupaten); ?>, <?php echo e($tanggal); ?></p>
    </div>

    <!-- Signature Section -->
    <div class="signature-section">
        <table style="width: 100%; border-collapse: collapse;">
            <tr>
                <td style="width: 45%; text-align: center; vertical-align: top;">
                    <p><strong>PENGAWAS MADRASAH</strong></p>
                    <div class="signature-line"></div>
                    <p><strong><?php echo e($pengawas->name ?? 'PLACEHOLDER'); ?></strong></p>
                </td>
                <td style="width: 10%;"></td>
                <td style="width: 45%; text-align: center; vertical-align: top;">
                    <p><strong>KEPALA MADRASAH YANG DINILAI</strong></p>
                    <div class="signature-line"></div>
                    <p><strong><?php echo e($kepala->name ?? 'PLACEHOLDER'); ?></strong></p>
                </td>
            </tr>
        </table>
    </div>
</body>
</html>
<?php /**PATH /www/wwwroot/pkkm.pitchoiriyah.my.id/resources/views/pengawas/raport/template.blade.php ENDPATH**/ ?>