<?php $__env->startSection('title', 'Detail Instrumen Penilaian'); ?>

<?php $__env->startSection('breadcrumb'); ?>
<li class="breadcrumb-item"><a href="<?php echo e(route('pengawas.instrumen.index')); ?>">Instrumen</a></li>
<li class="breadcrumb-item"><a href="<?php echo e(route('pengawas.items.index', $instrumen)); ?>">Komponen: <?php echo e(Str::limit($instrumen->judul, 20)); ?></a></li>
<li class="breadcrumb-item active">Detail: <?php echo e(Str::limit($item->nama_komponen, 30)); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            <i class="fas fa-list-alt"></i> Detail Instrumen Penilaian: <?php echo e($item->nama_komponen); ?>

        </h3>
        <div class="card-tools">
            <a href="<?php echo e(route('pengawas.items.index', $instrumen)); ?>" class="btn btn-secondary btn-sm">
                <i class="fas fa-arrow-left"></i> Kembali
            </a>
        </div>
    </div>
    <div class="card-body">
        <!-- Info Boxes -->
        <div class="row mb-4">
            <div class="col-md-4">
                <div class="info-box bg-info">
                    <span class="info-box-icon"><i class="fas fa-cogs"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Komponen</span>
                        <span class="info-box-number"><?php echo e($item->nama_komponen); ?></span>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="info-box bg-success">
                    <span class="info-box-icon"><i class="fas fa-list-alt"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Total Instrumen</span>
                        <span class="info-box-number"><?php echo e($item->instrumenPenilaians->count()); ?></span>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="info-box bg-<?php echo e($item->is_active ? 'success' : 'danger'); ?>">
                    <span class="info-box-icon"><i class="fas fa-toggle-<?php echo e($item->is_active ? 'on' : 'off'); ?>"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Status</span>
                        <span class="info-box-number"><?php echo e($item->is_active ? 'Aktif' : 'Nonaktif'); ?></span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Komponen Details -->
        <div class="row">
            <div class="col-md-12">
                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <h3 class="card-title">
                            <i class="fas fa-info-circle"></i> Informasi Komponen
                        </h3>
                    </div>
                    <div class="card-body">
                        <dl class="row">
                            <dt class="col-sm-3">Nama Komponen:</dt>
                            <dd class="col-sm-9"><?php echo e($item->nama_komponen); ?></dd>
                            
                            <dt class="col-sm-3">Deskripsi:</dt>
                            <dd class="col-sm-9"><?php echo e($item->deskripsi ?: '-'); ?></dd>
                            
                            <dt class="col-sm-3">Urutan:</dt>
                            <dd class="col-sm-9"><?php echo e($item->urutan); ?></dd>
                            
                            <dt class="col-sm-3">Status:</dt>
                            <dd class="col-sm-9">
                                <span class="badge badge-<?php echo e($item->is_active ? 'success' : 'danger'); ?>">
                                    <?php echo e($item->is_active ? 'Aktif' : 'Nonaktif'); ?>

                                </span>
                            </dd>
                            
                            <dt class="col-sm-3">Dibuat:</dt>
                            <dd class="col-sm-9"><?php echo e($item->created_at->format('d M Y H:i')); ?></dd>
                            
                            <dt class="col-sm-3">Diperbarui:</dt>
                            <dd class="col-sm-9"><?php echo e($item->updated_at->format('d M Y H:i')); ?></dd>
                        </dl>
                    </div>
                </div>
            </div>
        </div>

        <!-- Instrumen Penilaian -->
        <?php if($item->instrumenPenilaians->count() > 0): ?>
        <div class="row mt-4">
            <div class="col-md-12">
                <div class="card card-success card-outline">
                    <div class="card-header">
                        <h3 class="card-title">
                            <i class="fas fa-list-alt"></i> Instrumen Penilaian (<?php echo e($item->instrumenPenilaians->count()); ?>)
                        </h3>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped table-hover">
                                <thead class="thead-dark">
                                    <tr>
                                        <th width="5%">No</th>
                                        <th width="25%">Indikator Kinerja</th>
                                        <th width="20%">Evidensi Kinerja</th>
                                        <th width="10%">Skor Min</th>
                                        <th width="10%">Skor Max</th>
                                        <th width="15%">Bukti URL</th>
                                        <th width="15%">Catatan Verifikasi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $item->instrumenPenilaians->sortBy('no_urutan'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $instrumenPenilaian): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($instrumenPenilaian->no_urutan); ?></td>
                                        <td>
                                            <strong><?php echo e($instrumenPenilaian->indikator_kinerja); ?></strong>
                                        </td>
                                        <td><?php echo e($instrumenPenilaian->evidensi_kinerja ?: '-'); ?></td>
                                        <td>
                                            <span class="badge badge-warning"><?php echo e($instrumenPenilaian->skor_min); ?></span>
                                        </td>
                                        <td>
                                            <span class="badge badge-success"><?php echo e($instrumenPenilaian->skor_max); ?></span>
                                        </td>
                                        <td>
                                            <?php if($instrumenPenilaian->bukti_url): ?>
                                                <a href="<?php echo e($instrumenPenilaian->bukti_url); ?>" target="_blank" class="btn btn-sm btn-outline-info">
                                                    <i class="fas fa-external-link-alt"></i> Lihat
                                                </a>
                                            <?php else: ?>
                                                <span class="text-muted">-</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if($instrumenPenilaian->catatan_verifikasi): ?>
                                                <span class="text-success">
                                                    <i class="fas fa-check-circle"></i> Sudah diverifikasi
                                                </span>
                                            <?php else: ?>
                                                <span class="text-muted">Belum ada catatan</span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php else: ?>
        <div class="row mt-4">
            <div class="col-md-12">
                <div class="card card-warning card-outline">
                    <div class="card-body text-center py-4">
                        <i class="fas fa-exclamation-triangle fa-3x text-warning mb-3"></i>
                        <h5>Belum Ada Instrumen Penilaian</h5>
                        <p class="text-muted">Komponen ini belum memiliki instrumen penilaian. Silakan hubungi admin untuk menambahkan instrumen penilaian.</p>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Role Information -->
        <div class="row mt-4">
            <div class="col-md-12">
                <div class="alert alert-light">
                    <h6><i class="fas fa-users"></i> Pembagian Peran dalam Penilaian:</h6>
                    <div class="row">
                        <div class="col-md-4">
                            <small class="text-muted">
                                <i class="fas fa-user-tie text-primary"></i> <strong>Admin:</strong> Membuat struktur instrumen
                            </small>
                        </div>
                        <div class="col-md-4">
                            <small class="text-muted">
                                <i class="fas fa-chalkboard-teacher text-success"></i> <strong>Guru:</strong> Mengisi Bukti URL
                            </small>
                        </div>
                        <div class="col-md-4">
                            <small class="text-muted">
                                <i class="fas fa-user-shield text-warning"></i> <strong>Kepala:</strong> Mengisi Catatan Verifikasi
                            </small>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Action Buttons -->
        <div class="row mt-4">
            <div class="col-md-12 text-center">
                <a href="<?php echo e(route('pengawas.items.index', $instrumen)); ?>" class="btn btn-secondary">
                    <i class="fas fa-arrow-left"></i> Kembali ke Komponen
                </a>
                <a href="<?php echo e(route('pengawas.instrumen.index')); ?>" class="btn btn-info">
                    <i class="fas fa-list"></i> Kembali ke Instrumen
                </a>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /www/wwwroot/pkkm.pitchoiriyah.my.id/resources/views/pengawas/items/show.blade.php ENDPATH**/ ?>