<?php $__env->startSection('title', 'Komponen Instrumen'); ?>

<?php $__env->startSection('breadcrumb'); ?>
<li class="breadcrumb-item"><a href="<?php echo e(route('pengawas.instrumen.index')); ?>">Instrumen</a></li>
<li class="breadcrumb-item active">Komponen: <?php echo e($instrumen->judul); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            <i class="fas fa-cogs"></i> Komponen Instrumen: <?php echo e($instrumen->judul); ?>

        </h3>
        <div class="card-tools">
            <span class="text-muted">
                <i class="fas fa-info-circle"></i> Hanya bisa melihat komponen penilaian
            </span>
            <a href="<?php echo e(route('pengawas.instrumen.index')); ?>" class="btn btn-secondary btn-sm">
                <i class="fas fa-arrow-left"></i> Kembali
            </a>
        </div>
    </div>
    <div class="card-body">
        <?php if(session('status')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?php echo e(session('status')); ?>

                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>

        <?php if(session('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <?php echo e(session('error')); ?>

                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>

        <!-- Info Box -->
        <div class="row mb-3">
            <div class="col-md-6">
                <div class="info-box bg-info">
                    <span class="info-box-icon"><i class="fas fa-cogs"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Total Komponen</span>
                        <span class="info-box-number"><?php echo e($items->count()); ?></span>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="info-box bg-success">
                    <span class="info-box-icon"><i class="fas fa-list-alt"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Total Instrumen Penilaian</span>
                        <span class="info-box-number"><?php echo e($items->sum(function($item) { return $item->instrumenPenilaians->count(); })); ?></span>
                    </div>
                </div>
            </div>
        </div>

        <div class="table-responsive">
            <table class="table table-striped table-hover">
                <thead class="thead-dark">
                    <tr>
                        <th width="5%">No</th>
                        <th width="25%">Nama Komponen</th>
                        <th width="30%">Deskripsi</th>
                        <th width="8%">Urutan</th>
                        <th width="10%">Instrumen</th>
                        <th width="8%">Status</th>
                        <th width="14%">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e($index + 1); ?></td>
                        <td>
                            <strong><?php echo e($item->nama_komponen); ?></strong>
                            <br><small class="text-muted">ID: <?php echo e($item->id); ?></small>
                        </td>
                        <td><?php echo e(Str::limit($item->deskripsi, 80) ?: '-'); ?></td>
                        <td><?php echo e($item->urutan); ?></td>
                        <td>
                            <span class="badge badge-warning"><?php echo e($item->instrumenPenilaians->count()); ?> item</span>
                        </td>
                        <td>
                            <span class="badge badge-<?php echo e($item->is_active ? 'success' : 'danger'); ?>">
                                <?php echo e($item->is_active ? 'Aktif' : 'Nonaktif'); ?>

                            </span>
                        </td>
                        <td>
                            <div class="btn-group" role="group">
                                <a href="<?php echo e(route('pengawas.items.show', [$instrumen, $item])); ?>" class="btn btn-info btn-sm" title="Lihat Detail Instrumen">
                                    <i class="fas fa-list-alt"></i>
                                </a>
                                <a href="<?php echo e(route('pengawas.items.sub-komponen', [$instrumen, $item])); ?>" class="btn btn-success btn-sm" title="Lihat Sub Komponen">
                                    <i class="fas fa-layer-group"></i>
                                </a>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="7" class="text-center py-4">
                            <i class="fas fa-cogs fa-3x text-muted mb-3"></i>
                            <p class="text-muted">Belum ada komponen penilaian</p>
                            <small class="text-muted">Komponen penilaian akan dibuat oleh admin</small>
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /www/wwwroot/pkkm.pitchoiriyah.my.id/resources/views/pengawas/items/index.blade.php ENDPATH**/ ?>