<?php $__env->startSection('title', 'Edit Data Lembaga'); ?>

<?php $__env->startSection('breadcrumb'); ?>
<li class="breadcrumb-item"><a href="<?php echo e(route('kepala.lembaga.index')); ?>">Lembaga Saya</a></li>
<li class="breadcrumb-item active">Edit</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            <i class="fas fa-edit"></i> Edit Data Lembaga: <?php echo e($lembaga->nama_lembaga); ?>

            <small class="text-muted">(ID: <?php echo e($lembaga->id); ?>)</small>
        </h3>
        <div class="card-tools">
            <a href="<?php echo e(route('kepala.lembaga.index')); ?>" class="btn btn-secondary btn-sm">
                <i class="fas fa-arrow-left"></i> Kembali
            </a>
        </div>
    </div>
    <div class="card-body">
        <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?php echo e(session('success')); ?>

                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>

        <?php if($errors->any()): ?>
            <div class="alert alert-danger">
                <ul class="mb-0">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>

        <form action="<?php echo e(route('kepala.lembaga.update')); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>

            <!-- Basic Information -->
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title">Informasi Dasar</h3>
                    <div class="card-tools">
                        <span class="badge badge-info">ID Lembaga: <?php echo e($lembaga->id); ?></span>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="npsn_nsm">NSM <span class="text-danger">*</span></label>
                                <input type="text" class="form-control <?php $__errorArgs = ['npsn_nsm'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="npsn_nsm" name="npsn_nsm" value="<?php echo e(old('npsn_nsm', $lembaga->npsn_nsm)); ?>" 
                                       required readonly>
                                <small class="form-text text-muted">Nomor Statistik Madrasah (tidak dapat diubah)</small>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="nama_lembaga">Nama Lembaga <span class="text-danger">*</span></label>
                                <input type="text" class="form-control <?php $__errorArgs = ['nama_lembaga'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="nama_lembaga" name="nama_lembaga" value="<?php echo e(old('nama_lembaga', $lembaga->nama_lembaga)); ?>" 
                                       required>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="jenis">Jenis Lembaga <span class="text-danger">*</span></label>
                                <select class="form-control <?php $__errorArgs = ['jenis'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="jenis" name="jenis" required readonly>
                                    <option value="RA" <?php echo e(old('jenis', $lembaga->jenis) == 'RA' ? 'selected' : ''); ?>>RA (Raudhatul Athfal)</option>
                                    <option value="MI" <?php echo e(old('jenis', $lembaga->jenis) == 'MI' ? 'selected' : ''); ?>>MI (Madrasah Ibtidaiyah)</option>
                                    <option value="MTs" <?php echo e(old('jenis', $lembaga->jenis) == 'MTs' ? 'selected' : ''); ?>>MTs (Madrasah Tsanawiyah)</option>
                                    <option value="MA" <?php echo e(old('jenis', $lembaga->jenis) == 'MA' ? 'selected' : ''); ?>>MA (Madrasah Aliyah)</option>
                                </select>
                                <small class="form-text text-muted">Jenis lembaga (tidak dapat diubah)</small>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="tahun_berdiri">Tahun Berdiri</label>
                                <input type="number" class="form-control <?php $__errorArgs = ['tahun_berdiri'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="tahun_berdiri" name="tahun_berdiri" value="<?php echo e(old('tahun_berdiri', $lembaga->tahun_berdiri)); ?>" 
                                       min="1900" max="<?php echo e(date('Y')); ?>">
                            </div>
                        </div>
                    </div>

                    <!-- Logo Upload Section -->
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="logo_lembaga">Logo Lembaga</label>
                                <input type="file" class="form-control <?php $__errorArgs = ['logo_lembaga'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="logo_lembaga" name="logo_lembaga" accept="image/*">
                                <?php $__errorArgs = ['logo_lembaga'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                <small class="form-text text-muted">Format: JPEG, PNG, JPG, GIF, WEBP. Maksimal 5MB.</small>
                                <?php if($lembaga->logo_lembaga): ?>
                                    <div class="mt-2">
                                        <strong>Logo Saat Ini:</strong><br>
                                        <img src="<?php echo e(Storage::url($lembaga->logo_lembaga)); ?>" 
                                             alt="Logo <?php echo e($lembaga->nama_lembaga); ?>" 
                                             class="img-thumbnail" 
                                             style="max-height: 100px; max-width: 150px;">
                                        <br><small class="text-muted">Pilih file baru untuk mengganti logo</small>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                    <!-- Information about pengawas -->
                    <?php if($lembaga->pengawas): ?>
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle"></i>
                        <strong>Pengawas:</strong> <?php echo e($lembaga->pengawas->name); ?>

                        <br>
                        <small class="text-muted">Data yang Anda edit akan terlihat oleh pengawas dan admin.</small>
                    </div>
                    <?php else: ?>
                    <div class="alert alert-warning">
                        <i class="fas fa-exclamation-triangle"></i>
                        <strong>Belum ada pengawas yang diassign.</strong>
                        <br>
                        <small class="text-muted">Hubungi admin untuk mengassign pengawas ke lembaga ini.</small>
                    </div>
                    <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Address Information -->
            <div class="card card-success card-outline">
                <div class="card-header">
                    <h3 class="card-title">Informasi Alamat</h3>
                </div>
                <div class="card-body">
                    <div class="form-group">
                        <label for="alamat_lengkap">Alamat Lengkap <span class="text-danger">*</span></label>
                        <textarea class="form-control <?php $__errorArgs = ['alamat_lengkap'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                  id="alamat_lengkap" name="alamat_lengkap" rows="3" required><?php echo e(old('alamat_lengkap', $lembaga->alamat_lengkap)); ?></textarea>
                    </div>

                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="provinsi">Provinsi <span class="text-danger">*</span></label>
                                <select class="form-control <?php $__errorArgs = ['provinsi'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                        id="provinsi" name="provinsi" required>
                                    <option value="">Pilih Provinsi...</option>
                                    <?php if($lembaga->provinsi): ?>
                                        <option value="<?php echo e($lembaga->provinsi); ?>" selected><?php echo e($lembaga->provinsi_name ?? $lembaga->provinsi); ?></option>
                                    <?php endif; ?>
                                </select>
                                <?php $__errorArgs = ['provinsi'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="kabupaten">Kabupaten <span class="text-danger">*</span></label>
                                <select class="form-control <?php $__errorArgs = ['kabupaten'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                        id="kabupaten" name="kabupaten" required>
                                    <option value="">Pilih Kabupaten...</option>
                                    <?php if($lembaga->kabupaten): ?>
                                        <option value="<?php echo e($lembaga->kabupaten); ?>" selected><?php echo e($lembaga->kabupaten_name ?? $lembaga->kabupaten); ?></option>
                                    <?php endif; ?>
                                </select>
                                <?php $__errorArgs = ['kabupaten'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="kecamatan">Kecamatan <span class="text-danger">*</span></label>
                                <select class="form-control <?php $__errorArgs = ['kecamatan'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                        id="kecamatan" name="kecamatan" required>
                                    <option value="">Pilih Kecamatan...</option>
                                    <?php if($lembaga->kecamatan): ?>
                                        <option value="<?php echo e($lembaga->kecamatan); ?>" selected><?php echo e($lembaga->kecamatan_name ?? $lembaga->kecamatan); ?></option>
                                    <?php endif; ?>
                                </select>
                                <?php $__errorArgs = ['kecamatan'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="kelurahan">Kelurahan <span class="text-danger">*</span></label>
                                <select class="form-control <?php $__errorArgs = ['kelurahan'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                        id="kelurahan" name="kelurahan" required>
                                    <option value="">Pilih Kelurahan...</option>
                                    <?php if($lembaga->kelurahan): ?>
                                        <option value="<?php echo e($lembaga->kelurahan); ?>" selected><?php echo e($lembaga->kelurahan_name ?? $lembaga->kelurahan); ?></option>
                                    <?php endif; ?>
                                </select>
                                <?php $__errorArgs = ['kelurahan'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="kode_pos">Kode Pos</label>
                                <input type="text" class="form-control <?php $__errorArgs = ['kode_pos'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="kode_pos" name="kode_pos" value="<?php echo e(old('kode_pos', $lembaga->kode_pos)); ?>" 
                                       maxlength="10" placeholder="Opsional">
                                <small class="form-text text-muted">
                                    <i class="fas fa-info-circle"></i> Jika tersedia, kode pos akan terisi otomatis berdasarkan kelurahan. Anda juga dapat mengisi/menyesuaikan secara manual (opsional).
                                </small>
                                <?php $__errorArgs = ['kode_pos'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="telepon">Telepon</label>
                                <input type="text" class="form-control <?php $__errorArgs = ['telepon'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="telepon" name="telepon" value="<?php echo e(old('telepon', $lembaga->telepon)); ?>">
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Contact Information -->
            <div class="card card-info card-outline">
                <div class="card-header">
                    <h3 class="card-title">Informasi Kontak</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="email">Email Lembaga</label>
                                <input type="email" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="email" name="email" value="<?php echo e(old('email', $lembaga->email)); ?>">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="website">Website</label>
                                <input type="url" class="form-control <?php $__errorArgs = ['website'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="website" name="website" value="<?php echo e(old('website', $lembaga->website)); ?>" 
                                       placeholder="https://example.com">
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Head Information -->
            <div class="card card-warning card-outline">
                <div class="card-header">
                    <h3 class="card-title">Informasi Kepala Lembaga</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="nama_kepala">Nama Kepala</label>
                                <input type="text" class="form-control" 
                                       id="nama_kepala" value="<?php echo e($lembaga->kepala->name ?? $lembaga->nama_kepala ?? 'Belum ada kepala'); ?>" readonly>
                                <small class="form-text text-muted">
                                    <i class="fas fa-info-circle"></i> Nama kepala akan otomatis terupdate dari akun yang diassign admin.
                                </small>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="nip_kepala">NIP Kepala <span class="text-danger">*</span></label>
                                <input type="text" class="form-control <?php $__errorArgs = ['nip_kepala'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="nip_kepala" name="nip_kepala" value="<?php echo e(old('nip_kepala', $lembaga->nip_kepala)); ?>" required>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="akreditasi">Akreditasi</label>
                        <select class="form-control <?php $__errorArgs = ['akreditasi'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="akreditasi" name="akreditasi">
                            <option value="">Pilih Akreditasi</option>
                            <option value="A" <?php echo e(old('akreditasi', $lembaga->akreditasi) == 'A' ? 'selected' : ''); ?>>A (Sangat Baik)</option>
                            <option value="B" <?php echo e(old('akreditasi', $lembaga->akreditasi) == 'B' ? 'selected' : ''); ?>>B (Baik)</option>
                            <option value="C" <?php echo e(old('akreditasi', $lembaga->akreditasi) == 'C' ? 'selected' : ''); ?>>C (Cukup)</option>
                            <option value="TT" <?php echo e(old('akreditasi', $lembaga->akreditasi) == 'TT' ? 'selected' : ''); ?>>TT (Terakreditasi)</option>
                        </select>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> Simpan Perubahan
                </button>
                <a href="<?php echo e(route('kepala.lembaga.index')); ?>" class="btn btn-secondary">
                    <i class="fas fa-times"></i> Batal
                </a>
            </div>
        </form>
    </div>
</div>

<!-- Hidden inputs to store current values -->
<input type="hidden" id="current_provinsi" value="<?php echo e(old('provinsi', $lembaga->provinsi)); ?>">
<input type="hidden" id="current_kabupaten" value="<?php echo e(old('kabupaten', $lembaga->kabupaten)); ?>">
<input type="hidden" id="current_kecamatan" value="<?php echo e(old('kecamatan', $lembaga->kecamatan)); ?>">
<input type="hidden" id="current_kelurahan" value="<?php echo e(old('kelurahan', $lembaga->kelurahan)); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function() {
    // Logo preview functionality
    $('#logo_lembaga').on('change', function(e) {
        const file = e.target.files[0];
        if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
                // Create or update preview
                let preview = $('#logo-preview');
                if (preview.length === 0) {
                    preview = $('<div id="logo-preview" class="mt-2"><strong>Preview Logo Baru:</strong><br><img class="img-thumbnail" style="max-height: 100px; max-width: 150px;"></div>');
                    $('#logo_lembaga').after(preview);
                }
                preview.find('img').attr('src', e.target.result);
            };
            reader.readAsDataURL(file);
        }
    });
    const currentProvinsi = $('#current_provinsi').val();
    const currentKabupaten = $('#current_kabupaten').val();
    const currentKecamatan = $('#current_kecamatan').val();
    const currentKelurahan = $('#current_kelurahan').val();


    // Load provinces on page load
    loadProvinces();

    // Load provinces function
    function loadProvinces() {
        $.get('/api/wilayah/provinsi', function(data) {
            const provinsiSelect = $('#provinsi');
            provinsiSelect.empty().append('<option value="">Pilih Provinsi</option>');
            
            // Add all provinces to dropdown
            $.each(data, function(index, provinsi) {
                const selected = (provinsi.id == currentProvinsi) ? 'selected' : '';
                provinsiSelect.append(`<option value="${provinsi.id}" ${selected}>${provinsi.name}</option>`);
            });

            // Auto-load kabupaten if current value exists
            if (currentProvinsi) {
                setTimeout(function() {
                    loadKabupaten(currentProvinsi);
                }, 100);
            }
        }).fail(function(xhr, status, error) {
            // Silent fail - no console logging
        });
    }

    // Load kabupaten function
    function loadKabupaten(provinsiId) {
        if (!provinsiId) {
            $('#kabupaten').empty().append('<option value="">Pilih Kabupaten</option>');
            $('#kecamatan').empty().append('<option value="">Pilih Kecamatan</option>');
            $('#kelurahan').empty().append('<option value="">Pilih Kelurahan</option>');
            return;
        }

        $.get('/api/wilayah/kabupaten', {province_id: provinsiId}, function(data) {
            const kabupatenSelect = $('#kabupaten');
            kabupatenSelect.empty().append('<option value="">Pilih Kabupaten</option>');
            
            // Add all kabupaten to dropdown
            $.each(data, function(index, kabupaten) {
                const selected = (kabupaten.id == currentKabupaten) ? 'selected' : '';
                kabupatenSelect.append(`<option value="${kabupaten.id}" ${selected}>${kabupaten.name}</option>`);
            });

            // Auto-load kecamatan if current value exists
            if (currentKabupaten) {
                setTimeout(function() {
                    loadKecamatan(currentKabupaten);
                }, 100);
            }
        }).fail(function(xhr, status, error) {
            // Silent fail - no console logging
        });
    }

    // Load kecamatan function
    function loadKecamatan(kabupatenId) {
        if (!kabupatenId) {
            $('#kecamatan').empty().append('<option value="">Pilih Kecamatan</option>');
            $('#kelurahan').empty().append('<option value="">Pilih Kelurahan</option>');
            return;
        }

        $.get('/api/wilayah/kecamatan', {regency_id: kabupatenId}, function(data) {
            const kecamatanSelect = $('#kecamatan');
            kecamatanSelect.empty().append('<option value="">Pilih Kecamatan</option>');
            
            // Add all kecamatan to dropdown
            $.each(data, function(index, kecamatan) {
                const selected = (kecamatan.id == currentKecamatan) ? 'selected' : '';
                kecamatanSelect.append(`<option value="${kecamatan.id}" ${selected}>${kecamatan.name}</option>`);
            });

            // Auto-load kelurahan if current value exists
            if (currentKecamatan) {
                setTimeout(function() {
                    loadKelurahan(currentKecamatan);
                }, 100);
            }
        }).fail(function(xhr, status, error) {
            // Silent fail - no console logging
        });
    }

    // Load kelurahan function
    function loadKelurahan(kecamatanId) {
        if (!kecamatanId) {
            $('#kelurahan').empty().append('<option value="">Pilih Kelurahan</option>');
            return;
        }

        $.get('/api/wilayah/kelurahan', {district_id: kecamatanId}, function(data) {
            const kelurahanSelect = $('#kelurahan');
            kelurahanSelect.empty().append('<option value="">Pilih Kelurahan</option>');
            
            // Add all kelurahan to dropdown
            $.each(data, function(index, kelurahan) {
                const selected = (kelurahan.id == currentKelurahan) ? 'selected' : '';
                kelurahanSelect.append(`<option value="${kelurahan.id}" ${selected}>${kelurahan.name}</option>`);
            });

            // Auto-select current kelurahan if exists
            if (currentKelurahan) {
                setTimeout(function() {
                    $('#kelurahan').val(currentKelurahan);
                }, 100);
            }
        }).fail(function(xhr, status, error) {
            // Silent fail - no console logging
        });
    }

    // Event handlers for cascading dropdowns
    $('#provinsi').on('change', function() {
        const provinsiId = $(this).val();
        loadKabupaten(provinsiId);
        $('#kecamatan').empty().append('<option value="">Pilih Kecamatan</option>');
        $('#kelurahan').empty().append('<option value="">Pilih Kelurahan</option>');
    });

    $('#kabupaten').on('change', function() {
        const kabupatenId = $(this).val();
        loadKecamatan(kabupatenId);
        $('#kelurahan').empty().append('<option value="">Pilih Kelurahan</option>');
    });

    $('#kecamatan').on('change', function() {
        const kecamatanId = $(this).val();
        loadKelurahan(kecamatanId);
    });
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /www/wwwroot/pkkm.pitchoiriyah.my.id/resources/views/kepala/lembaga/edit.blade.php ENDPATH**/ ?>