<?php $__env->startSection('title', 'Pilih Lembaga'); ?>

<?php $__env->startPush('styles'); ?>
<!-- Select2 CSS -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link href="https://cdn.jsdelivr.net/npm/select2-bootstrap-theme@0.1.0-beta.10/select2-bootstrap.min.css" rel="stylesheet" />

<style>
/* Custom Select2 styling */
.select2-container--bootstrap .select2-selection--single {
    height: 38px !important;
    border: 1px solid #ced4da !important;
    border-radius: 0.25rem !important;
    padding: 0 !important;
}

.select2-container--bootstrap .select2-selection--single .select2-selection__rendered {
    line-height: 36px !important;
    padding-left: 12px !important;
    padding-right: 20px !important;
}

.select2-container--bootstrap .select2-selection--single .select2-selection__arrow {
    height: 36px !important;
    right: 8px !important;
}

.select2-container--bootstrap .select2-selection--single .select2-selection__clear {
    display: none !important;
}

.select2-container--bootstrap .select2-dropdown {
    border: 1px solid #ced4da !important;
    border-radius: 0.25rem !important;
    max-height: 300px !important;
}

.select2-container--bootstrap .select2-results {
    max-height: 280px !important;
    overflow-y: auto !important;
}

.select2-container--bootstrap .select2-results::-webkit-scrollbar {
    width: 6px;
}

.select2-container--bootstrap .select2-results::-webkit-scrollbar-track {
    background: #f1f1f1;
    border-radius: 3px;
}

.select2-container--bootstrap .select2-results::-webkit-scrollbar-thumb {
    background: #c1c1c1;
    border-radius: 3px;
}

.select2-container--bootstrap .select2-results::-webkit-scrollbar-thumb:hover {
    background: #a8a8a8;
}

.select2-container--bootstrap .select2-search--dropdown .select2-search__field {
    border: 1px solid #ced4da !important;
    border-radius: 0.25rem !important;
    padding: 8px 12px !important;
}

.select2-container--bootstrap .select2-results__option {
    padding: 12px !important;
}

.select2-container--bootstrap .select2-results__option--highlighted {
    background-color: #007bff !important;
    color: white !important;
}

/* Lembaga info card styling */
.lembaga-info {
    border: 1px solid #e3e6f0;
    border-radius: 0.35rem;
    padding: 1rem;
    margin-top: 0.5rem;
    background-color: #f8f9fc;
    display: none;
}

.lembaga-info h6 {
    color: #5a5c69;
    margin-bottom: 0.5rem;
}

.lembaga-info p {
    margin-bottom: 0.25rem;
    color: #858796;
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('breadcrumb'); ?>
<li class="breadcrumb-item"><a href="<?php echo e(route('pengawas.lembaga.index')); ?>">Lembaga</a></li>
<li class="breadcrumb-item active">Tambah</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            <i class="fas fa-hand-pointer"></i> Pilih Lembaga Binaan
        </h3>
        <div class="card-tools">
            <a href="<?php echo e(route('pengawas.lembaga.index')); ?>" class="btn btn-secondary btn-sm">
                <i class="fas fa-arrow-left"></i> Kembali
            </a>
        </div>
    </div>
    <div class="card-body">
        <div class="alert alert-info">
            <i class="fas fa-info-circle"></i>
            <strong>Informasi:</strong> Pilih lembaga yang sudah dibuat oleh admin untuk menjadi lembaga binaan Anda.
        </div>
        
        <form action="<?php echo e(route('pengawas.lembaga.claim')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <div class="form-group">
                <label for="lembaga_id">Pilih Lembaga <span class="text-danger">*</span></label>
                <select class="form-control select2 <?php $__errorArgs = ['lembaga_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="lembaga_id" name="lembaga_id" required>
                    <option value="">Pilih Lembaga</option>
                    <?php $__currentLoopData = $lembagaAvailable; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lembaga): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($lembaga->id); ?>" data-nsm="<?php echo e($lembaga->npsn_nsm); ?>" data-jenis="<?php echo e($lembaga->jenis); ?>" <?php echo e(old('lembaga_id') == $lembaga->id ? 'selected' : ''); ?>>
                            <?php echo e($lembaga->npsn_nsm); ?> - <?php echo e($lembaga->nama_lembaga); ?> (<?php echo e($lembaga->jenis); ?>)
                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php $__errorArgs = ['lembaga_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                <small class="form-text text-muted">Pilih lembaga yang belum memiliki pengawas</small>
            </div>

            <!-- Lembaga Info Preview -->
            <div class="lembaga-info" id="lembaga-info">
                <h6><i class="fas fa-info-circle"></i> Informasi Lembaga</h6>
                <p><strong>NSM:</strong> <span id="info-nsm">-</span></p>
                <p><strong>Nama Lembaga:</strong> <span id="info-nama">-</span></p>
                <p><strong>Jenis:</strong> <span id="info-jenis">-</span></p>
                <p><strong>Status:</strong> <span class="badge badge-warning">Belum ada pengawas</span></p>
            </div>

            <div class="form-group mt-4">
                <button type="submit" class="btn btn-success">
                    <i class="fas fa-hand-holding"></i> Ambil sebagai Lembaga Binaan
                </button>
                <a href="<?php echo e(route('pengawas.lembaga.index')); ?>" class="btn btn-secondary">
                    <i class="fas fa-times"></i> Batal
                </a>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<!-- Select2 JS -->
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
$(document).ready(function() {
    // Initialize Select2 for lembaga dropdown
    $('#lembaga_id').select2({
        theme: 'bootstrap',
        placeholder: 'Pilih Lembaga',
        allowClear: false,
        width: '100%',
        dropdownAutoWidth: true,
        dropdownParent: $('#lembaga_id').parent(),
        language: {
            noResults: function() {
                return "Tidak ada lembaga tersedia";
            },
            searching: function() {
                return "Mencari lembaga...";
            }
        }
    });
    
    // Lembaga selection change event
    $('#lembaga_id').on('change', function() {
        const lembagaId = $(this).val();
        const selectedOption = $(this).find('option:selected');
        
        if (lembagaId && selectedOption.length > 0) {
            // Show lembaga info
            $('#info-nsm').text(selectedOption.data('nsm') || '-');
            $('#info-nama').text(selectedOption.text().split(' - ')[1]?.split(' (')[0] || '-');
            $('#info-jenis').text(selectedOption.data('jenis') || '-');
            $('#lembaga-info').show();
        } else {
            // Hide lembaga info
            $('#lembaga-info').hide();
            $('#info-nsm').text('-');
            $('#info-nama').text('-');
            $('#info-jenis').text('-');
        }
    });
    
    // Show info if lembaga is pre-selected (from old form data)
    if ($('#lembaga_id').val()) {
        $('#lembaga_id').trigger('change');
    }
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /www/wwwroot/pkkm.pitchoiriyah.my.id/resources/views/pengawas/lembaga/create.blade.php ENDPATH**/ ?>