<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-4 py-6">
    <h1 class="text-xl font-semibold mb-4">Penilaian Saya</h1>

    <div class="card">
        <div class="card-body p-0 overflow-x-auto">
            <table class="table w-full">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Pengawas</th>
                        <th>Status</th>
                        <th>Tanggal Submit</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($item->id); ?></td>
                            <td><?php echo e($item->pengawas?->name ?? '-'); ?></td>
                            <td><?php echo e(ucfirst($item->status)); ?></td>
                            <td><?php echo e(optional($item->tanggal_submit)->format('d/m/Y H:i') ?? '-'); ?></td>
                            <td>
                                <div class="btn-group" role="group">
                                    <a href="<?php echo e(route('kepala.penilaian.show', $item->id)); ?>" class="btn btn-sm btn-primary" title="Lihat Detail Penilaian">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <?php if(in_array($item->status, ['validated', 'final'])): ?>
                                    <a href="<?php echo e(route('kepala.penilaian.raport', $item->id)); ?>" class="btn btn-sm btn-success" target="_blank" title="Download Raport PDF">
                                        <i class="fas fa-file-pdf"></i>
                                    </a>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="5" class="text-center py-6">Belum ada penilaian.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <div class="mt-4">
        <?php echo e($items->links()); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /www/wwwroot/pkkm.pitchoiriyah.my.id/resources/views/kepala/penilaian_kepala/index.blade.php ENDPATH**/ ?>