<?php $__env->startSection('title', 'Detail Distribusi Instrumen'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-eye"></i> Detail Distribusi Instrumen
                    </h3>
                    <div class="card-tools">
                        <a href="<?php echo e(route('pengawas.distribusi.index')); ?>" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Kembali
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <?php if(session('success')): ?>
                        <div class="alert alert-success alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            <?php echo e(session('success')); ?>

                        </div>
                    <?php endif; ?>

                    <!-- Distribusi Information -->
                    <div class="row mb-4">
                        <div class="col-md-8">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">
                                        <i class="fas fa-info-circle"></i> Informasi Distribusi
                                    </h4>
                                </div>
                                <div class="card-body">
                                    <dl class="row">
                                        <dt class="col-sm-3">Instrumen:</dt>
                                        <dd class="col-sm-9">
                                            <strong><?php echo e($distribusi->instrumen->judul); ?></strong>
                                            <br>
                                            <small class="text-muted"><?php echo e($distribusi->instrumen->tahun_ajaran); ?> - Semester <?php echo e($distribusi->instrumen->semester); ?></small>
                                        </dd>

                                        <dt class="col-sm-3">Lembaga:</dt>
                                        <dd class="col-sm-9">
                                            <strong><?php echo e($distribusi->lembaga->nama_lembaga); ?></strong>
                                            <br>
                                            <small class="text-muted"><?php echo e($distribusi->lembaga->jenis); ?> - <?php echo e($distribusi->lembaga->kecamatan_name ?? $distribusi->lembaga->kecamatan); ?></small>
                                        </dd>

                                        <dt class="col-sm-3">Tanggal Distribusi:</dt>
                                        <dd class="col-sm-9"><?php echo e($distribusi->tanggal_distribusi->format('d F Y')); ?></dd>

                                        <dt class="col-sm-3">Deadline:</dt>
                                        <dd class="col-sm-9">
                                            <?php echo e($distribusi->deadline->format('d F Y')); ?>

                                            <?php if($distribusi->deadline->isPast() && $distribusi->status == 'active'): ?>
                                                <span class="badge badge-danger ml-2">Terlambat</span>
                                            <?php elseif($distribusi->deadline->diffInDays() <= 7 && $distribusi->status == 'active'): ?>
                                                <span class="badge badge-warning ml-2">Mendekati Deadline</span>
                                            <?php endif; ?>
                                        </dd>

                                        <dt class="col-sm-3">Status:</dt>
                                        <dd class="col-sm-9">
                                            <?php if($distribusi->status == 'active'): ?>
                                                <span class="badge badge-success">Aktif</span>
                                            <?php else: ?>
                                                <span class="badge badge-secondary">Ditutup</span>
                                            <?php endif; ?>
                                        </dd>

                                        <dt class="col-sm-3">Komponen:</dt>
                                        <dd class="col-sm-9">
                                            <?php if($distribusi->komponen): ?>
                                                <span class="badge badge-info">
                                                    <i class="fas fa-puzzle-piece"></i> <?php echo e($distribusi->komponen->nama_komponen); ?>

                                                </span>
                                                <?php if($distribusi->komponen->deskripsi): ?>
                                                    <br><small class="text-muted"><?php echo e($distribusi->komponen->deskripsi); ?></small>
                                                <?php endif; ?>
                                            <?php else: ?>
                                                <span class="badge badge-success">
                                                    <i class="fas fa-check-circle"></i> Semua Komponen
                                                </span>
                                            <?php endif; ?>
                                        </dd>
                                    </dl>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">
                                        <i class="fas fa-chart-pie"></i> Statistik Penilaian
                                    </h4>
                                </div>
                                <div class="card-body">
                                    <div class="row text-center">
                                        <div class="col-6">
                                            <div class="border-right">
                                                <h3 class="text-primary"><?php echo e($penilaianStats['total_kepala']); ?></h3>
                                                <small class="text-muted">Total Kepala</small>
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <h3 class="text-success"><?php echo e($penilaianStats['validated']); ?></h3>
                                            <small class="text-muted">Selesai</small>
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="row">
                                        <div class="col-6">
                                            <small class="text-muted">
                                                <i class="fas fa-clock text-warning"></i> Draft: <?php echo e($penilaianStats['draft']); ?>

                                            </small>
                                        </div>
                                        <div class="col-6">
                                            <small class="text-muted">
                                                <i class="fas fa-paper-plane text-info"></i> Submitted: <?php echo e($penilaianStats['submitted']); ?>

                                            </small>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-6">
                                            <small class="text-muted">
                                                <i class="fas fa-edit text-warning"></i> Revision: <?php echo e($penilaianStats['revision']); ?>

                                            </small>
                                        </div>
                                        <div class="col-6">
                                            <small class="text-muted">
                                                <i class="fas fa-check-circle text-success"></i> Validated: <?php echo e($penilaianStats['validated']); ?>

                                            </small>
                                        </div>
                                    </div>
                                    
                                    <?php if($penilaianStats['total_kepala'] > 0): ?>
                                    <?php
                                        $percentage = round(($penilaianStats['validated'] / $penilaianStats['total_kepala']) * 100, 1);
                                    ?>
                                    <div class="mt-3">
                                        <div class="progress" style="height: 20px;">
                                            <div class="progress-bar bg-success" role="progressbar" style="width: <?php echo e($percentage); ?>%" aria-valuenow="<?php echo e($percentage); ?>" aria-valuemin="0" aria-valuemax="100">
                                                <?php echo e($percentage); ?>%
                                            </div>
                                        </div>
                                        <small class="text-muted">Progress Penyelesaian</small>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Penilaian Kepala Table -->
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">
                                <i class="fas fa-user-tie"></i> Status Penilaian Kepala
                            </h4>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th width="5%">No</th>
                                            <th>Nama Kepala</th>
                                            <th>Email</th>
                                            <th>Lembaga</th>
                                            <th>Status</th>
                                            <th>Tanggal Submit</th>
                                            <th>Tanggal Validasi</th>
                                            <th width="10%">Aksi</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__empty_1 = true; $__currentLoopData = $distribusi->penilaianKepala; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $penilaian): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td><?php echo e($loop->iteration); ?></td>
                                            <td>
                                                <strong><?php echo e($penilaian->kepala->name ?? '-'); ?></strong>
                                            </td>
                                            <td><?php echo e($penilaian->kepala->email ?? '-'); ?></td>
                                            <td><?php echo e($distribusi->lembaga->nama_lembaga ?? '-'); ?></td>
                                            <td>
                                                <?php switch($penilaian->status):
                                                    case ('draft'): ?>
                                                        <span class="badge badge-secondary">Draft</span>
                                                        <?php break; ?>
                                                    <?php case ('submitted'): ?>
                                                        <span class="badge badge-primary">Submitted</span>
                                                        <?php break; ?>
                                                    <?php case ('revision'): ?>
                                                        <span class="badge badge-warning">Revision</span>
                                                        <?php break; ?>
                                                    <?php case ('validated'): ?>
                                                        <span class="badge badge-success">Validated</span>
                                                        <?php break; ?>
                                                    <?php case ('final'): ?>
                                                        <span class="badge badge-primary">Final</span>
                                                        <?php break; ?>
                                                <?php endswitch; ?>
                                            </td>
                                            <td>
                                                <?php if($penilaian->tanggal_submit): ?>
                                                    <?php echo e($penilaian->tanggal_submit->format('d/m/Y H:i')); ?>

                                                <?php else: ?>
                                                    <span class="text-muted">-</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if($penilaian->tanggal_validasi): ?>
                                                    <?php echo e($penilaian->tanggal_validasi->format('d/m/Y H:i')); ?>

                                                <?php else: ?>
                                                    <span class="text-muted">-</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <a href="<?php echo e(route('pengawas.penilaian.show', $penilaian->id)); ?>" class="btn btn-info btn-sm" title="Review/Isi Penilaian">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                            </td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="8" class="text-center">
                                                <div class="py-4">
                                                    <i class="fas fa-user-tie fa-3x text-muted mb-3"></i>
                                                    <h5 class="text-muted">Belum ada data penilaian kepala</h5>
                                                    <p class="text-muted">Kepala belum mulai mengisi instrumen penilaian.</p>
                                                </div>
                                            </td>
                                        </tr>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card-footer">
                    <div class="d-flex justify-content-between">
                        <a href="<?php echo e(route('pengawas.distribusi.index')); ?>" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Kembali ke Daftar
                        </a>
                        
                        <?php if($distribusi->status == 'active'): ?>
                            <form action="<?php echo e(route('pengawas.distribusi.close', $distribusi->id)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Apakah Anda yakin ingin menutup distribusi ini? Tindakan ini tidak dapat dibatalkan.')">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="btn btn-warning">
                                    <i class="fas fa-lock"></i> Tutup Distribusi
                                </button>
                            </form>
                        <?php else: ?>
                            <span class="text-muted">
                                <i class="fas fa-lock"></i> Distribusi sudah ditutup
                            </span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function() {
    // Auto-hide alerts after 5 seconds
    setTimeout(function() {
        $('.alert').fadeOut('slow');
    }, 5000);
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /www/wwwroot/pkkm.pitchoiriyah.my.id/resources/views/pengawas/distribusi/show.blade.php ENDPATH**/ ?>