<?php $__env->startSection('title', 'Dashboard Kepala Madrasah'); ?>

<?php $__env->startSection('breadcrumb'); ?>
<li class="breadcrumb-item active">Dashboard</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- Info boxes -->
<div class="row">
    <div class="col-12 col-sm-6 col-md-3">
        <div class="info-box">
            <span class="info-box-icon bg-info elevation-1"><i class="fas fa-chalkboard-teacher"></i></span>
            <div class="info-box-content">
                <span class="info-box-text">Total Guru</span>
                <span class="info-box-number"><?php echo e($stats['total_guru']); ?></span>
            </div>
        </div>
    </div>
    <div class="col-12 col-sm-6 col-md-3">
        <div class="info-box mb-3">
            <span class="info-box-icon bg-success elevation-1"><i class="fas fa-clipboard-list"></i></span>
            <div class="info-box-content">
                <span class="info-box-text">Instrumen Diterima</span>
                <span class="info-box-number"><?php echo e($stats['total_instrumen_distributed']); ?></span>
            </div>
        </div>
    </div>
    <div class="clearfix hidden-md-up"></div>
    <div class="col-12 col-sm-6 col-md-3">
        <div class="info-box mb-3">
            <span class="info-box-icon bg-warning elevation-1"><i class="fas fa-star"></i></span>
            <div class="info-box-content">
                <span class="info-box-text">Penilaian Berlangsung</span>
                <span class="info-box-number"><?php echo e($stats['penilaian_by_status']['draft'] + $stats['penilaian_by_status']['submitted']); ?></span>
            </div>
        </div>
    </div>
    <div class="col-12 col-sm-6 col-md-3">
        <div class="info-box mb-3">
            <span class="info-box-icon bg-danger elevation-1"><i class="fas fa-check-circle"></i></span>
            <div class="info-box-content">
                <span class="info-box-text">Sudah Divalidasi</span>
                <span class="info-box-number"><?php echo e($stats['penilaian_by_status']['validated'] + $stats['penilaian_by_status']['final']); ?></span>
            </div>
        </div>
    </div>
</div>

<!-- Data Lembaga Status -->
<?php
    $lembagaFields = [
        'alamat_lengkap' => $lembaga->alamat_lengkap,
        'kelurahan' => $lembaga->kelurahan,
        'kecamatan' => $lembaga->kecamatan,
        'kabupaten' => $lembaga->kabupaten,
        'provinsi' => $lembaga->provinsi,
        'kode_pos' => $lembaga->kode_pos,
        'telepon' => $lembaga->telepon,
        'email' => $lembaga->email,
        'akreditasi' => $lembaga->akreditasi,
        'tahun_berdiri' => $lembaga->tahun_berdiri,
    ];
    $emptyFields = array_filter($lembagaFields, function($value) {
        return empty($value);
    });
    $completenessPercentage = round((count($lembagaFields) - count($emptyFields)) / count($lembagaFields) * 100, 1);
?>

<?php if(count($emptyFields) > 0): ?>
<div class="row">
    <div class="col-12">
        <div class="alert alert-warning alert-dismissible fade show" role="alert">
            <h4 class="alert-heading">
                <i class="fas fa-exclamation-triangle"></i> Data Lembaga Belum Lengkap!
            </h4>
            <p class="mb-2">Kelengkapan data lembaga Anda saat ini: <strong><?php echo e($completenessPercentage); ?>%</strong></p>
            <p class="mb-3">Silakan lengkapi data lembaga untuk memaksimalkan penggunaan sistem.</p>
            <hr>
            <div class="row">
                <div class="col-md-6">
                    <h6>Field yang masih kosong:</h6>
                    <ul class="mb-0">
                        <?php $__currentLoopData = $emptyFields; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $field => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e(ucfirst(str_replace('_', ' ', $field))); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
                <div class="col-md-6">
                    <h6>Aksi yang dapat dilakukan:</h6>
                    <a href="<?php echo e(route('kepala.lembaga.edit')); ?>" class="btn btn-warning btn-sm">
                        <i class="fas fa-edit"></i> Lengkapi Data Lembaga
                    </a>
                    <a href="<?php echo e(route('kepala.lembaga.index')); ?>" class="btn btn-info btn-sm">
                        <i class="fas fa-info-circle"></i> Lihat Detail Lembaga
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
<?php else: ?>
<div class="row">
    <div class="col-12">
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <h4 class="alert-heading">
                <i class="fas fa-check-circle"></i> Data Lembaga Sudah Lengkap!
            </h4>
            <p class="mb-0">Selamat! Data lembaga Anda sudah lengkap (<?php echo e($completenessPercentage); ?>%).</p>
        </div>
    </div>
</div>
<?php endif; ?>

<!-- Main row -->
<div class="row">
    <!-- Lembaga Information Card -->
    <div class="col-md-4">
        <div class="card card-primary">
            <div class="card-header">
                <h3 class="card-title">
                    <i class="fas fa-school"></i> Informasi Lembaga
                </h3>
                <div class="card-tools">
                    <a href="<?php echo e(route('kepala.lembaga.index')); ?>" class="btn btn-tool">
                        <i class="fas fa-external-link-alt"></i>
                    </a>
                </div>
            </div>
            <div class="card-body">
                <h5 class="text-primary"><?php echo e($lembaga->nama_lembaga); ?></h5>
                <p class="text-muted mb-2">
                    <strong>NSM:</strong> <?php echo e($lembaga->npsn_nsm); ?><br>
                    <strong>Jenis:</strong> 
                    <span class="badge badge-<?php echo e($lembaga->jenis == 'RA' ? 'primary' : ($lembaga->jenis == 'MI' ? 'success' : ($lembaga->jenis == 'MTs' ? 'info' : 'warning'))); ?>">
                        <?php echo e($lembaga->jenis); ?>

                    </span>
                </p>
                
                <?php if($lembaga->alamat_lengkap): ?>
                    <p class="text-muted mb-2">
                        <strong>Alamat:</strong><br>
                        <?php echo e($lembaga->alamat_lengkap); ?><br>
                        <?php echo e($lembaga->kelurahan_name ?? $lembaga->kelurahan); ?>, <?php echo e($lembaga->kecamatan_name ?? $lembaga->kecamatan); ?><br>
                        <?php echo e($lembaga->kabupaten_name ?? $lembaga->kabupaten); ?>, <?php echo e($lembaga->provinsi_name ?? $lembaga->provinsi); ?> <?php echo e($lembaga->kode_pos); ?>

                    </p>
                <?php else: ?>
                    <div class="alert alert-warning alert-sm">
                        <i class="fas fa-exclamation-triangle"></i> Alamat belum dilengkapi
                    </div>
                <?php endif; ?>
                
                <?php if($lembaga->telepon || $lembaga->email): ?>
                    <p class="text-muted mb-2">
                        <?php if($lembaga->telepon): ?>
                            <strong>Telepon:</strong> <?php echo e($lembaga->telepon); ?><br>
                        <?php endif; ?>
                        <?php if($lembaga->email): ?>
                            <strong>Email:</strong> <?php echo e($lembaga->email); ?><br>
                        <?php endif; ?>
                    </p>
                <?php endif; ?>
                
                <div class="mt-3">
                    <a href="<?php echo e(route('kepala.lembaga.edit')); ?>" class="btn btn-primary btn-sm btn-block">
                        <i class="fas fa-edit"></i> Edit Data Lembaga
                    </a>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Guru di Lembaga</h3>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Nama Guru</th>
                                <th>Mata Pelajaran</th>
                                <th>Kelas</th>
                                <th>Status Kepegawaian</th>
                                <th>Status Sertifikasi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = \App\Models\Guru::where('lembaga_id', $lembaga->id)->take(5)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $guru): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($guru->nama_lengkap_with_gelar); ?></td>
                                <td><?php echo e($guru->mata_pelajaran); ?></td>
                                <td><?php echo e($guru->kelas_diampu); ?></td>
                                <td><span class="badge badge-info"><?php echo e($guru->status_kepegawaian); ?></span></td>
                                <td><span class="badge badge-<?php echo e($guru->status_sertifikasi == 'sudah' ? 'success' : 'warning'); ?>"><?php echo e(ucfirst($guru->status_sertifikasi)); ?></span></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="5" class="text-center">Belum ada guru terdaftar</td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Instrumen Penilaian</h3>
                <div class="card-tools">
                    <a href="<?php echo e(route('kepala.instrumen.index')); ?>" class="btn btn-tool">
                        <i class="fas fa-external-link-alt"></i>
                    </a>
                </div>
            </div>
            <div class="card-body">
                <?php
                    $user = Auth::user();
                    $lembaga = $user->lembagaKepala()->first();
                    $recentInstrumen = $lembaga ? \App\Models\DistribusiInstrumen::with(['instrumen', 'komponen'])
                        ->where('lembaga_id', $lembaga->id)
                        ->latest()
                        ->take(3)
                        ->get() : collect();
                ?>
                
                <?php if($recentInstrumen->count() > 0): ?>
                    <ul class="list-group list-group-flush">
                        <?php $__currentLoopData = $recentInstrumen; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $distribusi): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="mb-1"><?php echo e(Str::limit($distribusi->instrumen->judul, 30)); ?></h6>
                                <small class="text-muted"><?php echo e($distribusi->instrumen->tahun_ajaran); ?> - Semester <?php echo e($distribusi->instrumen->semester); ?></small>
                                <br>
                                <small class="text-muted"><?php echo e($distribusi->tanggal_distribusi->format('d/m/Y')); ?></small>
                                <?php if($distribusi->komponen): ?>
                                    <br><span class="badge badge-info badge-sm">
                                        <i class="fas fa-puzzle-piece"></i> <?php echo e($distribusi->komponen->nama_komponen); ?>

                                    </span>
                                <?php else: ?>
                                    <br><span class="badge badge-success badge-sm">
                                        <i class="fas fa-check-circle"></i> Semua
                                    </span>
                                <?php endif; ?>
                            </div>
                            <div class="text-right">
                                <?php if($distribusi->status == 'active'): ?>
                                    <span class="badge badge-success">Aktif</span>
                                <?php else: ?>
                                    <span class="badge badge-secondary">Ditutup</span>
                                <?php endif; ?>
                                <br>
                                <a href="<?php echo e(route('kepala.instrumen.show', $distribusi->id)); ?>" class="btn btn-sm btn-primary mt-1">
                                    <i class="fas fa-eye"></i>
                                </a>
                            </div>
                        </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                    <div class="mt-3">
                        <a href="<?php echo e(route('kepala.instrumen.index')); ?>" class="btn btn-primary btn-sm btn-block">
                            <i class="fas fa-clipboard-list"></i> Lihat Semua Instrumen
                        </a>
                    </div>
                <?php else: ?>
                    <div class="text-center py-3">
                        <i class="fas fa-clipboard-list fa-2x text-muted mb-2"></i>
                        <p class="text-muted mb-0">Belum ada instrumen</p>
                        <small class="text-muted">Pengawas belum mendistribusikan instrumen</small>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Penilaian Terbaru</h3>
            </div>
            <div class="card-body">
                <ul class="list-group list-group-flush">
                    <?php $__empty_1 = true; $__currentLoopData = \App\Models\PenilaianKepala::where('kepala_id', Auth::id())->latest()->take(3)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $penilaian): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <li class="list-group-item d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="mb-1"><?php echo e($penilaian->distribusiInstrumen->instrumen->judul); ?></h6>
                            <small class="text-muted">Oleh Pengawas: <?php echo e($penilaian->pengawas?->name ?? '-'); ?></small>
                        </div>
                        <span class="badge badge-<?php echo e(in_array($penilaian->status, ['validated','final']) ? 'success' : ($penilaian->status == 'submitted' ? 'warning' : 'info')); ?>">
                            <?php echo e(ucfirst($penilaian->status)); ?>

                        </span>
                    </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <li class="list-group-item text-center text-muted">Belum ada penilaian</li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /www/wwwroot/pkkm.pitchoiriyah.my.id/resources/views/kepala/dashboard.blade.php ENDPATH**/ ?>