<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(\App\Helpers\AppHelper::getAppName()); ?> - <?php echo $__env->yieldContent('title', 'Dashboard'); ?></title>

    <?php if(\App\Helpers\AppHelper::getAppFavicon()): ?>
        <link rel="icon" type="image/x-icon" href="<?php echo e(\App\Helpers\AppHelper::getAppFavicon()); ?>">
    <?php endif; ?>

    <!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css?family=Nunito" rel="stylesheet">

    <!-- AdminLTE CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <!-- DataTables -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap4.min.css">

    <style>
        /* Deep ocean blue */
        :root { --ocean1: #005f9e; --ocean2: #003e6b; }
        .main-sidebar {
            background: linear-gradient(180deg, var(--ocean1), var(--ocean2)) !important;
        }
        .brand-link, .sidebar .nav-header { color: #ffffff !important; }
        .sidebar .nav-link { color: #ffffff !important; }
        .sidebar .nav-link:hover { background-color: rgba(255,255,255,0.12) !important; color: #ffffff !important; }
        .sidebar .nav-link.active, .sidebar-dark-primary .nav-sidebar>.nav-item>.nav-link.active {
            background-color: rgba(255,255,255,0.22) !important; color: #ffffff !important;
        }
    </style>

    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body class="hold-transition sidebar-mini layout-fixed">
    <div class="wrapper">
        <!-- Navbar -->
        <nav class="main-header navbar navbar-expand navbar-white navbar-light">
            <ul class="navbar-nav">
                <li class="nav-item">
                    <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
                </li>
            </ul>

            <ul class="navbar-nav ml-auto">
                <li class="nav-item">
                    <a class="nav-link" href="#" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                        <i class="fas fa-sign-out-alt"></i> Logout
                    </a>
                    <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                        <?php echo csrf_field(); ?>
                    </form>
                </li>
            </ul>
        </nav>

        <!-- Main Sidebar Container -->
        <aside class="main-sidebar sidebar-dark-primary elevation-4">
            <!-- Brand Logo -->
            <a href="<?php echo e(route('dashboard')); ?>" class="brand-link">
                <img src="<?php echo e(\App\Helpers\AppHelper::getAppLogo()); ?>" alt="App Logo" class="brand-image img-circle elevation-3" style="opacity: .8">
                <span class="brand-text font-weight-light"><?php echo e(\App\Helpers\AppHelper::getAppName()); ?></span>
            </a>

            <!-- Sidebar -->
            <div class="sidebar">
                <!-- Sidebar user panel -->
                <div class="user-panel mt-3 pb-3 mb-3 d-flex">
                    <div class="image">
                        <?php
                            $avatarPath = Auth::user()->avatar ?: Auth::user()->foto_profil;
                            $avatarUrl = null;
                            if ($avatarPath) {
                                if (preg_match('#^https?://#', $avatarPath) || str_starts_with($avatarPath, '/storage/')) {
                                    $avatarUrl = $avatarPath;
                                } elseif (\Illuminate\Support\Facades\Storage::disk('public')->exists($avatarPath)) {
                                    $avatarUrl = \Illuminate\Support\Facades\Storage::url($avatarPath);
                                }
                            }
                        ?>
                        <?php if($avatarUrl): ?>
                            <img src="<?php echo e($avatarUrl); ?>" class="img-circle elevation-2" alt="User Image">
                        <?php else: ?>
                            <img src="<?php echo e(asset('vendor/adminlte/dist/img/avatar5.png')); ?>" class="img-circle elevation-2" alt="User Image">
                        <?php endif; ?>
                    </div>
                    <div class="info">
                        <a href="#" class="d-block"><?php echo e(Auth::user()->name); ?></a>
                        <small class="text-muted"><?php echo e(ucfirst(Auth::user()->role)); ?></small>
                    </div>
                </div>

                <!-- Sidebar Menu -->
                <nav class="mt-2">
                    <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">
                        <li class="nav-item">
                            <a href="<?php echo e(route('dashboard')); ?>" class="nav-link <?php echo e(request()->routeIs('dashboard') ? 'active' : ''); ?>">
                                <i class="nav-icon fas fa-tachometer-alt"></i>
                                <p>Dashboard</p>
                            </a>
                        </li>

                        <?php if(Auth::user()->hasRole('admin')): ?>
                            <li class="nav-header">ADMINISTRATOR</li>

                            <li class="nav-item">
                                <a href="<?php echo e(route('admin.users.index')); ?>" class="nav-link <?php echo e(request()->routeIs('admin.users.*') ? 'active' : ''); ?>">
                                    <i class="nav-icon fas fa-users"></i>
                                    <p>Manajemen User</p>
                                </a>
                            </li>

                            <li class="nav-item">
                                <a href="<?php echo e(route('admin.lembaga.index')); ?>" class="nav-link <?php echo e(request()->routeIs('admin.lembaga.*') ? 'active' : ''); ?>">
                                    <i class="nav-icon fas fa-school"></i>
                                    <p>Manajemen Lembaga</p>
                                </a>
                            </li>

                            <li class="nav-item">
                                <a href="<?php echo e(route('admin.instrumen.index')); ?>" class="nav-link <?php echo e(request()->routeIs('admin.instrumen.*') ? 'active' : ''); ?>">
                                    <i class="nav-icon fas fa-clipboard-list"></i>
                                    <p>Manajemen Instrumen</p>
                                </a>
                            </li>

                            <li class="nav-item">
                                <a href="<?php echo e(route('admin.settings.index')); ?>" class="nav-link <?php echo e(request()->routeIs('admin.settings.*') ? 'active' : ''); ?>">
                                    <i class="nav-icon fas fa-cog"></i>
                                    <p>Pengaturan</p>
                                </a>
                            </li>
                        <?php endif; ?>

                        <?php if(Auth::user()->hasRole('pengawas')): ?>
                            <li class="nav-header">PENGAWAS</li>
                            <li class="nav-item">
                                <a href="<?php echo e(route('pengawas.dashboard')); ?>" class="nav-link <?php echo e(request()->routeIs('pengawas.*') ? 'active' : ''); ?>">
                                    <i class="nav-icon fas fa-user-check"></i>
                                    <p>Beranda Pengawas</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="<?php echo e(route('pengawas.lembaga.index')); ?>" class="nav-link <?php echo e(request()->routeIs('pengawas.lembaga.*') ? 'active' : ''); ?>">
                                    <i class="nav-icon fas fa-school"></i>
                                    <p>Lembaga Binaan</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="<?php echo e(route('pengawas.instrumen.index')); ?>" class="nav-link <?php echo e(request()->routeIs('pengawas.instrumen.*') ? 'active' : ''); ?>">
                                    <i class="nav-icon fas fa-clipboard-list"></i>
                                    <p>Instrumen</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="<?php echo e(route('pengawas.distribusi.index')); ?>" class="nav-link <?php echo e(request()->routeIs('pengawas.distribusi.*') ? 'active' : ''); ?>">
                                    <i class="nav-icon fas fa-share-alt"></i>
                                    <p>Distribusi</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="<?php echo e(route('pengawas.penilaian.index')); ?>" class="nav-link <?php echo e(request()->routeIs('pengawas.penilaian.*') ? 'active' : ''); ?>">
                                    <i class="nav-icon fas fa-star"></i>
                                    <p>Penilaian Kepala</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="<?php echo e(route('pengawas.profile.index')); ?>" class="nav-link <?php echo e(request()->routeIs('pengawas.profile.*') ? 'active' : ''); ?>">
                                    <i class="nav-icon fas fa-user"></i>
                                    <p>Profil</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="<?php echo e(route('pengawas.docs')); ?>" class="nav-link <?php echo e(request()->routeIs('pengawas.docs') ? 'active' : ''); ?>">
                                    <i class="nav-icon fas fa-book-open"></i>
                                    <p>Dokumentasi</p>
                                </a>
                            </li>
                        <?php endif; ?>

                        <?php if(Auth::user()->hasRole('kepala')): ?>
                            <li class="nav-header">KEPALA SEKOLAH</li>
                            <li class="nav-item">
                                <a href="<?php echo e(route('kepala.dashboard')); ?>" class="nav-link <?php echo e(request()->routeIs('kepala.*') ? 'active' : ''); ?>">
                                    <i class="nav-icon fas fa-user-tie"></i>
                                    <p>Beranda Kepala</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="<?php echo e(route('kepala.lembaga.index')); ?>" class="nav-link <?php echo e(request()->routeIs('kepala.lembaga.*') ? 'active' : ''); ?>">
                                    <i class="nav-icon fas fa-school"></i>
                                    <p>Lembaga Saya</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="<?php echo e(route('kepala.instrumen.index')); ?>" class="nav-link <?php echo e(request()->routeIs('kepala.instrumen.*') ? 'active' : ''); ?>">
                                    <i class="nav-icon fas fa-clipboard-list"></i>
                                    <p>Instrumen Penilaian</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="<?php echo e(route('kepala.penilaian.index')); ?>" class="nav-link <?php echo e(request()->routeIs('kepala.penilaian.*') ? 'active' : ''); ?>">
                                    <i class="nav-icon fas fa-star"></i>
                                    <p>Penilaian</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="<?php echo e(route('kepala.profile.index')); ?>" class="nav-link <?php echo e(request()->routeIs('kepala.profile.*') ? 'active' : ''); ?>">
                                    <i class="nav-icon fas fa-user"></i>
                                    <p>Profil</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="<?php echo e(route('kepala.docs')); ?>" class="nav-link <?php echo e(request()->routeIs('kepala.docs') ? 'active' : ''); ?>">
                                    <i class="nav-icon fas fa-book-open"></i>
                                    <p>Dokumentasi</p>
                                </a>
                            </li>
                        <?php endif; ?>

                        <li class="nav-item">
                            <a href="#" class="nav-link" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                                <i class="nav-icon fas fa-sign-out-alt"></i>
                                <p>Logout</p>
                            </a>
                        </li>
                    </ul>
                </nav>
            </div>
        </aside>

        <!-- Content Wrapper -->
        <div class="content-wrapper">
            <section class="content pt-3">
                <div class="container-fluid">
                    <?php echo $__env->yieldContent('content'); ?>
                </div>
            </section>
        </div>

        <footer class="main-footer">
            <strong>&copy; <?php echo e(date('Y')); ?> <?php echo e(\App\Helpers\AppHelper::getAppName()); ?></strong>
            <div class="float-right d-none d-sm-inline-block">
                <b>Version</b> <?php echo e(\App\Helpers\AppHelper::getAppVersion()); ?>

            </div>
        </footer>
    </div>

    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- Bootstrap 4 -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
    <!-- AdminLTE App -->
    <script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/js/adminlte.min.js"></script>
    <!-- DataTables -->
    <script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap4.min.js"></script>

    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html>


<?php /**PATH /www/wwwroot/pkkm.pitchoiriyah.my.id/resources/views/layouts/app.blade.php ENDPATH**/ ?>