<?php $__env->startSection('title', 'Informasi Lembaga'); ?>

<?php $__env->startSection('breadcrumb'); ?>
<li class="breadcrumb-item active">Lembaga Saya</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <!-- Info Cards -->
    <div class="col-md-4">
        <div class="info-box bg-info">
            <span class="info-box-icon"><i class="fas fa-school"></i></span>
            <div class="info-box-content">
                <span class="info-box-text">Nama Lembaga</span>
                <span class="info-box-number"><?php echo e(Str::limit($lembaga->nama_lembaga, 15)); ?></span>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="info-box bg-success">
            <span class="info-box-icon"><i class="fas fa-users"></i></span>
            <div class="info-box-content">
                <span class="info-box-text">Total Guru</span>
                <span class="info-box-number"><?php echo e($lembaga->guru()->count()); ?></span>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="info-box bg-warning">
            <span class="info-box-icon"><i class="fas fa-user-tie"></i></span>
            <div class="info-box-content">
                <span class="info-box-text">Pengawas</span>
                <span class="info-box-number"><?php echo e($lembaga->pengawas ? Str::limit($lembaga->pengawas->name, 10) : 'Belum ada'); ?></span>
            </div>
        </div>
    </div>
</div>

<div class="row mt-4">
    <!-- Lembaga Information -->
    <div class="col-md-8">
        <div class="card card-primary card-outline">
            <div class="card-header">
                <h3 class="card-title">
                    <i class="fas fa-info-circle"></i> Informasi Lembaga
                </h3>
                <div class="card-tools">
                    <a href="<?php echo e(route('kepala.lembaga.download-cover-raport')); ?>" class="btn btn-info btn-sm" target="_blank" title="Download Cover Raport PDF">
                        <i class="fas fa-file-alt"></i>
                    </a>
                    <a href="<?php echo e(route('kepala.lembaga.download-profil')); ?>" class="btn btn-success btn-sm" target="_blank" title="Download Profil PDF">
                        <i class="fas fa-file-pdf"></i>
                    </a>
                    <a href="<?php echo e(route('kepala.lembaga.edit')); ?>" class="btn btn-warning btn-sm" title="Edit Data Lembaga">
                        <i class="fas fa-edit"></i>
                    </a>
                </div>
            </div>
            <div class="card-body">
                <!-- Logo Lembaga -->
                <?php if($lembaga->logo_lembaga): ?>
                    <div class="row mb-4">
                        <div class="col-12">
                            <div class="text-center">
                                <h5><i class="fas fa-image"></i> Logo Lembaga</h5>
                                <img src="<?php echo e(Storage::url($lembaga->logo_lembaga)); ?>" 
                                     alt="Logo <?php echo e($lembaga->nama_lembaga); ?>" 
                                     class="img-fluid rounded shadow" 
                                     style="max-height: 200px; max-width: 300px;">
                                <p class="text-muted mt-2">
                                    <small>Logo dapat diubah melalui menu Edit</small>
                                </p>
                            </div>
                        </div>
                    </div>
                    <hr>
                <?php endif; ?>
                <dl class="row">
                    <dt class="col-sm-3">Nama Lembaga:</dt>
                    <dd class="col-sm-9"><strong><?php echo e($lembaga->nama_lembaga); ?></strong></dd>
                    
                    <dt class="col-sm-3">NSM:</dt>
                    <dd class="col-sm-9"><?php echo e($lembaga->npsn_nsm); ?></dd>
                    
                    <dt class="col-sm-3">Jenis:</dt>
                    <dd class="col-sm-9">
                        <span class="badge badge-<?php echo e($lembaga->jenis == 'RA' ? 'primary' : ($lembaga->jenis == 'MI' ? 'success' : ($lembaga->jenis == 'MTs' ? 'info' : 'warning'))); ?>">
                            <?php echo e($lembaga->jenis); ?>

                        </span>
                    </dd>
                    
                    <dt class="col-sm-3">Alamat:</dt>
                    <dd class="col-sm-9"><?php echo e($lembaga->alamat_lengkap); ?></dd>
                    
                    <dt class="col-sm-3">Kelurahan:</dt>
                    <dd class="col-sm-9"><?php echo e($lembaga->kelurahan_name ?? $lembaga->kelurahan); ?></dd>
                    
                    <dt class="col-sm-3">Kecamatan:</dt>
                    <dd class="col-sm-9"><?php echo e($lembaga->kecamatan_name ?? $lembaga->kecamatan); ?></dd>
                    
                    <dt class="col-sm-3">Kabupaten:</dt>
                    <dd class="col-sm-9"><?php echo e($lembaga->kabupaten_name ?? $lembaga->kabupaten); ?></dd>
                    
                    <dt class="col-sm-3">Provinsi:</dt>
                    <dd class="col-sm-9"><?php echo e($lembaga->provinsi_name ?? $lembaga->provinsi); ?></dd>
                    
                    <dt class="col-sm-3">Kode Pos:</dt>
                    <dd class="col-sm-9"><?php echo e($lembaga->kode_pos); ?></dd>
                    
                    <dt class="col-sm-3">Telepon:</dt>
                    <dd class="col-sm-9"><?php echo e($lembaga->telepon ?: '-'); ?></dd>
                    
                    <dt class="col-sm-3">Email:</dt>
                    <dd class="col-sm-9"><?php echo e($lembaga->email ?: '-'); ?></dd>
                    
                    <dt class="col-sm-3">Website:</dt>
                    <dd class="col-sm-9">
                        <?php if($lembaga->website): ?>
                            <a href="<?php echo e($lembaga->website); ?>" target="_blank"><?php echo e($lembaga->website); ?></a>
                        <?php else: ?>
                            -
                        <?php endif; ?>
                    </dd>
                    
                    <dt class="col-sm-3">Nama Kepala:</dt>
                    <dd class="col-sm-9">
                        <strong><?php echo e($lembaga->kepala->name ?? $lembaga->nama_kepala ?? 'Belum ada kepala'); ?></strong>
                        <?php if($lembaga->kepala_id): ?>
                            <br><small class="text-success"><i class="fas fa-check-circle"></i> Terintegrasi dengan akun sistem</small>
                        <?php else: ?>
                            <br><small class="text-warning"><i class="fas fa-exclamation-triangle"></i> Belum terintegrasi dengan akun</small>
                        <?php endif; ?>
                    </dd>
                    
                    <dt class="col-sm-3">NIP Kepala:</dt>
                    <dd class="col-sm-9"><?php echo e($lembaga->kepala->nip ?? $lembaga->nip_kepala ?? '-'); ?></dd>
                    
                    <dt class="col-sm-3">Akreditasi:</dt>
                    <dd class="col-sm-9"><?php echo e($lembaga->akreditasi ?: '-'); ?></dd>
                    
                    <dt class="col-sm-3">Tahun Berdiri:</dt>
                    <dd class="col-sm-9"><?php echo e($lembaga->tahun_berdiri ?: '-'); ?></dd>
                </dl>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="col-md-4">
        <div class="card card-success card-outline">
            <div class="card-header">
                <h3 class="card-title">
                    <i class="fas fa-bolt"></i> Aksi Cepat
                </h3>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="<?php echo e(route('kepala.lembaga.download-cover-raport')); ?>" class="btn btn-info" target="_blank" title="Download Cover Raport PDF">
                        <i class="fas fa-file-alt"></i> Download Cover Raport
                    </a>
                    <a href="<?php echo e(route('kepala.lembaga.download-profil')); ?>" class="btn btn-success" target="_blank" title="Download Profil Lembaga PDF">
                        <i class="fas fa-file-pdf"></i> Download Profil PDF
                    </a>
                    <a href="<?php echo e(route('kepala.lembaga.edit')); ?>" class="btn btn-warning" title="Edit Data Lembaga">
                        <i class="fas fa-edit"></i> Edit Data Lembaga
                    </a>
                    <a href="<?php echo e(route('kepala.instrumen.index')); ?>" class="btn btn-primary" title="Lihat Instrumen">
                        <i class="fas fa-clipboard-list"></i> Lihat Instrumen
                    </a>
                </div>
            </div>
        </div>

        <!-- Pengawas Information -->
        <div class="card card-info card-outline mt-3">
            <div class="card-header">
                <h3 class="card-title">
                    <i class="fas fa-user-tie"></i> Pengawas
                </h3>
            </div>
            <div class="card-body">
                <?php if($lembaga->pengawas): ?>
                    <p><strong>Nama:</strong> <?php echo e($lembaga->pengawas->name); ?></p>
                    <p><strong>Email:</strong> <?php echo e($lembaga->pengawas->email); ?></p>
                    <p><strong>Status:</strong> 
                        <span class="badge badge-<?php echo e($lembaga->pengawas->is_active ? 'success' : 'danger'); ?>">
                            <?php echo e($lembaga->pengawas->is_active ? 'Aktif' : 'Nonaktif'); ?>

                        </span>
                    </p>
                <?php else: ?>
                    <p class="text-muted">Belum ada pengawas yang ditugaskan</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /www/wwwroot/pkkm.pitchoiriyah.my.id/resources/views/kepala/lembaga/index.blade.php ENDPATH**/ ?>