<?php $__env->startSection('title', 'Profil Pengawas'); ?>

<?php $__env->startSection('content'); ?>
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">
                        <i class="fas fa-user"></i> Profil Pengawas
                    </h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('pengawas.dashboard')); ?>">Dashboard</a></li>
                        <li class="breadcrumb-item active">Profil</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-4">
                    <!-- Profile Card -->
                    <div class="card card-primary card-outline">
                        <div class="card-body box-profile">
                            <div class="text-center">
                                <?php if($user->foto_profil): ?>
                                    <img class="profile-user-img img-fluid img-circle" 
                                         src="<?php echo e(Storage::url($user->foto_profil)); ?>" 
                                         alt="Foto Profil">
                                <?php else: ?>
                                    <img class="profile-user-img img-fluid img-circle" 
                                         src="<?php echo e(asset('vendor/adminlte/dist/img/avatar5.png')); ?>" 
                                         alt="Foto Profil">
                                <?php endif; ?>
                            </div>

                            <h3 class="profile-username text-center"><?php echo e($user->name); ?></h3>
                            
                            <?php if($user->pengawas): ?>
                                <p class="text-muted text-center"><?php echo e($user->pengawas->nama_lengkap); ?></p>
                                <p class="text-muted text-center">
                                    <i class="fas fa-envelope"></i> <?php echo e($user->email); ?>

                                </p>
                                <?php if($user->phone): ?>
                                    <p class="text-muted text-center">
                                        <i class="fas fa-phone"></i> <?php echo e($user->phone); ?>

                                    </p>
                                <?php endif; ?>
                            <?php endif; ?>

                            <ul class="list-group list-group-unbordered mb-3">
                                <li class="list-group-item">
                                    <b>Role</b> <a class="float-right">
                                        <span class="badge badge-primary">Pengawas</span>
                                    </a>
                                </li>
                                <?php if($user->pengawas && $user->pengawas->nip): ?>
                                    <li class="list-group-item">
                                        <b>NIP</b> <a class="float-right"><?php echo e($user->pengawas->nip); ?></a>
                                    </li>
                                <?php endif; ?>
                                <?php if($user->pengawas && $user->pengawas->nuptk): ?>
                                    <li class="list-group-item">
                                        <b>NUPTK</b> <a class="float-right"><?php echo e($user->pengawas->nuptk); ?></a>
                                    </li>
                                <?php endif; ?>
                            </ul>

                            <div class="row">
                                <div class="col-6">
                                    <a href="<?php echo e(route('pengawas.profile.edit')); ?>" class="btn btn-primary btn-block">
                                        <i class="fas fa-edit"></i> Edit Profil
                                    </a>
                                </div>
                                <div class="col-6">
                                    <a href="<?php echo e(route('pengawas.profile.edit-password')); ?>" class="btn btn-warning btn-block">
                                        <i class="fas fa-key"></i> Ubah Password
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-8">
                    <!-- Profile Details -->
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fas fa-info-circle"></i> Detail Profil
                            </h3>
                        </div>
                        <div class="card-body">
                            <?php if($user->pengawas): ?>
                                <div class="row">
                                    <div class="col-md-6">
                                        <strong><i class="fas fa-user"></i> Nama Lengkap</strong>
                                        <p class="text-muted"><?php echo e($user->pengawas->nama_lengkap); ?></p>
                                    </div>
                                    <div class="col-md-6">
                                        <strong><i class="fas fa-calendar"></i> Tanggal Lahir</strong>
                                        <p class="text-muted"><?php echo e($user->pengawas->tanggal_lahir ? $user->pengawas->tanggal_lahir->format('d/m/Y') : '-'); ?></p>
                                    </div>
                                </div>
                                <hr>
                                <div class="row">
                                    <div class="col-md-6">
                                        <strong><i class="fas fa-map-marker-alt"></i> Tempat Lahir</strong>
                                        <p class="text-muted"><?php echo e($user->pengawas->tempat_lahir); ?></p>
                                    </div>
                                    <div class="col-md-6">
                                        <strong><i class="fas fa-venus-mars"></i> Jenis Kelamin</strong>
                                        <p class="text-muted"><?php echo e($user->pengawas->jenis_kelamin == 'L' ? 'Laki-laki' : 'Perempuan'); ?></p>
                                    </div>
                                </div>
                                <hr>
                                <div class="row">
                                    <div class="col-md-6">
                                        <strong><i class="fas fa-graduation-cap"></i> Pendidikan Terakhir</strong>
                                        <p class="text-muted"><?php echo e($user->pengawas->pendidikan_terakhir); ?></p>
                                    </div>
                                    <div class="col-md-6">
                                        <strong><i class="fas fa-book"></i> Jurusan</strong>
                                        <p class="text-muted"><?php echo e($user->pengawas->jurusan ?: '-'); ?></p>
                                    </div>
                                </div>
                                <hr>
                                <div class="row">
                                    <div class="col-12">
                                        <strong><i class="fas fa-home"></i> Alamat</strong>
                                        <p class="text-muted"><?php echo e($user->pengawas->alamat); ?></p>
                                    </div>
                                </div>
                            <?php else: ?>
                                <div class="alert alert-warning">
                                    <h5><i class="fas fa-exclamation-triangle"></i> Profil Belum Lengkap</h5>
                                    <p>Silakan lengkapi profil Anda untuk mengakses fitur lengkap.</p>
                                    <a href="<?php echo e(route('pengawas.profile.edit')); ?>" class="btn btn-warning">
                                        <i class="fas fa-edit"></i> Lengkapi Profil
                                    </a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /www/wwwroot/pkkm.pitchoiriyah.my.id/resources/views/pengawas/profile/index.blade.php ENDPATH**/ ?>