<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\WilayahController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

// Wilayah API routes (public for internal use)
Route::prefix('wilayah')->group(function () {
    Route::get('/provinsi', [WilayahController::class, 'getProvinces']);
    Route::get('/kabupaten', [WilayahController::class, 'getRegencies']);
    Route::get('/kecamatan', [WilayahController::class, 'getDistricts']);
    Route::get('/kelurahan', [WilayahController::class, 'getVillages']);
    
    Route::get('/provinsi/{id}', [WilayahController::class, 'getProvinceName']);
    Route::get('/kabupaten/{id}', [WilayahController::class, 'getRegencyName']);
    Route::get('/kecamatan/{id}', [WilayahController::class, 'getDistrictName']);
    Route::get('/kelurahan/{id}', [WilayahController::class, 'getVillageName']);
});
