<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Import Users - Public Access</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
</head>
<body class="bg-light">
    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header bg-primary text-white">
                        <h3 class="card-title mb-0">
                            <i class="fas fa-upload"></i> Import Users dari Excel
                        </h3>
                    </div>
                    <div class="card-body">
                        @if (session('success'))
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                {{ session('success') }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                            </div>
                        @endif

                        @if (session('error'))
                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                {{ session('error') }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                            </div>
                        @endif

                        <div class="alert alert-info">
                            <h5><i class="fas fa-info-circle"></i> Petunjuk Import:</h5>
                            <ul class="mb-0">
                                <li>Download template Excel terlebih dahulu untuk melihat format yang benar</li>
                                <li>File harus berformat .xlsx, .xls, atau .csv</li>
                                <li>Maksimal ukuran file: 2MB</li>
                                <li>Kolom yang wajib diisi: Nama Lengkap, Email</li>
                                <li>Password akan otomatis "password123" jika tidak diisi</li>
                                <li>Role yang valid: admin, pengawas, kepala, guru (case-insensitive)</li>
                                <li>Status yang valid: Aktif, Nonaktif (case-insensitive)</li>
                                <li>Email yang sudah ada akan dilewati</li>
                            </ul>
                        </div>

                        <form action="{{ route('public.users.import.store') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="mb-3">
                                <label for="file" class="form-label">Pilih File Excel</label>
                                <input type="file" class="form-control" id="file" name="file" accept=".xlsx,.xls,.csv" required>
                                @error('file')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="d-grid gap-2 d-md-flex">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-upload"></i> Import Users
                                </button>
                                <a href="{{ route('public.users.template') }}" class="btn btn-info">
                                    <i class="fas fa-file-excel"></i> Download Template
                                </a>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- Format Guide -->
                <div class="card mt-4">
                    <div class="card-header">
                        <h5><i class="fas fa-table"></i> Format Template Excel</h5>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-sm table-bordered">
                                <thead>
                                    <tr>
                                        <th>Kolom</th>
                                        <th>Wajib</th>
                                        <th>Contoh</th>
                                        <th>Keterangan</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>Nama Lengkap</td>
                                        <td><span class="badge bg-danger">Ya</span></td>
                                        <td>John Doe</td>
                                        <td>Nama lengkap user</td>
                                    </tr>
                                    <tr>
                                        <td>Email</td>
                                        <td><span class="badge bg-danger">Ya</span></td>
                                        <td>john@example.com</td>
                                        <td>Email unik</td>
                                    </tr>
                                    <tr>
                                        <td>Phone</td>
                                        <td><span class="badge bg-secondary">Tidak</span></td>
                                        <td>081234567890</td>
                                        <td>Nomor telepon</td>
                                    </tr>
                                    <tr>
                                        <td>Password</td>
                                        <td><span class="badge bg-secondary">Tidak</span></td>
                                        <td>password123</td>
                                        <td>Default: password123</td>
                                    </tr>
                                    <tr>
                                        <td>Role</td>
                                        <td><span class="badge bg-secondary">Tidak</span></td>
                                        <td>guru, Pengawas, ADMIN</td>
                                        <td>Case-insensitive</td>
                                    </tr>
                                    <tr>
                                        <td>Status</td>
                                        <td><span class="badge bg-secondary">Tidak</span></td>
                                        <td>Aktif, AKTIF, aktif</td>
                                        <td>Case-insensitive</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Update file input label
        document.getElementById('file').addEventListener('change', function(e) {
            const fileName = e.target.files[0]?.name || 'Choose file';
            const label = e.target.nextElementSibling;
            if (label) {
                label.textContent = fileName;
            }
        });
    </script>
</body>
</html>
