@extends('layouts.app')

@section('title', 'Validasi Penilaian - ' . ($penilaianGuru->kepala->name ?? 'Kepala'))

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-check-circle"></i> Validasi Penilaian Kepala
                    </h3>
                    <div class="card-tools">
                        <a href="{{ route('pengawas.validasi.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Kembali
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            {{ session('success') }}
                        </div>
                    @endif

                    @if(session('error'))
                        <div class="alert alert-danger alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            {{ session('error') }}
                        </div>
                    @endif

                    <!-- Informasi Penilaian -->
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="info-box">
                                <span class="info-box-icon bg-info">
                                    <i class="fas fa-user"></i>
                                </span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Nama Kepala</span>
                                    <span class="info-box-number">{{ $penilaianGuru->kepala->name ?? '-' }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="info-box">
                                <span class="info-box-icon bg-success">
                                    <i class="fas fa-school"></i>
                                </span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Lembaga</span>
                                    <span class="info-box-number">{{ $penilaianGuru->distribusiInstrumen?->lembaga?->nama_lembaga }}</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="info-box">
                                <span class="info-box-icon bg-warning">
                                    <i class="fas fa-clipboard-list"></i>
                                </span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Instrumen</span>
                                    <span class="info-box-number">{{ $penilaianGuru->distribusiInstrumen->instrumen->judul }}</span>
                                    <small class="text-muted">{{ $penilaianGuru->distribusiInstrumen->instrumen->tahun_ajaran }} - Semester {{ $penilaianGuru->distribusiInstrumen->instrumen->semester }}</small>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="info-box">
                                <span class="info-box-icon bg-primary">
                                    <i class="fas fa-chart-bar"></i>
                                </span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Nilai Rata-rata</span>
                                    <span class="info-box-number">
                                        @if($penilaianGuru->rata_rata)
                                            {{ number_format($penilaianGuru->rata_rata, 2) }}
                                        @else
                                            -
                                        @endif
                                    </span>
                                    <small class="text-muted">Total: {{ $penilaianGuru->total_nilai ?? 0 }}</small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Detail Jawaban dan Penilaian -->
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">
                                <i class="fas fa-list-alt"></i> Detail Jawaban dan Penilaian
                            </h4>
                        </div>
                        <div class="card-body">
                            @foreach($jawabanGuru as $jawaban)
                                @if($jawaban->instrumenItem)
                                <div class="card mb-3">
                                    <div class="card-header bg-light">
                                        <h5 class="mb-0">
                                            <i class="fas fa-question-circle text-primary"></i>
                                            {{ $jawaban->instrumenItem->no_urutan }}. {{ $jawaban->instrumenItem->indikator_kinerja }}
                                        </h5>
                                        @if($jawaban->instrumenItem->evidensi_kinerja)
                                            <p class="text-muted small mb-0 mt-2">{{ $jawaban->instrumenItem->evidensi_kinerja }}</p>
                                        @endif
                                    </div>
                                    <div class="card-body">
                                        <!-- Jawaban Guru -->
                                        <div class="row mb-3">
                                            <div class="col-md-6">
                                                <h6 class="text-primary">
                                                    <i class="fas fa-user-tie"></i> Jawaban Kepala
                                                </h6>
                                                @if($jawaban->keterangan_bukti)
                                                    <p class="mb-1">
                                                        <strong>Keterangan Bukti:</strong><br>
                                                        {{ $jawaban->keterangan_bukti }}
                                                    </p>
                                                @else
                                                    <p class="mb-1 text-muted">Guru belum memberikan keterangan bukti</p>
                                                @endif
                                                @if($jawaban->url_bukti)
                                                    <p class="mb-1">
                                                        <strong>URL Bukti:</strong><br>
                                                        <a href="{{ $jawaban->url_bukti }}" target="_blank" class="btn btn-sm btn-primary">
                                                            <i class="fas fa-external-link-alt"></i> Lihat Bukti
                                                        </a>
                                                    </p>
                                                @endif
                                            </div>
                                            <div class="col-md-6">
                                                <h6 class="text-success">
                                                    <i class="fas fa-check"></i> Penilaian Pengawas
                                                </h6>
                                                @if($jawaban->nilai_pengawas)
                                                    @php
                                                        $skorLabels = [
                                                            1 => 'Sangat Kurang',
                                                            2 => 'Kurang',
                                                            3 => 'Cukup',
                                                            4 => 'Baik',
                                                            5 => 'Sangat Baik'
                                                        ];
                                                        $label = $skorLabels[$jawaban->nilai_pengawas] ?? "Skor {$jawaban->nilai_pengawas}";
                                                    @endphp
                                                    <p class="mb-1">
                                                        <strong>Nilai:</strong> {{ $jawaban->nilai_pengawas }} - {{ $label }}
                                                    </p>
                                                @else
                                                    <p class="mb-1 text-muted">Belum dinilai oleh pengawas</p>
                                                @endif
                                                @if($jawaban->catatan_pengawas)
                                                    <p class="mb-1">
                                                        <strong>Catatan:</strong><br>
                                                        {{ $jawaban->catatan_pengawas }}
                                                    </p>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @else
                                <div class="alert alert-warning">
                                    <strong>Peringatan:</strong> Instrumen item dengan ID {{ $jawaban->instrumen_item_id }} tidak ditemukan dalam database.
                                    Jawaban guru ID: {{ $jawaban->id }}
                                </div>
                                @endif
                            @endforeach
                        </div>
                    </div>

                    <!-- Form Validasi -->
                    @if(!$penilaianGuru->validasiPengawas)
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">
                                <i class="fas fa-check-circle"></i> Form Validasi Pengawas
                            </h4>
                        </div>
                        <div class="card-body">
                            <form action="{{ route('pengawas.validasi.store', $penilaianGuru->id) }}" method="POST">
                                @csrf
                                
                                <div class="form-group">
                                    <label for="status">Status Validasi <span class="text-danger">*</span></label>
                                    <select name="status" id="status" class="form-control @error('status') is-invalid @enderror" required>
                                        <option value="">Pilih Status Validasi</option>
                                        <option value="approved" {{ old('status') == 'approved' ? 'selected' : '' }}>
                                            <i class="fas fa-check-circle"></i> Disetujui
                                        </option>
                                        <option value="revision" {{ old('status') == 'revision' ? 'selected' : '' }}>
                                            <i class="fas fa-edit"></i> Perlu Revisi
                                        </option>
                                    </select>
                                    @error('status')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="feedback">Feedback / Catatan</label>
                                    <textarea name="feedback" id="feedback" rows="4" class="form-control @error('feedback') is-invalid @enderror" placeholder="Berikan feedback atau catatan untuk penilaian ini...">{{ old('feedback') }}</textarea>
                                    @error('feedback')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <small class="form-text text-muted">Maksimal 1000 karakter</small>
                                </div>

                                <div class="form-group">
                                    <button type="submit" class="btn btn-success">
                                        <i class="fas fa-save"></i> Simpan Validasi
                                    </button>
                                    <a href="{{ route('pengawas.validasi.index') }}" class="btn btn-secondary">
                                        <i class="fas fa-times"></i> Batal
                                    </a>
                                </div>
                            </form>
                        </div>
                    </div>
                    @else
                    <!-- Status Validasi Sudah Ada -->
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">
                                <i class="fas fa-info-circle"></i> Status Validasi
                            </h4>
                        </div>
                        <div class="card-body">
                            <div class="alert alert-info">
                                <h5>
                                    @if($penilaianGuru->validasiPengawas->status === 'approved')
                                        <i class="fas fa-check-circle text-success"></i> Penilaian Telah Disetujui
                                    @else
                                        <i class="fas fa-edit text-warning"></i> Penilaian Perlu Revisi
                                    @endif
                                </h5>
                                <p class="mb-2">
                                    <strong>Tanggal Validasi:</strong> {{ $penilaianGuru->validasiPengawas->tanggal_validasi->format('d F Y, H:i') }}
                                </p>
                                @if($penilaianGuru->validasiPengawas->feedback)
                                    <p class="mb-0">
                                        <strong>Feedback:</strong><br>
                                        {{ $penilaianGuru->validasiPengawas->feedback }}
                                    </p>
                                @endif
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Auto-hide alerts after 5 seconds
    setTimeout(function() {
        $('.alert-success, .alert-danger').fadeOut('slow');
    }, 5000);

    // Form validation
    $('form').on('submit', function(e) {
        let isValid = true;
        
        // Check required fields
        $('select[required], textarea[required]').each(function() {
            if (!$(this).val()) {
                $(this).addClass('is-invalid');
                isValid = false;
            } else {
                $(this).removeClass('is-invalid');
            }
        });
        
        if (!isValid) {
            e.preventDefault();
            alert('Mohon lengkapi semua field yang wajib diisi.');
        }
    });
});
</script>
@endpush
