@extends('layouts.app')

@section('title', 'Validasi Penilaian')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
<div class="card">
    <div class="card-header">
        <h3 class="card-title">
                        <i class="fas fa-check-circle"></i> Validasi Penilaian Kepala
        </h3>
                    <div class="card-tools">
                        <a href="{{ route('pengawas.dashboard') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Kembali ke Dashboard
                        </a>
                    </div>
    </div>
    <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            {{ session('success') }}
                        </div>
                    @endif

                    @if(session('error'))
                        <div class="alert alert-danger alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            {{ session('error') }}
                        </div>
                    @endif

                    <!-- Statistics Cards -->
                    <div class="row mb-4">
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-warning">
                                <div class="inner">
                                    <h3>{{ $stats['total_pending'] }}</h3>
                                    <p>Menunggu Validasi</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-clock"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-success">
                                <div class="inner">
                                    <h3>{{ $stats['approved'] }}</h3>
                                    <p>Disetujui</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-check-circle"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-info">
                                <div class="inner">
                                    <h3>{{ $stats['revision'] }}</h3>
                                    <p>Perlu Revisi</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-edit"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-primary">
                                <div class="inner">
                                    <h3>{{ $stats['total_validated'] }}</h3>
                                    <p>Total Divalidasi</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-clipboard-check"></i>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Penilaian Table -->
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th width="5%">No</th>
                                    <th>Nama Kepala</th>
                                    <th>Lembaga</th>
                                    <th>Instrumen</th>
                                    <th>Tanggal Submit</th>
                                    <th>Nilai Rata-rata</th>
                                    <th>Status Validasi</th>
                                    <th width="15%">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($penilaianGuru as $penilaian)
                                <tr>
                                    <td>{{ $loop->iteration + ($penilaianGuru->currentPage() - 1) * $penilaianGuru->perPage() }}</td>
                                    <td>
                                        <strong>{{ $penilaian->kepala?->name }}</strong>
                                    </td>
                                    <td>
                                        <strong>{{ $penilaian->distribusiInstrumen?->lembaga?->nama_lembaga }}</strong>
                                    </td>
                                    <td>
                                        <strong>{{ $penilaian->distribusiInstrumen->instrumen->judul }}</strong>
                                        <br><small class="text-muted">{{ $penilaian->distribusiInstrumen->instrumen->tahun_ajaran }} - Semester {{ $penilaian->distribusiInstrumen->instrumen->semester }}</small>
                                        @if($penilaian->distribusiInstrumen->komponen)
                                            <br><span class="badge badge-info">{{ $penilaian->distribusiInstrumen->komponen->nama_komponen }}</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($penilaian->tanggal_submit)
                                            {{ $penilaian->tanggal_submit->format('d/m/Y H:i') }}
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($penilaian->rata_rata)
                                            <strong class="text-success">{{ number_format($penilaian->rata_rata, 2) }}</strong>
                                            <br><small class="text-muted">Total: {{ $penilaian->total_nilai }}</small>
                                        @else
                                            <span class="text-muted">Belum dinilai</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($penilaian->validasiPengawas && $penilaian->validasiPengawas->status)
                                            @if($penilaian->validasiPengawas->status === 'approved')
                                                <span class="badge badge-success">
                                                    <i class="fas fa-check-circle"></i> Disetujui
                                                </span>
                                                <br><small class="text-muted">{{ $penilaian->validasiPengawas->tanggal_validasi ? $penilaian->validasiPengawas->tanggal_validasi->format('d/m/Y') : '-' }}</small>
                                            @else
                                                <span class="badge badge-warning">
                                                    <i class="fas fa-edit"></i> Perlu Revisi
                                                </span>
                                                <br><small class="text-muted">{{ $penilaian->validasiPengawas->tanggal_validasi ? $penilaian->validasiPengawas->tanggal_validasi->format('d/m/Y') : '-' }}</small>
                                            @endif
                                        @else
                                            <span class="badge badge-info">
                                                <i class="fas fa-clock"></i> Menunggu Validasi
                                            </span>
                                        @endif
                                    </td>
                                    <td>
                                        <a href="{{ route('pengawas.validasi.show', $penilaian->id) }}" class="btn btn-primary btn-sm" title="Validasi Penilaian">
                                            <i class="fas fa-eye"></i> Validasi
                                        </a>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="8" class="text-center">
                                        <div class="py-4">
                                            <i class="fas fa-check-circle fa-3x text-muted mb-3"></i>
                                            <h5 class="text-muted">Tidak ada penilaian yang perlu divalidasi</h5>
                                            <p class="text-muted">Semua penilaian dari kepala sekolah sudah divalidasi.</p>
                                        </div>
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    @if($penilaianGuru->hasPages())
                    <div class="d-flex justify-content-center">
                        {{ $penilaianGuru->links() }}
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Auto-hide alerts after 5 seconds
    setTimeout(function() {
        $('.alert').fadeOut('slow');
    }, 5000);
});
</script>
@endpush