@extends('layouts.app')

@section('title', 'Detail Sub Komponen')

@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{ route('pengawas.instrumen.index') }}">Instrumen</a></li>
<li class="breadcrumb-item"><a href="{{ route('pengawas.items.index', $instrumen) }}">Komponen</a></li>
<li class="breadcrumb-item"><a href="{{ route('pengawas.items.sub-komponen', [$instrumen, $item]) }}">Sub Komponen</a></li>
<li class="breadcrumb-item active">Detail: {{ $subKomponen->nama_sub_komponen }}</li>
@endsection

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            <i class="fas fa-layer-group"></i> Detail Sub Komponen
        </h3>
        <div class="card-tools">
            <span class="text-muted">
                <i class="fas fa-info-circle"></i> Hanya bisa melihat detail sub komponen
            </span>
            <a href="{{ route('pengawas.items.sub-komponen', [$instrumen, $item]) }}" class="btn btn-secondary btn-sm">
                <i class="fas fa-arrow-left"></i> Kembali
            </a>
        </div>
    </div>
    <div class="card-body">
        <!-- Komponen Info -->
        <div class="alert alert-info">
            <h5><i class="fas fa-cogs"></i> {{ $item->nama_komponen }}</h5>
            <p class="mb-0">{{ $item->deskripsi }}</p>
            <small>Instrumen: {{ $instrumen->judul }} - Urutan: {{ $item->urutan }}</small>
        </div>

        <!-- Sub Komponen Info -->
        <div class="alert alert-success">
            <h5><i class="fas fa-layer-group"></i> {{ $subKomponen->nama_sub_komponen }}</h5>
            <p class="mb-0">{{ $subKomponen->deskripsi }}</p>
            <small>Urutan: {{ $subKomponen->urutan }}</small>
        </div>

        <!-- Info Pembagian Peran -->
        <div class="alert alert-light">
            <h6><i class="fas fa-users"></i> Pembagian Peran dalam Penilaian:</h6>
            <div class="row">
                <div class="col-md-4">
                    <small class="text-muted">
                        <i class="fas fa-user-tie text-primary"></i> <strong>Admin:</strong> Membuat struktur instrumen
                    </small>
                </div>
                <div class="col-md-4">
                    <small class="text-muted">
                        <i class="fas fa-chalkboard-teacher text-success"></i> <strong>Guru:</strong> Mengisi Bukti URL
                    </small>
                </div>
                <div class="col-md-4">
                    <small class="text-muted">
                        <i class="fas fa-user-shield text-warning"></i> <strong>Kepala:</strong> Mengisi Catatan Verifikasi
                    </small>
                </div>
            </div>
        </div>

        <div class="table-responsive">
            <table class="table table-striped table-hover">
                <thead class="thead-dark">
                    <tr>
                        <th width="5%">No</th>
                        <th width="35%">Indikator Kinerja</th>
                        <th width="25%">Evidensi Kinerja</th>
                        <th width="8%">Skor</th>
                        <th width="10%">Bukti URL <small class="text-muted">(Guru)</small></th>
                        <th width="15%">Catatan <small class="text-muted">(Kepala)</small></th>
                        <th width="8%">Status</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($subKomponen->instrumenPenilaians as $index => $instrumen)
                    <tr>
                        <td>{{ $instrumen->no_urutan }}</td>
                        <td>
                            <div class="text-justify">
                                {{ $instrumen->indikator_kinerja }}
                            </div>
                        </td>
                        <td>
                            <div class="text-muted text-justify">
                                {{ $instrumen->evidensi_kinerja ? Str::limit($instrumen->evidensi_kinerja, 100) : '-' }}
                            </div>
                        </td>
                        <td>
                            <span class="badge badge-primary">{{ $instrumen->skor_min }} - {{ $instrumen->skor_max }}</span>
                        </td>
                        <td>
                            @if($instrumen->bukti_url)
                                <a href="{{ $instrumen->bukti_url }}" target="_blank" class="btn btn-sm btn-outline-info">
                                    <i class="fas fa-external-link-alt"></i> Lihat
                                </a>
                            @else
                                <span class="text-muted">-</span>
                            @endif
                        </td>
                        <td>
                            <div class="text-muted text-justify">
                                {{ $instrumen->catatan_verifikasi ? Str::limit($instrumen->catatan_verifikasi, 80) : '-' }}
                            </div>
                        </td>
                        <td>
                            <span class="badge badge-{{ $instrumen->is_active ? 'success' : 'danger' }}">
                                {{ $instrumen->is_active ? 'Aktif' : 'Nonaktif' }}
                            </span>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="7" class="text-center">
                            <div class="py-4">
                                <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                                <p class="text-muted">Belum ada instrumen penilaian</p>
                                <small class="text-muted">Instrumen penilaian akan dibuat oleh admin</small>
                            </div>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
