@extends('layouts.app')

@section('title', 'Sub Komponen Penilaian')

@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{ route('pengawas.instrumen.index') }}">Instrumen</a></li>
<li class="breadcrumb-item"><a href="{{ route('pengawas.items.index', $instrumen) }}">Komponen</a></li>
<li class="breadcrumb-item active">Sub Komponen: {{ $item->nama_komponen }}</li>
@endsection

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            <i class="fas fa-layer-group"></i> Sub Komponen Penilaian
        </h3>
        <div class="card-tools">
            <span class="text-muted">
                <i class="fas fa-info-circle"></i> Hanya bisa melihat sub komponen penilaian
            </span>
            <a href="{{ route('pengawas.items.index', $instrumen) }}" class="btn btn-secondary btn-sm">
                <i class="fas fa-arrow-left"></i> Kembali
            </a>
        </div>
    </div>
    <div class="card-body">
        <!-- Komponen Info -->
        <div class="alert alert-info">
            <h5><i class="fas fa-cogs"></i> {{ $item->nama_komponen }}</h5>
            <p class="mb-0">{{ $item->deskripsi }}</p>
            <small>Instrumen: {{ $instrumen->judul }} - Urutan: {{ $item->urutan }}</small>
        </div>

        @if (session('status'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('status') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        <!-- Info Box -->
        <div class="row mb-3">
            <div class="col-md-6">
                <div class="info-box bg-success">
                    <span class="info-box-icon"><i class="fas fa-layer-group"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Total Sub Komponen</span>
                        <span class="info-box-number">{{ $subKomponens->count() }}</span>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="info-box bg-warning">
                    <span class="info-box-icon"><i class="fas fa-list-alt"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Total Instrumen Penilaian</span>
                        <span class="info-box-number">{{ $subKomponens->sum(function($subKomponen) { return $subKomponen->instrumenPenilaians->count(); }) }}</span>
                    </div>
                </div>
            </div>
        </div>

        <div class="table-responsive">
            <table class="table table-striped table-hover">
                <thead class="thead-dark">
                    <tr>
                        <th width="5%">No</th>
                        <th width="30%">Nama Sub Komponen</th>
                        <th width="35%">Deskripsi</th>
                        <th width="15%">Instrumen</th>
                        <th width="8%">Status</th>
                        <th width="17%">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($subKomponens as $index => $subKomponen)
                    <tr>
                        <td>{{ $index + 1 }}</td>
                        <td>
                            <div>
                                <strong>{{ $subKomponen->nama_sub_komponen }}</strong>
                                <br><small class="text-muted">Urutan: {{ $subKomponen->urutan }}</small>
                            </div>
                        </td>
                        <td>
                            <div class="text-muted">
                                {{ $subKomponen->deskripsi ? Str::limit($subKomponen->deskripsi, 100) : '-' }}
                            </div>
                        </td>
                        <td>
                            <span class="badge badge-warning">{{ $subKomponen->instrumenPenilaians()->count() }} Item</span>
                        </td>
                        <td>
                            <span class="badge badge-{{ $subKomponen->is_active ? 'success' : 'danger' }}">
                                {{ $subKomponen->is_active ? 'Aktif' : 'Nonaktif' }}
                            </span>
                        </td>
                        <td>
                            <div class="btn-group" role="group">
                                <a href="{{ route('pengawas.items.sub-komponen.show', [$instrumen, $item, $subKomponen]) }}" class="btn btn-info btn-sm" title="Lihat Detail Instrumen">
                                    <i class="fas fa-list-alt"></i>
                                </a>
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="6" class="text-center">
                            <div class="py-4">
                                <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                                <p class="text-muted">Belum ada sub komponen penilaian</p>
                                <small class="text-muted">Sub komponen penilaian akan dibuat oleh admin</small>
                            </div>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
