@extends('layouts.app')

@section('title', 'Penilaian Kepala')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title"><i class="fas fa-star"></i> Penilaian Kepala: {{ $penilaian->kepala?->name ?? '-' }}</h3>
                    <div>
                        @if(in_array($penilaian->status, ['validated', 'final']))
                        <a href="{{ route('pengawas.penilaian.raport', $penilaian->id) }}" class="btn btn-success btn-sm" target="_blank" title="Download Raport PDF">
                            <i class="fas fa-file-pdf"></i>
                        </a>
                        <form method="POST" action="{{ route('pengawas.penilaian.kirim-raport-kepala', $penilaian->id) }}" style="display: inline;" onsubmit="return confirm('Apakah Anda yakin ingin mengirim raport ke kepala sekolah? Kepala akan menerima notifikasi.');">
                            @csrf
                            <button type="submit" class="btn btn-info btn-sm" title="Kirim Raport ke Kepala">
                                <i class="fas fa-paper-plane"></i>
                            </button>
                        </form>
                        @endif
                        <a href="{{ route('pengawas.penilaian.index') }}" class="btn btn-secondary btn-sm" title="Kembali ke Daftar Penilaian"><i class="fas fa-arrow-left"></i></a>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible"><button type="button" class="close" data-dismiss="alert">&times;</button>{{ session('success') }}</div>
                    @endif
                    @if(session('error'))
                        <div class="alert alert-danger alert-dismissible"><button type="button" class="close" data-dismiss="alert">&times;</button>{{ session('error') }}</div>
                    @endif

                    <div class="mb-3 d-flex justify-content-between align-items-center">
                        <div>
                            <strong>Instrumen:</strong> {{ $distribusi->instrumen->judul }}<br>
                            <small class="text-muted">Tahun {{ $distribusi->instrumen->tahun_ajaran }} - Semester {{ $distribusi->instrumen->semester }}</small>
                        </div>
                        <div>
                            <span class="badge badge-{{ $penilaian->status == 'draft' ? 'secondary' : ($penilaian->status == 'submitted' ? 'warning' : 'success') }}">Status: {{ ucfirst($penilaian->status) }}</span>
                            @if($penilaian->status == 'draft')
                                <div class="mt-2">
                                    <small class="text-muted">
                                        <i class="fas fa-tasks"></i> Progress: {{ $terisi }}/{{ $totalItems }} item dinilai
                                    </small>
                                    @if($isComplete)
                                        <span class="badge badge-success ml-2"><i class="fas fa-check"></i> Siap Finalisasi</span>
                                    @else
                                        <span class="badge badge-warning ml-2"><i class="fas fa-exclamation-triangle"></i> Belum Lengkap</span>
                                    @endif
                                </div>
                            @endif
                        </div>
                    </div>

                    @if(session('error'))
                        <div class="alert alert-danger alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            {{ session('error') }}
                        </div>
                    @endif

                    <form method="POST" action="{{ route('pengawas.penilaian.update', $penilaian->id) }}">
                        @csrf
                        @method('PUT')

                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <thead class="thead-light">
                                    <tr>
                                        <th width="6%">No</th>
                                        <th>Indikator</th>
                                        <th width="12%">Nilai Kepala</th>
                                        <th width="18%">Bukti (URL)</th>
                                        <th width="20%">Catatan Kepala</th>
                                        <th width="12%">Nilai Pengawas</th>
                                        <th width="20%">Catatan Pengawas</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($items as $idx => $item)
                                        @php 
                                            $j = $jawabanMap[$item->id] ?? null;
                                            $formKey = $j->id ?? 'new_' . $item->id;
                                        @endphp
                                        <tr data-item-id="{{ $item->id }}" data-jawaban-id="{{ $j->id ?? null }}" data-form-key="{{ $formKey }}">
                                            <td class="text-center">{{ ($items->currentPage() - 1) * $items->perPage() + $idx + 1 }}</td>
                                            <td>
                                                <div class="font-weight-bold">{{ $item->indikator_kinerja }}</div>
                                                @if($item->evidensi_kinerja)
                                                    <small class="text-muted">{{ $item->evidensi_kinerja }}</small>
                                                @endif
                                                @if($j)
                                                    <small class="text-muted d-block mt-1">(Item ID: {{ $item->id }}, Jawaban ID: {{ $j->id }})</small>
                                                @else
                                                    <small class="text-warning d-block mt-1">(Item ID: {{ $item->id }}, Jawaban ID: NULL - akan dibuat saat save)</small>
                                                @endif
                                            </td>
                                            <td class="text-center">{{ $j->nilai_guru_self ?? '-' }}</td>
                                            <td>
                                                @if(!empty($j->url_bukti))
                                                    <a href="{{ $j->url_bukti }}" target="_blank">{{ $j->url_bukti }}</a>
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                            <td>{{ $j->keterangan_bukti ?? '-' }}</td>
                                            <td>
                                                <input type="hidden" name="nilai[{{ $formKey }}][instrumen_item_id]" value="{{ $item->id }}">
                                                <input type="number" name="nilai[{{ $formKey }}][nilai_pengawas]" class="form-control nilai-pengawas-input" min="1" max="5" value="{{ old('nilai.'.$formKey.'.nilai_pengawas', $j->nilai_pengawas ?? '') }}" data-item-id="{{ $item->id }}" data-jawaban-id="{{ $j->id ?? null }}">
                                            </td>
                                            <td>
                                                <textarea name="nilai[{{ $formKey }}][catatan_pengawas]" class="form-control" rows="2">{{ old('nilai.'.$formKey.'.catatan_pengawas', $j->catatan_pengawas ?? '') }}</textarea>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        @if($items->hasPages())
                        <div class="mt-3">
                            {{ $items->links('pagination::bootstrap-4') }}
                        </div>
                        @endif

                        <div class="card mt-3">
                            <div class="card-header"><h3 class="card-title"><i class="fas fa-comment-dots"></i> Review Umum</h3></div>
                            <div class="card-body">
                                <div class="form-group">
                                    <label>Catatan Pengawas (umum)</label>
                                    <textarea name="catatan_pengawas" class="form-control" rows="4" {{ in_array($penilaian->status, ['validated', 'final']) ? 'readonly' : '' }}>{{ old('catatan_pengawas', $penilaian->catatan_pengawas) }}</textarea>
                                    @if(!in_array($penilaian->status, ['validated', 'final']))
                                    <div class="form-check mt-2">
                                        <input type="checkbox" class="form-check-input" id="genAI" name="generate_ai" value="1">
                                        <label class="form-check-label" for="genAI">Preview: Gunakan analisa AI untuk menghasilkan ringkasan (untuk preview sebelum finalisasi)</label>
                                    </div>
                                    <small class="text-info"><i class="fas fa-info-circle"></i> <strong>Catatan:</strong> Analisis AI lengkap akan <strong>otomatis di-generate saat finalisasi</strong> (status Validated/Final). Proses ini memakan waktu 10-30 detik. Centang checkbox ini hanya untuk preview sebelum finalisasi.</small>
                                    @endif
                                </div>
                                @if(in_array($penilaian->status, ['validated', 'final']))
                                <div class="alert alert-info">
                                    <i class="fas fa-info-circle"></i> Penilaian sudah difinalisasi. Catatan dan nilai tidak dapat diubah lagi.
                                    <div class="mt-2">
                                        <form method="POST" action="{{ route('pengawas.penilaian.ubah-status', $penilaian->id) }}" style="display: inline;" onsubmit="return confirm('Apakah Anda yakin ingin mengubah status penilaian menjadi draft? Penilaian ini akan dapat diedit kembali.');">
                                            @csrf
                                            <input type="hidden" name="status" value="draft">
                                            <button type="submit" class="btn btn-warning btn-sm">
                                                <i class="fas fa-undo"></i> Ubah Status ke Draft
                                            </button>
                                        </form>
                                    </div>
                                </div>
                                @endif
                                
                                @if(!in_array($penilaian->status, ['validated', 'final']))
                                <div class="form-group">
                                    <label>Status Finalisasi <span class="text-danger" id="statusRequired">*</span></label>
                                    <select name="final_status" id="final_status" class="form-control">
                                        <option value="">-- Pilih Status Finalisasi --</option>
                                        <option value="validated" {{ old('final_status') == 'validated' ? 'selected' : '' }}>Validated</option>
                                        <option value="final" {{ old('final_status') == 'final' ? 'selected' : '' }}>Final</option>
                                    </select>
                                    <small class="text-muted">Pilih status saat melakukan finalisasi penilaian (wajib dipilih sebelum finalisasi, tidak wajib untuk simpan draft)</small>
                                </div>
                                @endif
                                
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        @if(!in_array($penilaian->status, ['validated', 'final']))
                                        <button type="submit" name="action" value="save" class="btn btn-secondary">
                                            <i class="fas fa-save"></i> Simpan Draft
                                        </button>
                                        @endif
                                    </div>
                                    <div>
                                        @if(!in_array($penilaian->status, ['validated', 'final']))
                                        <button type="submit" name="action" value="finalize" id="btnFinalize" class="btn btn-primary" {{ !$isComplete ? 'disabled' : '' }} onclick="return validateFinalize();">
                                            <i class="fas fa-check-circle"></i> Finalisasi Penilaian
                                        </button>
                                        @if(!$isComplete)
                                        <small class="d-block text-danger mt-1">
                                            Semua item harus dinilai sebelum finalisasi ({{ $terisi }}/{{ $totalItems }} sudah dinilai)
                                            <br>
                                            <button type="button" class="btn btn-sm btn-info mt-1" onclick="checkMissingItems()">
                                                <i class="fas fa-search"></i> Cek Item yang Belum Dinilai
                                            </button>
                                        </small>
                                        @endif
                                        @else
                                        <span class="badge badge-success"><i class="fas fa-check"></i> Penilaian Sudah Difinalisasi</span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
function validateFinalize() {
    // Validasi semua item sudah dinilai
    var isComplete = {{ $isComplete ? 'true' : 'false' }};
    var terisi = {{ $terisi }};
    var totalItems = {{ $totalItems }};
    
    if (!isComplete) {
        alert('Semua item harus dinilai sebelum finalisasi (' + terisi + '/' + totalItems + ' sudah dinilai).');
        return false;
    }
    
    // Validasi status sudah dipilih
    var finalStatus = document.getElementById('final_status');
    
    if (!finalStatus) {
        alert('Error: Element Status Finalisasi tidak ditemukan.');
        return false;
    }
    
    if (!finalStatus.value || finalStatus.value === '') {
        alert('Silakan pilih Status Finalisasi terlebih dahulu (Validated atau Final) sebelum melakukan finalisasi.');
        finalStatus.focus();
        return false;
    }
    
    // Konfirmasi finalisasi
    var statusText = finalStatus.options[finalStatus.selectedIndex].text;
    
    var confirmed = confirm('Apakah Anda yakin ingin memfinalisasi penilaian ini dengan status "' + statusText + '"? Setelah finalisasi, data tidak dapat diubah lagi.');
    
    return confirmed;
}

// Disable/enable tombol finalisasi berdasarkan status dropdown
document.addEventListener('DOMContentLoaded', function() {
    var finalStatus = document.getElementById('final_status');
    var btnFinalize = document.getElementById('btnFinalize');
    var isComplete = {{ $isComplete ? 'true' : 'false' }};
    
    if (finalStatus && btnFinalize) {
        // Update tombol saat status berubah
        finalStatus.addEventListener('change', function() {
            if (this.value && isComplete) {
                btnFinalize.disabled = false;
            } else if (!this.value) {
                btnFinalize.disabled = true;
            } else if (!isComplete) {
                btnFinalize.disabled = true;
            }
        });
        
        // Set initial state
        var shouldDisable = !finalStatus.value || !isComplete;
        
        if (shouldDisable) {
            btnFinalize.disabled = true;
        } else {
            btnFinalize.disabled = false;
        }
        
        // Handle form submission - remove required untuk save draft
        var form = document.querySelector('form[method="POST"]');
        if (form) {
            // Handle untuk tombol Simpan Draft - hapus required
            var btnSave = document.querySelector('button[name="action"][value="save"]');
            if (btnSave) {
                btnSave.addEventListener('click', function(e) {
                    // Remove required attribute untuk save draft
                    if (finalStatus) {
                        finalStatus.removeAttribute('required');
                    }
                });
            }
            
            // Handle untuk tombol Finalisasi - tambahkan required
            if (btnFinalize) {
                btnFinalize.addEventListener('click', function(e) {
                    // Add required attribute untuk finalisasi
                    if (finalStatus) {
                        finalStatus.setAttribute('required', 'required');
                    }
                });
            }
        }
    }
});

// Function untuk cek item yang belum dinilai
function checkMissingItems() {
    // Cek dari AJAX ke server (lebih akurat karena cek semua data, bukan hanya halaman saat ini)
    fetch('{{ route("pengawas.penilaian.debug", $penilaian->id) }}')
        .then(response => response.json())
        .then(data => {
            
            var message = '=== RINGKASAN STATUS PENILAIAN ===\n\n';
            message += 'Total Item: ' + data.total_items + '\n';
            message += 'Sudah Dinilai: ' + data.terisi + '\n';
            message += 'Belum Dinilai: ' + (data.total_items - data.terisi) + '\n\n';
            
            var hasMissing = false;
            
            // Item yang belum punya record
            if (data.missing_records && data.missing_records.length > 0) {
                hasMissing = true;
                message += '⚠️ Item yang BELUM PUNYA RECORD di database:\n';
                message += '   ' + data.missing_records.join(', ') + '\n\n';
                message += '📌 SOLUSI: Klik "Simpan Draft" di semua halaman pagination untuk membuat record.\n\n';
            }
            
            // Item yang punya record tapi belum dinilai
            if (data.missing_nilai && data.missing_nilai.length > 0) {
                hasMissing = true;
                message += '⚠️ Item yang BELUM DINILAI (sudah punya record tapi nilai kosong/null):\n\n';
                
                // Group by page number
                var itemsByPage = {};
                data.missing_nilai.forEach(function(item) {
                    var page = item.page_number || 'unknown';
                    if (!itemsByPage[page]) {
                        itemsByPage[page] = [];
                    }
                    itemsByPage[page].push(item);
                });
                
                // Display grouped by page
                Object.keys(itemsByPage).sort().forEach(function(page) {
                    if (page !== 'unknown') {
                        message += '📄 Halaman ' + page + ':\n';
                        itemsByPage[page].forEach(function(item) {
                            // Tampilkan Item ID dengan jelas (ini yang paling penting)
                            var itemInfo = '   • Item ID: ' + item.item_id;
                            if (item.position) {
                                // Hitung nomor urut di halaman (1-10 untuk halaman 1, 11-20 untuk halaman 2, dst)
                                var itemNumberInPage = item.position - ((parseInt(page) - 1) * 10);
                                itemInfo += ' (Posisi #' + item.position + ' dari total, muncul sebagai Item #' + itemNumberInPage + ' di Halaman ' + page + ')';
                            }
                            if (item.no_urutan) itemInfo += ' [No Urut DB: ' + item.no_urutan + ' - PERHATIAN: No Urut DB bisa duplikat!]';
                            if (item.indikator_kinerja) {
                                var indikator = item.indikator_kinerja.length > 80 
                                    ? item.indikator_kinerja.substring(0, 80) + '...' 
                                    : item.indikator_kinerja;
                                itemInfo += '\n     "' + indikator + '"';
                            }
                            itemInfo += '\n     Jawaban ID: ' + item.jawaban_id + ', Nilai Pengawas: ' + (item.nilai_pengawas || 'KOSONG/NULL') + '\n';
                            message += itemInfo;
                        });
                        message += '\n';
                    } else {
                        itemsByPage[page].forEach(function(item) {
                            var itemInfo = '   • Item ID: ' + item.item_id;
                            if (item.indikator_kinerja) {
                                var indikator = item.indikator_kinerja.length > 80 
                                    ? item.indikator_kinerja.substring(0, 80) + '...' 
                                    : item.indikator_kinerja;
                                itemInfo += '\n     "' + indikator + '"';
                            }
                            itemInfo += '\n     Jawaban ID: ' + item.jawaban_id + ', Nilai: ' + (item.nilai_pengawas || 'KOSONG');
                            message += itemInfo + '\n';
                        });
                    }
                });
                
                message += '\n📌 SOLUSI:\n';
                if (itemsByPage['1']) {
                    message += '   → Buka halaman 1 dan isi nilai untuk item-item tersebut\n';
                }
                if (itemsByPage['2']) {
                    message += '   → Buka halaman 2 dan isi nilai untuk item-item tersebut\n';
                }
                if (itemsByPage['3']) {
                    message += '   → Buka halaman 3 dan isi nilai untuk item-item tersebut\n';
                }
                var otherPages = Object.keys(itemsByPage).filter(function(p) {
                    return p !== 'unknown' && !['1', '2', '3'].includes(p);
                });
                if (otherPages.length > 0) {
                    message += '   → Buka halaman ' + otherPages.join(', ') + ' dan isi nilai\n';
                }
                message += '   → Setelah isi nilai, klik "Simpan Draft" di halaman tersebut\n';
                message += '   → Pastikan semua halaman pagination sudah disimpan\n\n';
                
                // Tambahkan link cepat ke halaman dengan Item ID yang jelas
                var uniquePages = Object.keys(itemsByPage).filter(function(p) { return p !== 'unknown'; }).sort();
                if (uniquePages.length > 0) {
                    message += '🔗 Link cepat ke halaman yang perlu diisi:\n';
                    uniquePages.forEach(function(page) {
                        var url = window.location.pathname + '?page=' + page;
                        message += '   • Halaman ' + page + ': ' + url + '\n';
                    });
                    message += '\n';
                }
            }
            
            // Item yang sudah dinilai (untuk info)
            if (data.all_jawaban && data.all_jawaban.length > 0) {
                var filled = data.all_jawaban.filter(function(j) {
                    return j.nilai_pengawas && j.nilai_pengawas > 0;
                });
                message += '✓ Item yang sudah dinilai: ' + filled.length + ' item\n';
            }
            
            if (!hasMissing && data.terisi >= data.total_items) {
                message += '✅ SEMUA ITEM SUDAH DINILAI!\n';
                message += 'Anda bisa melakukan finalisasi sekarang.\n';
            } else if (data.terisi < data.total_items) {
                message += '\n❌ MASIH ADA ' + (data.total_items - data.terisi) + ' ITEM YANG BELUM DINILAI!\n';
            }
            
            alert(message);
        })
        .catch(error => {
            alert('Error: Gagal mengambil data dari server.');
        });
}
</script>
@endpush


