@extends('layouts.app')

@section('content')
<div class="container mx-auto px-4 py-6">
    <div class="flex items-center justify-between mb-4">
        <h1 class="text-xl font-semibold">Daftar Penilaian Kepala</h1>
    </div>

    @if(session('success'))
        <div class="alert alert-success mb-4">{{ session('success') }}</div>
    @endif
    @if(session('error'))
        <div class="alert alert-danger mb-4">{{ session('error') }}</div>
    @endif

    <!-- Filter Section -->
    <div class="card mb-4">
        <div class="card-body">
            <form method="GET" action="{{ route('pengawas.penilaian.index') }}" class="row g-3">
                <div class="col-md-4">
                    <label for="status" class="form-label">Status</label>
                    <select name="status" id="status" class="form-select">
                        <option value="">Semua Status</option>
                        <option value="draft" {{ $filters['status'] == 'draft' ? 'selected' : '' }}>Draft</option>
                        <option value="submitted" {{ $filters['status'] == 'submitted' ? 'selected' : '' }}>Submitted</option>
                        <option value="revision" {{ $filters['status'] == 'revision' ? 'selected' : '' }}>Revision</option>
                        <option value="validated" {{ $filters['status'] == 'validated' ? 'selected' : '' }}>Validated</option>
                        <option value="final" {{ $filters['status'] == 'final' ? 'selected' : '' }}>Final</option>
                    </select>
                </div>
                <div class="col-md-4">
                    <label for="lembaga_id" class="form-label">Lembaga</label>
                    <select name="lembaga_id" id="lembaga_id" class="form-select">
                        <option value="">Semua Lembaga</option>
                        @foreach($lembagaList as $lembaga)
                            <option value="{{ $lembaga->id }}" {{ $filters['lembaga_id'] == $lembaga->id ? 'selected' : '' }}>
                                {{ $lembaga->nama_lembaga }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-4 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary me-2">
                        <i class="fas fa-filter"></i> Filter
                    </button>
                    <a href="{{ route('pengawas.penilaian.index') }}" class="btn btn-secondary">
                        <i class="fas fa-times"></i> Reset
                    </a>
                </div>
            </form>
        </div>
    </div>

    <div class="card">
        <div class="card-body p-0">
            <div class="overflow-x-auto">
                <table class="table w-full">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Kepala</th>
                            <th>Lembaga</th>
                            <th>Status</th>
                            <th>Tanggal Submit</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($items as $item)
                            <tr>
                                <td>{{ ($items->currentPage() - 1) * $items->perPage() + $loop->iteration }}</td>
                                <td>{{ $item->kepala?->name ?? '-' }}</td>
                                <td>{{ $item->distribusiInstrumen?->lembaga?->nama_lembaga ?? '-' }}</td>
                                <td>{{ ucfirst($item->status) }}</td>
                                <td>{{ optional($item->tanggal_submit)->format('d/m/Y H:i') ?? '-' }}</td>
                                <td>
                                    <div class="btn-group" role="group">
                                        <a href="{{ route('pengawas.penilaian.show', $item->id) }}" class="btn btn-sm btn-primary" title="Review/Isi Penilaian">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        @if(in_array($item->status, ['validated', 'final']))
                                        <a href="{{ route('pengawas.penilaian.raport', $item->id) }}" class="btn btn-sm btn-success" target="_blank" title="Download Raport PDF">
                                            <i class="fas fa-file-pdf"></i>
                                        </a>
                                        <form method="POST" action="{{ route('pengawas.penilaian.kirim-raport-kepala', $item->id) }}" style="display: inline;" onsubmit="return confirm('Apakah Anda yakin ingin mengirim raport ke kepala sekolah? Kepala akan menerima notifikasi.');">
                                            @csrf
                                            <button type="submit" class="btn btn-sm btn-info" title="Kirim Raport ke Kepala">
                                                <i class="fas fa-paper-plane"></i>
                                            </button>
                                        </form>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="text-center py-6">Belum ada penilaian.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    @if($items->hasPages())
    <div class="d-flex justify-content-center mt-3">
        {{ $items->appends(request()->query())->links('pagination::bootstrap-4-custom') }}
    </div>
    @endif
</div>
@endsection


