@extends('layouts.app')

@section('title', 'Detail Lembaga')

@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{ route('pengawas.lembaga.index') }}">Lembaga</a></li>
<li class="breadcrumb-item active">Detail</li>
@endsection

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            <i class="fas fa-school"></i> Detail Lembaga: {{ $lembaga->nama_lembaga }}
        </h3>
        <div class="card-tools">
            <a href="{{ route('pengawas.lembaga.edit', $lembaga) }}" class="btn btn-warning btn-sm">
                <i class="fas fa-edit"></i> Edit
            </a>
            <a href="{{ route('pengawas.lembaga.index') }}" class="btn btn-secondary btn-sm">
                <i class="fas fa-arrow-left"></i> Kembali
            </a>
        </div>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Informasi Umum</h3>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <strong>Nama Lembaga:</strong><br>
                                <span class="text-primary">{{ $lembaga->nama_lembaga }}</span><br><br>
                                
                                <strong>Jenis:</strong><br>
                                <span class="badge badge-{{ $lembaga->jenis == 'RA' ? 'primary' : ($lembaga->jenis == 'MI' ? 'success' : ($lembaga->jenis == 'MTs' ? 'info' : 'warning')) }}">
                                    {{ $lembaga->jenis }}
                                </span><br><br>
                                
                                <strong>NPSN/NSM:</strong><br>
                                <span class="text-info">{{ $lembaga->npsn_nsm }}</span><br><br>
                                
                                <strong>Akreditasi:</strong><br>
                                <span class="text-warning">{{ $lembaga->akreditasi ?? 'Belum terakreditasi' }}</span><br><br>
                                
                                <strong>Tahun Berdiri:</strong><br>
                                <span class="text-success">{{ $lembaga->tahun_berdiri ?? 'Tidak diketahui' }}</span>
                            </div>
                            <div class="col-md-6">
                                <strong>Alamat Lengkap:</strong><br>
                                <span class="text-muted">{{ $lembaga->alamat_lengkap }}</span><br><br>
                                
                                <strong>Kelurahan:</strong> {{ $lembaga->kelurahan_name ?? $lembaga->kelurahan }}<br>
                                <strong>Kecamatan:</strong> {{ $lembaga->kecamatan_name ?? $lembaga->kecamatan }}<br>
                                <strong>Kabupaten:</strong> {{ $lembaga->kabupaten_name ?? $lembaga->kabupaten }}<br>
                                <strong>Provinsi:</strong> {{ $lembaga->provinsi_name ?? $lembaga->provinsi }}<br>
                                <strong>Kode Pos:</strong> {{ $lembaga->kode_pos ?? 'Tidak ada' }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Kontak</h3>
                    </div>
                    <div class="card-body">
                        @if($lembaga->telepon)
                        <div class="info-box bg-success">
                            <span class="info-box-icon"><i class="fas fa-phone"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text">Telepon</span>
                                <span class="info-box-number">{{ $lembaga->telepon }}</span>
                            </div>
                        </div>
                        @endif
                        
                        @if($lembaga->email)
                        <div class="info-box bg-warning">
                            <span class="info-box-icon"><i class="fas fa-envelope"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text">Email</span>
                                <span class="info-box-number">{{ $lembaga->email }}</span>
                            </div>
                        </div>
                        @endif
                        
                        @if($lembaga->website)
                        <div class="info-box bg-danger">
                            <span class="info-box-icon"><i class="fas fa-globe"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text">Website</span>
                                <span class="info-box-number">
                                    <a href="{{ $lembaga->website }}" target="_blank" class="text-white">
                                        {{ $lembaga->website }}
                                    </a>
                                </span>
                            </div>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <div class="row mt-3">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Informasi Kepala Madrasah</h3>
                    </div>
                    <div class="card-body">
                        <div class="text-center">
                            <img src="https://adminlte.io/themes/v3/dist/img/user2-160x160.jpg" class="img-circle elevation-2 mb-3" alt="User Image" style="width: 80px; height: 80px;">
                            <h4>{{ $lembaga->nama_kepala }}</h4>
                            <p class="text-muted">NIP: {{ $lembaga->nip_kepala }}</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Statistik Guru</h3>
                    </div>
                    <div class="card-body">
                        <div class="info-box bg-primary">
                            <span class="info-box-icon"><i class="fas fa-chalkboard-teacher"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text">Total Guru</span>
                                <span class="info-box-number">{{ $lembaga->guru()->count() }}</span>
                            </div>
                        </div>
                        
                        <div class="row text-center mt-3">
                            <div class="col-6">
                                <h4>{{ $lembaga->guru()->where('status_kepegawaian', 'PNS')->count() }}</h4>
                                <small class="text-muted">PNS</small>
                            </div>
                            <div class="col-6">
                                <h4>{{ $lembaga->guru()->where('status_kepegawaian', '!=', 'PNS')->count() }}</h4>
                                <small class="text-muted">Non-PNS</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        @if($lembaga->guru()->count() > 0)
        <div class="card mt-3">
            <div class="card-header">
                <h3 class="card-title">Daftar Guru ({{ $lembaga->guru()->count() }})</h3>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Nama Guru</th>
                                <th>Mata Pelajaran</th>
                                <th>Kelas</th>
                                <th>Status Kepegawaian</th>
                                <th>Status Sertifikasi</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($lembaga->guru()->take(10)->get() as $guru)
                            <tr>
                                <td>{{ $guru->nama_lengkap_with_gelar }}</td>
                                <td>{{ $guru->mata_pelajaran }}</td>
                                <td>{{ $guru->kelas_diampu }}</td>
                                <td><span class="badge badge-info">{{ $guru->status_kepegawaian }}</span></td>
                                <td><span class="badge badge-{{ $guru->status_sertifikasi == 'sudah' ? 'success' : 'warning' }}">{{ ucfirst($guru->status_sertifikasi) }}</span></td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                @if($lembaga->guru()->count() > 10)
                <div class="text-center mt-3">
                    <small class="text-muted">Menampilkan 10 dari {{ $lembaga->guru()->count() }} guru</small>
                </div>
                @endif
            </div>
        </div>
        @endif
    </div>
</div>
@endsection