@extends('layouts.app')

@section('title', 'Lembaga Binaan')

@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{ route('pengawas.lembaga.index') }}">Lembaga</a></li>
<li class="breadcrumb-item active">Daftar</li>
@endsection

@section('content')
<!-- Statistics Cards -->
<div class="row mb-3">
    <div class="col-md-3">
        <div class="info-box">
            <span class="info-box-icon bg-info"><i class="fas fa-school"></i></span>
            <div class="info-box-content">
                <span class="info-box-text">Total Lembaga Binaan</span>
                <span class="info-box-number">{{ $lembaga->total() }}</span>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="info-box">
            <span class="info-box-icon bg-success"><i class="fas fa-user-tie"></i></span>
            <div class="info-box-content">
                <span class="info-box-text">Total Kepala</span>
                <span class="info-box-number">{{ $lembaga->where('kepala_id', '!=', null)->count() }}</span>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="info-box">
            <span class="info-box-icon bg-warning"><i class="fas fa-chalkboard-teacher"></i></span>
            <div class="info-box-content">
                <span class="info-box-text">Total Guru</span>
                <span class="info-box-number">{{ $lembaga->sum(function($item) { return $item->guru()->count(); }) }}</span>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="info-box">
            <span class="info-box-icon bg-primary"><i class="fas fa-chart-pie"></i></span>
            <div class="info-box-content">
                <span class="info-box-text">Jenis Terbanyak</span>
                <span class="info-box-number">
                    @php
                        $jenisCount = $lembaga->groupBy('jenis')->map->count();
                        $mostCommon = $jenisCount->sortDesc()->keys()->first() ?? 'N/A';
                    @endphp
                    {{ $mostCommon }}
                </span>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            <i class="fas fa-school"></i> Lembaga Binaan
        </h3>
        <div class="card-tools">
            <a href="{{ route('pengawas.lembaga.create') }}" class="btn btn-primary btn-sm">
                <i class="fas fa-plus"></i> Tambah Lembaga
            </a>
        </div>
    </div>
    <div class="card-body">
        @if (session('status'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('status') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        @if (session('error'))
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                {{ session('error') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        <!-- Filter Form -->
        <div class="row mb-3">
            <div class="col-md-12">
                <form method="GET" action="{{ route('pengawas.lembaga.index') }}" class="form-inline">
                    <div class="form-group mr-2">
                        <select name="jenis" class="form-control form-control-sm">
                            <option value="">Semua Jenis</option>
                            <option value="RA" {{ request('jenis') == 'RA' ? 'selected' : '' }}>RA (Raudhatul Athfal)</option>
                            <option value="MI" {{ request('jenis') == 'MI' ? 'selected' : '' }}>MI (Madrasah Ibtidaiyah)</option>
                            <option value="MTs" {{ request('jenis') == 'MTs' ? 'selected' : '' }}>MTs (Madrasah Tsanawiyah)</option>
                            <option value="MA" {{ request('jenis') == 'MA' ? 'selected' : '' }}>MA (Madrasah Aliyah)</option>
                        </select>
                    </div>
                    <div class="form-group mr-2">
                        <input type="text" name="search" class="form-control form-control-sm" placeholder="Cari nama lembaga, NPSN/NSM, atau kepala..." value="{{ request('search') }}">
                    </div>
                    <button type="submit" class="btn btn-secondary btn-sm">
                        <i class="fas fa-search"></i> Filter
                    </button>
                    <a href="{{ route('pengawas.lembaga.index') }}" class="btn btn-outline-secondary btn-sm ml-2">
                        <i class="fas fa-times"></i> Reset
                    </a>
                </form>
            </div>
        </div>

        <!-- Info Box -->
        <div class="row mb-3">
            <div class="col-md-12">
                <div class="info-box bg-info">
                    <span class="info-box-icon"><i class="fas fa-school"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Total Lembaga Binaan</span>
                        <span class="info-box-number">{{ $lembaga->count() }}</span>
                    </div>
                </div>
            </div>
        </div>

        <div class="table-responsive">
            <table class="table table-striped table-hover">
                <thead class="thead-dark">
                    <tr>
                        <th width="5%">ID</th>
                        <th width="25%">Nama Lembaga</th>
                        <th width="10%">Jenis</th>
                        <th width="12%">NPSN/NSM</th>
                        <th width="20%">Kepala</th>
                        <th width="10%">Guru</th>
                        <th width="18%">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($lembaga as $item)
                    <tr>
                        <td>{{ $item->id }}</td>
                        <td>
                            <div>
                                <strong>{{ $item->nama_lembaga }}</strong>
                                <br><small class="text-muted">{{ $item->alamat_lengkap }}</small>
                            </div>
                        </td>
                        <td>
                            <span class="badge badge-{{ $item->jenis == 'RA' ? 'primary' : ($item->jenis == 'MI' ? 'success' : ($item->jenis == 'MTs' ? 'info' : 'warning')) }}">
                                {{ $item->jenis }}
                            </span>
                        </td>
                        <td>{{ $item->npsn_nsm }}</td>
                        <td>
                            <div>
                                <strong>{{ $item->nama_kepala }}</strong>
                                @if($item->nip_kepala)
                                    <br><small class="text-muted">NIP: {{ $item->nip_kepala }}</small>
                                @endif
                                @if($item->kepala && $item->kepala->email)
                                    <br><small class="text-info">Email: {{ $item->kepala->email }}</small>
                                @endif
                                @if($item->kepala && !$item->kepala->is_active)
                                    <br><span class="badge badge-danger">Nonaktif</span>
                                @endif
                            </div>
                        </td>
                        <td>
                            <span class="badge badge-warning">{{ $item->guru()->count() }} Guru</span>
                        </td>
                        <td>
                            <div class="btn-group" role="group">
                                <a href="{{ route('pengawas.lembaga.show', $item) }}" class="btn btn-info btn-sm" title="Detail">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="{{ route('pengawas.lembaga.edit', $item) }}" class="btn btn-warning btn-sm" title="Edit">
                                    <i class="fas fa-edit"></i>
                                </a>
                                @if($item->guru()->count() == 0)
                                <form action="{{ route('pengawas.lembaga.destroy', $item) }}" method="POST" class="d-inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-danger btn-sm" title="Lepas dari Binaan" onclick="return confirm('Apakah Anda yakin ingin melepaskan lembaga ini dari binaan? Lembaga akan kembali tersedia untuk pengawas lain.')">
                                        <i class="fas fa-unlink"></i>
                                    </button>
                                </form>
                                @endif
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="7" class="text-center py-4">
                            <i class="fas fa-school fa-3x text-muted mb-3"></i>
                            <p class="text-muted">Tidak ada data lembaga binaan</p>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <div class="d-flex justify-content-center mt-3">
            {{ $lembaga->appends(request()->query())->links('pagination::bootstrap-4-custom') }}
        </div>
    </div>
</div>

@push('styles')
<style>
    /* Hide duplicate pagination if any */
    .card-body > .d-flex:not(:last-child) nav,
    .card-body > nav:not(:last-of-type) {
        display: none !important;
    }
    
    /* Fix pagination arrow button sizes - make all buttons consistent */
    .pagination .page-link {
        min-width: 38px;
        text-align: center;
        padding: 0.5rem 0.75rem;
        font-size: 0.875rem !important;
        line-height: 1.5;
        display: inline-flex;
        align-items: center;
        justify-content: center;
    }
    
    /* Specifically target first and last buttons (prev/next arrows) */
    .pagination .page-item:first-child .page-link,
    .pagination .page-item:last-child .page-link {
        min-width: 38px;
        max-width: 38px;
        font-size: 0.875rem !important;
        padding: 0.5rem 0.5rem;
        font-weight: normal;
    }
    
    /* Ensure all page links have same height */
    .pagination .page-item {
        height: 38px;
    }
    
    .pagination .page-item .page-link {
        height: 38px;
    }
    
    /* Hide duplicate navigation elements */
    .card-body nav ~ nav,
    .d-flex nav ~ nav {
        display: none !important;
    }
</style>
@endpush
@endsection