@extends('layouts.app')

@section('title', 'Edit Lembaga')

@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{ route('pengawas.lembaga.index') }}">Lembaga</a></li>
<li class="breadcrumb-item active">Edit</li>
@endsection

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            <i class="fas fa-school"></i> Edit Lembaga: {{ $lembaga->nama_lembaga }}
        </h3>
        <div class="card-tools">
            <a href="{{ route('pengawas.lembaga.index') }}" class="btn btn-secondary btn-sm">
                <i class="fas fa-arrow-left"></i> Kembali
            </a>
        </div>
    </div>
    <div class="card-body">
        <form action="{{ route('pengawas.lembaga.update', $lembaga) }}" method="POST">
            @csrf
            @method('PUT')
            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="npsn_nsm">NPSN/NSM <span class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('npsn_nsm') is-invalid @enderror" id="npsn_nsm" name="npsn_nsm" value="{{ old('npsn_nsm', $lembaga->npsn_nsm) }}" required>
                        @error('npsn_nsm')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <small class="form-text text-muted">NPSN/NSM harus unik untuk pengawas ini</small>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="nama_lembaga">Nama Lembaga <span class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('nama_lembaga') is-invalid @enderror" id="nama_lembaga" name="nama_lembaga" value="{{ old('nama_lembaga', $lembaga->nama_lembaga) }}" required>
                        @error('nama_lembaga')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="jenis">Jenis Lembaga <span class="text-danger">*</span></label>
                        <select class="form-control @error('jenis') is-invalid @enderror" id="jenis" name="jenis" required>
                            <option value="">Pilih Jenis</option>
                            <option value="RA" {{ old('jenis', $lembaga->jenis) == 'RA' ? 'selected' : '' }}>RA (Raudhatul Athfal)</option>
                            <option value="MI" {{ old('jenis', $lembaga->jenis) == 'MI' ? 'selected' : '' }}>MI (Madrasah Ibtidaiyah)</option>
                            <option value="MTs" {{ old('jenis', $lembaga->jenis) == 'MTs' ? 'selected' : '' }}>MTs (Madrasah Tsanawiyah)</option>
                            <option value="MA" {{ old('jenis', $lembaga->jenis) == 'MA' ? 'selected' : '' }}>MA (Madrasah Aliyah)</option>
                        </select>
                        @error('jenis')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="akreditasi">Akreditasi</label>
                        <input type="text" class="form-control @error('akreditasi') is-invalid @enderror" id="akreditasi" name="akreditasi" value="{{ old('akreditasi', $lembaga->akreditasi) }}" placeholder="A, B, C, atau TT">
                        @error('akreditasi')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="form-group">
                <label for="alamat_lengkap">Alamat Lengkap <span class="text-danger">*</span></label>
                <textarea class="form-control @error('alamat_lengkap') is-invalid @enderror" id="alamat_lengkap" name="alamat_lengkap" rows="3" required>{{ old('alamat_lengkap', $lembaga->alamat_lengkap) }}</textarea>
                @error('alamat_lengkap')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="row">
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="provinsi">Provinsi <span class="text-danger">*</span></label>
                        <select class="form-control @error('provinsi') is-invalid @enderror" id="provinsi" name="provinsi" required>
                            <option value="">Pilih Provinsi</option>
                        </select>
                        @error('provinsi')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="kabupaten">Kabupaten <span class="text-danger">*</span></label>
                        <select class="form-control @error('kabupaten') is-invalid @enderror" id="kabupaten" name="kabupaten" required disabled>
                            <option value="">Pilih Kabupaten</option>
                        </select>
                        @error('kabupaten')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="kecamatan">Kecamatan <span class="text-danger">*</span></label>
                        <select class="form-control @error('kecamatan') is-invalid @enderror" id="kecamatan" name="kecamatan" required disabled>
                            <option value="">Pilih Kecamatan</option>
                        </select>
                        @error('kecamatan')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="kelurahan">Kelurahan <span class="text-danger">*</span></label>
                        <select class="form-control @error('kelurahan') is-invalid @enderror" id="kelurahan" name="kelurahan" required disabled>
                            <option value="">Pilih Kelurahan</option>
                        </select>
                        @error('kelurahan')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="kode_pos">Kode Pos</label>
                        <input type="text" class="form-control @error('kode_pos') is-invalid @enderror" id="kode_pos" name="kode_pos" value="{{ old('kode_pos', $lembaga->kode_pos) }}">
                        @error('kode_pos')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="telepon">Telepon</label>
                        <input type="text" class="form-control @error('telepon') is-invalid @enderror" id="telepon" name="telepon" value="{{ old('telepon', $lembaga->telepon) }}">
                        @error('telepon')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="email">Email</label>
                        <input type="email" class="form-control @error('email') is-invalid @enderror" id="email" name="email" value="{{ old('email', $lembaga->email) }}">
                        @error('email')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="tahun_berdiri">Tahun Berdiri</label>
                        <input type="number" class="form-control @error('tahun_berdiri') is-invalid @enderror" id="tahun_berdiri" name="tahun_berdiri" value="{{ old('tahun_berdiri', $lembaga->tahun_berdiri) }}" min="1900" max="{{ date('Y') }}">
                        @error('tahun_berdiri')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="nama_kepala">Nama Kepala <span class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('nama_kepala') is-invalid @enderror" id="nama_kepala" name="nama_kepala" value="{{ old('nama_kepala', $lembaga->nama_kepala) }}" required>
                        @error('nama_kepala')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="nip_kepala">NIP Kepala <span class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('nip_kepala') is-invalid @enderror" id="nip_kepala" name="nip_kepala" value="{{ old('nip_kepala', $lembaga->nip_kepala) }}" required>
                        @error('nip_kepala')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="form-group">
                <label for="website">Website</label>
                <input type="url" class="form-control @error('website') is-invalid @enderror" id="website" name="website" value="{{ old('website', $lembaga->website) }}" placeholder="https://">
                @error('website')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="form-group">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> Update
                </button>
                <a href="{{ route('pengawas.lembaga.index') }}" class="btn btn-secondary">
                    <i class="fas fa-times"></i> Batal
                </a>
            </div>
        </form>
    </div>
</div>

<!-- Hidden inputs to store current values -->
<input type="hidden" id="current_provinsi" value="{{ old('provinsi', $lembaga->provinsi) }}">
<input type="hidden" id="current_kabupaten" value="{{ old('kabupaten', $lembaga->kabupaten) }}">
<input type="hidden" id="current_kecamatan" value="{{ old('kecamatan', $lembaga->kecamatan) }}">
<input type="hidden" id="current_kelurahan" value="{{ old('kelurahan', $lembaga->kelurahan) }}">
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    const currentProvinsi = $('#current_provinsi').val();
    const currentKabupaten = $('#current_kabupaten').val();
    const currentKecamatan = $('#current_kecamatan').val();
    const currentKelurahan = $('#current_kelurahan').val();

    // Load provinces
    loadProvinces();

    // Load provinces function
    function loadProvinces() {
        $.get('/api/wilayah/provinsi', function(data) {
            const provinsiSelect = $('#provinsi');
            provinsiSelect.empty().append('<option value="">Pilih Provinsi</option>');
            
            $.each(data, function(index, provinsi) {
                const selected = (provinsi.id == currentProvinsi) ? 'selected' : '';
                provinsiSelect.append(`<option value="${provinsi.id}" ${selected}>${provinsi.name}</option>`);
            });

            if (currentProvinsi) {
                loadKabupaten(currentProvinsi);
            }
        });
    }

    // Load kabupaten function
    function loadKabupaten(provinsiId) {
        if (!provinsiId) {
            $('#kabupaten').empty().append('<option value="">Pilih Kabupaten</option>').prop('disabled', true);
            $('#kecamatan').empty().append('<option value="">Pilih Kecamatan</option>').prop('disabled', true);
            $('#kelurahan').empty().append('<option value="">Pilih Kelurahan</option>').prop('disabled', true);
            return;
        }

        $.get('/api/wilayah/kabupaten', {province_id: provinsiId}, function(data) {
            const kabupatenSelect = $('#kabupaten');
            kabupatenSelect.empty().append('<option value="">Pilih Kabupaten</option>');
            
            $.each(data, function(index, kabupaten) {
                const selected = (kabupaten.id == currentKabupaten) ? 'selected' : '';
                kabupatenSelect.append(`<option value="${kabupaten.id}" ${selected}>${kabupaten.name}</option>`);
            });

            kabupatenSelect.prop('disabled', false);

            if (currentKabupaten) {
                loadKecamatan(currentKabupaten);
            }
        });
    }

    // Load kecamatan function
    function loadKecamatan(kabupatenId) {
        if (!kabupatenId) {
            $('#kecamatan').empty().append('<option value="">Pilih Kecamatan</option>').prop('disabled', true);
            $('#kelurahan').empty().append('<option value="">Pilih Kelurahan</option>').prop('disabled', true);
            return;
        }

        $.get('/api/wilayah/kecamatan', {regency_id: kabupatenId}, function(data) {
            const kecamatanSelect = $('#kecamatan');
            kecamatanSelect.empty().append('<option value="">Pilih Kecamatan</option>');
            
            $.each(data, function(index, kecamatan) {
                const selected = (kecamatan.id == currentKecamatan) ? 'selected' : '';
                kecamatanSelect.append(`<option value="${kecamatan.id}" ${selected}>${kecamatan.name}</option>`);
            });

            kecamatanSelect.prop('disabled', false);

            if (currentKecamatan) {
                loadKelurahan(currentKecamatan);
            }
        });
    }

    // Load kelurahan function
    function loadKelurahan(kecamatanId) {
        if (!kecamatanId) {
            $('#kelurahan').empty().append('<option value="">Pilih Kelurahan</option>').prop('disabled', true);
            return;
        }

        $.get('/api/wilayah/kelurahan', {district_id: kecamatanId}, function(data) {
            const kelurahanSelect = $('#kelurahan');
            kelurahanSelect.empty().append('<option value="">Pilih Kelurahan</option>');
            
            $.each(data, function(index, kelurahan) {
                const selected = (kelurahan.id == currentKelurahan) ? 'selected' : '';
                kelurahanSelect.append(`<option value="${kelurahan.id}" ${selected}>${kelurahan.name}</option>`);
            });

            kelurahanSelect.prop('disabled', false);
        });
    }

    // Event handlers for cascading dropdowns
    $('#provinsi').on('change', function() {
        const provinsiId = $(this).val();
        loadKabupaten(provinsiId);
        $('#kecamatan').empty().append('<option value="">Pilih Kecamatan</option>').prop('disabled', true);
        $('#kelurahan').empty().append('<option value="">Pilih Kelurahan</option>').prop('disabled', true);
    });

    $('#kabupaten').on('change', function() {
        const kabupatenId = $(this).val();
        loadKecamatan(kabupatenId);
        $('#kelurahan').empty().append('<option value="">Pilih Kelurahan</option>').prop('disabled', true);
    });

    $('#kecamatan').on('change', function() {
        const kecamatanId = $(this).val();
        loadKelurahan(kecamatanId);
    });
});
</script>
@endpush
