@extends('layouts.app')

@section('title', 'Detail Instrumen Penilaian')

@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{ route('pengawas.instrumen.index') }}">Instrumen</a></li>
<li class="breadcrumb-item"><a href="{{ route('pengawas.items.index', $instrumen) }}">Komponen: {{ Str::limit($instrumen->judul, 20) }}</a></li>
<li class="breadcrumb-item active">Detail: {{ Str::limit($item->nama_komponen, 30) }}</li>
@endsection

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            <i class="fas fa-list-alt"></i> Detail Instrumen Penilaian: {{ $item->nama_komponen }}
        </h3>
        <div class="card-tools">
            <a href="{{ route('pengawas.items.index', $instrumen) }}" class="btn btn-secondary btn-sm">
                <i class="fas fa-arrow-left"></i> Kembali
            </a>
        </div>
    </div>
    <div class="card-body">
        <!-- Info Boxes -->
        <div class="row mb-4">
            <div class="col-md-4">
                <div class="info-box bg-info">
                    <span class="info-box-icon"><i class="fas fa-cogs"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Komponen</span>
                        <span class="info-box-number">{{ $item->nama_komponen }}</span>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="info-box bg-success">
                    <span class="info-box-icon"><i class="fas fa-list-alt"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Total Instrumen</span>
                        <span class="info-box-number">{{ $item->instrumenPenilaians->count() }}</span>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="info-box bg-{{ $item->is_active ? 'success' : 'danger' }}">
                    <span class="info-box-icon"><i class="fas fa-toggle-{{ $item->is_active ? 'on' : 'off' }}"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Status</span>
                        <span class="info-box-number">{{ $item->is_active ? 'Aktif' : 'Nonaktif' }}</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Komponen Details -->
        <div class="row">
            <div class="col-md-12">
                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <h3 class="card-title">
                            <i class="fas fa-info-circle"></i> Informasi Komponen
                        </h3>
                    </div>
                    <div class="card-body">
                        <dl class="row">
                            <dt class="col-sm-3">Nama Komponen:</dt>
                            <dd class="col-sm-9">{{ $item->nama_komponen }}</dd>
                            
                            <dt class="col-sm-3">Deskripsi:</dt>
                            <dd class="col-sm-9">{{ $item->deskripsi ?: '-' }}</dd>
                            
                            <dt class="col-sm-3">Urutan:</dt>
                            <dd class="col-sm-9">{{ $item->urutan }}</dd>
                            
                            <dt class="col-sm-3">Status:</dt>
                            <dd class="col-sm-9">
                                <span class="badge badge-{{ $item->is_active ? 'success' : 'danger' }}">
                                    {{ $item->is_active ? 'Aktif' : 'Nonaktif' }}
                                </span>
                            </dd>
                            
                            <dt class="col-sm-3">Dibuat:</dt>
                            <dd class="col-sm-9">{{ $item->created_at->format('d M Y H:i') }}</dd>
                            
                            <dt class="col-sm-3">Diperbarui:</dt>
                            <dd class="col-sm-9">{{ $item->updated_at->format('d M Y H:i') }}</dd>
                        </dl>
                    </div>
                </div>
            </div>
        </div>

        <!-- Instrumen Penilaian -->
        @if($item->instrumenPenilaians->count() > 0)
        <div class="row mt-4">
            <div class="col-md-12">
                <div class="card card-success card-outline">
                    <div class="card-header">
                        <h3 class="card-title">
                            <i class="fas fa-list-alt"></i> Instrumen Penilaian ({{ $item->instrumenPenilaians->count() }})
                        </h3>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped table-hover">
                                <thead class="thead-dark">
                                    <tr>
                                        <th width="5%">No</th>
                                        <th width="25%">Indikator Kinerja</th>
                                        <th width="20%">Evidensi Kinerja</th>
                                        <th width="10%">Skor Min</th>
                                        <th width="10%">Skor Max</th>
                                        <th width="15%">Bukti URL</th>
                                        <th width="15%">Catatan Verifikasi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($item->instrumenPenilaians->sortBy('no_urutan') as $instrumenPenilaian)
                                    <tr>
                                        <td>{{ $instrumenPenilaian->no_urutan }}</td>
                                        <td>
                                            <strong>{{ $instrumenPenilaian->indikator_kinerja }}</strong>
                                        </td>
                                        <td>{{ $instrumenPenilaian->evidensi_kinerja ?: '-' }}</td>
                                        <td>
                                            <span class="badge badge-warning">{{ $instrumenPenilaian->skor_min }}</span>
                                        </td>
                                        <td>
                                            <span class="badge badge-success">{{ $instrumenPenilaian->skor_max }}</span>
                                        </td>
                                        <td>
                                            @if($instrumenPenilaian->bukti_url)
                                                <a href="{{ $instrumenPenilaian->bukti_url }}" target="_blank" class="btn btn-sm btn-outline-info">
                                                    <i class="fas fa-external-link-alt"></i> Lihat
                                                </a>
                                            @else
                                                <span class="text-muted">-</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if($instrumenPenilaian->catatan_verifikasi)
                                                <span class="text-success">
                                                    <i class="fas fa-check-circle"></i> Sudah diverifikasi
                                                </span>
                                            @else
                                                <span class="text-muted">Belum ada catatan</span>
                                            @endif
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @else
        <div class="row mt-4">
            <div class="col-md-12">
                <div class="card card-warning card-outline">
                    <div class="card-body text-center py-4">
                        <i class="fas fa-exclamation-triangle fa-3x text-warning mb-3"></i>
                        <h5>Belum Ada Instrumen Penilaian</h5>
                        <p class="text-muted">Komponen ini belum memiliki instrumen penilaian. Silakan hubungi admin untuk menambahkan instrumen penilaian.</p>
                    </div>
                </div>
            </div>
        </div>
        @endif

        <!-- Role Information -->
        <div class="row mt-4">
            <div class="col-md-12">
                <div class="alert alert-light">
                    <h6><i class="fas fa-users"></i> Pembagian Peran dalam Penilaian:</h6>
                    <div class="row">
                        <div class="col-md-4">
                            <small class="text-muted">
                                <i class="fas fa-user-tie text-primary"></i> <strong>Admin:</strong> Membuat struktur instrumen
                            </small>
                        </div>
                        <div class="col-md-4">
                            <small class="text-muted">
                                <i class="fas fa-chalkboard-teacher text-success"></i> <strong>Guru:</strong> Mengisi Bukti URL
                            </small>
                        </div>
                        <div class="col-md-4">
                            <small class="text-muted">
                                <i class="fas fa-user-shield text-warning"></i> <strong>Kepala:</strong> Mengisi Catatan Verifikasi
                            </small>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Action Buttons -->
        <div class="row mt-4">
            <div class="col-md-12 text-center">
                <a href="{{ route('pengawas.items.index', $instrumen) }}" class="btn btn-secondary">
                    <i class="fas fa-arrow-left"></i> Kembali ke Komponen
                </a>
                <a href="{{ route('pengawas.instrumen.index') }}" class="btn btn-info">
                    <i class="fas fa-list"></i> Kembali ke Instrumen
                </a>
            </div>
        </div>
    </div>
</div>
@endsection
