@extends('layouts.app')

@section('title', 'Tambah Item Instrumen')

@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{ route('pengawas.instrumen.index') }}">Instrumen</a></li>
<li class="breadcrumb-item"><a href="{{ route('pengawas.items.index', $instrumen) }}">Item</a></li>
<li class="breadcrumb-item active">Tambah</li>
@endsection

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            <i class="fas fa-plus"></i> Tambah Item Instrumen: {{ $instrumen->judul }}
        </h3>
        <div class="card-tools">
            <a href="{{ route('pengawas.items.index', $instrumen) }}" class="btn btn-secondary btn-sm">
                <i class="fas fa-arrow-left"></i> Kembali
            </a>
        </div>
    </div>
    <div class="card-body">
        <form action="{{ route('pengawas.items.store', $instrumen) }}" method="POST">
            @csrf
            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="nomor_urut">Nomor Urut <span class="text-danger">*</span></label>
                        <input type="number" class="form-control @error('nomor_urut') is-invalid @enderror" id="nomor_urut" name="nomor_urut" value="{{ old('nomor_urut', $instrumen->instrumenItems()->count() + 1) }}" required min="1">
                        @error('nomor_urut')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="bobot">Bobot <span class="text-danger">*</span></label>
                        <input type="number" class="form-control @error('bobot') is-invalid @enderror" id="bobot" name="bobot" value="{{ old('bobot', 1.00) }}" step="0.01" min="0.01" max="10.00" required>
                        @error('bobot')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="form-group">
                <label for="aspek_dimensi">Aspek Dimensi <span class="text-danger">*</span></label>
                <input type="text" class="form-control @error('aspek_dimensi') is-invalid @enderror" id="aspek_dimensi" name="aspek_dimensi" value="{{ old('aspek_dimensi') }}" required>
                @error('aspek_dimensi')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="form-group">
                <label for="indikator">Indikator <span class="text-danger">*</span></label>
                <textarea class="form-control @error('indikator') is-invalid @enderror" id="indikator" name="indikator" rows="3" required>{{ old('indikator') }}</textarea>
                @error('indikator')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="form-group">
                <label for="sub_indikator">Sub Indikator</label>
                <textarea class="form-control @error('sub_indikator') is-invalid @enderror" id="sub_indikator" name="sub_indikator" rows="2">{{ old('sub_indikator') }}</textarea>
                @error('sub_indikator')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="form-group">
                <label for="bukti_yang_diperlukan">Bukti Yang Diperlukan <span class="text-danger">*</span></label>
                <textarea class="form-control @error('bukti_yang_diperlukan') is-invalid @enderror" id="bukti_yang_diperlukan" name="bukti_yang_diperlukan" rows="3" required>{{ old('bukti_yang_diperlukan') }}</textarea>
                @error('bukti_yang_diperlukan')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="form-group">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> Simpan
                </button>
                <a href="{{ route('pengawas.items.index', $instrumen) }}" class="btn btn-secondary">
                    <i class="fas fa-times"></i> Batal
                </a>
            </div>
        </form>
    </div>
</div>
@endsection