@extends('layouts.app')

@section('title', 'Detail Instrumen')

@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{ route('pengawas.instrumen.index') }}">Instrumen</a></li>
<li class="breadcrumb-item active">Detail: {{ Str::limit($instrumen->judul, 30) }}</li>
@endsection

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            <i class="fas fa-eye"></i> Detail Instrumen: {{ $instrumen->judul }}
        </h3>
        <div class="card-tools">
            <a href="{{ route('pengawas.instrumen.index') }}" class="btn btn-secondary btn-sm">
                <i class="fas fa-arrow-left"></i> Kembali
            </a>
        </div>
    </div>
    <div class="card-body">
        <!-- Info Boxes -->
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="info-box bg-info">
                    <span class="info-box-icon"><i class="fas fa-calendar"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Tahun Ajaran</span>
                        <span class="info-box-number">{{ $instrumen->tahun_ajaran }}</span>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="info-box bg-warning">
                    <span class="info-box-icon"><i class="fas fa-calendar-alt"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Semester</span>
                        <span class="info-box-number">{{ $instrumen->semester }}</span>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="info-box bg-success">
                    <span class="info-box-icon"><i class="fas fa-cogs"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Total Komponen</span>
                        <span class="info-box-number">{{ $instrumen->komponenPenilaians()->count() }}</span>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="info-box bg-{{ $instrumen->is_active ? 'success' : 'danger' }}">
                    <span class="info-box-icon"><i class="fas fa-toggle-{{ $instrumen->is_active ? 'on' : 'off' }}"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Status</span>
                        <span class="info-box-number">{{ $instrumen->is_active ? 'Aktif' : 'Nonaktif' }}</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Instrumen Details -->
        <div class="row">
            <div class="col-md-12">
                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <h3 class="card-title">
                            <i class="fas fa-info-circle"></i> Informasi Instrumen
                        </h3>
                    </div>
                    <div class="card-body">
                        <dl class="row">
                            <dt class="col-sm-3">Judul Instrumen:</dt>
                            <dd class="col-sm-9">{{ $instrumen->judul }}</dd>
                            
                            <dt class="col-sm-3">Deskripsi:</dt>
                            <dd class="col-sm-9">{{ $instrumen->deskripsi ?: '-' }}</dd>
                            
                            <dt class="col-sm-3">Tahun Ajaran:</dt>
                            <dd class="col-sm-9">{{ $instrumen->tahun_ajaran }}</dd>
                            
                            <dt class="col-sm-3">Semester:</dt>
                            <dd class="col-sm-9">Semester {{ $instrumen->semester }}</dd>
                            
                            <dt class="col-sm-3">Status:</dt>
                            <dd class="col-sm-9">
                                <span class="badge badge-{{ $instrumen->is_active ? 'success' : 'danger' }}">
                                    {{ $instrumen->is_active ? 'Aktif' : 'Nonaktif' }}
                                </span>
                            </dd>
                            
                            <dt class="col-sm-3">Dibuat:</dt>
                            <dd class="col-sm-9">{{ $instrumen->created_at->format('d M Y H:i') }}</dd>
                            
                            <dt class="col-sm-3">Diperbarui:</dt>
                            <dd class="col-sm-9">{{ $instrumen->updated_at->format('d M Y H:i') }}</dd>
                        </dl>
                    </div>
                </div>
            </div>
        </div>

        <!-- Struktur Instrumen Hierarkis -->
        @if($instrumen->komponenPenilaians()->count() > 0)
        <div class="row mt-4">
            <div class="col-md-12">
                <div class="card card-success card-outline">
                    <div class="card-header">
                        <h3 class="card-title">
                            <i class="fas fa-list-alt"></i> Struktur Instrumen Penilaian
                        </h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-bordered table-hover">
                                <thead class="thead-dark">
                                    <tr>
                                        <th width="8%">No</th>
                                        <th width="35%">Indikator Kerja</th>
                                        <th width="30%">Evidensi Kerja</th>
                                        <th width="8%">Skor Min</th>
                                        <th width="8%">Skor Max</th>
                                        <th width="11%">Jenis</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                        $komponenLetters = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J'];
                                    @endphp
                                    
                                    @foreach($instrumen->komponenPenilaians()->orderBy('urutan')->get() as $komponenIndex => $komponen)
                                        <!-- Komponen Row (Level Tertinggi) -->
                                        <tr class="table-dark">
                                            <td><strong>{{ $komponenIndex + 1 }}</strong></td>
                                            <td>
                                                <strong>{{ $komponen->nama_komponen }}</strong>
                                                @if($komponen->deskripsi)
                                                    <br><small class="text-muted">{{ $komponen->deskripsi }}</small>
                                                @endif
                                            </td>
                                            <td colspan="3">
                                                <span class="badge badge-dark">Komponen</span>
                                                <span class="badge badge-secondary">{{ $komponen->subKomponens->count() }} Sub Komponen</span>
                                            </td>
                                            <td>
                                                <span class="badge badge-dark">Komponen</span>
                                            </td>
                                        </tr>
                                        
                                        @foreach($komponen->subKomponens()->orderBy('urutan')->get() as $subKomponenIndex => $subKomponen)
                                            <!-- Sub Komponen Row (A, B, C, dst.) -->
                                            <tr class="table-primary">
                                                <td><strong>{{ $komponenLetters[$subKomponenIndex] }}</strong></td>
                                                <td>
                                                    <strong>{{ $subKomponen->nama_sub_komponen }}</strong>
                                                    @if($subKomponen->deskripsi)
                                                        <br><small class="text-muted">{{ $subKomponen->deskripsi }}</small>
                                                    @endif
                                                </td>
                                                <td colspan="3">
                                                    <span class="badge badge-info">Sub Komponen</span>
                                                    <span class="badge badge-light">{{ $subKomponen->instrumenPenilaians->count() }} Instrumen</span>
                                                </td>
                                                <td>
                                                    <span class="badge badge-primary">Sub Komponen</span>
                                                </td>
                                            </tr>
                                            
                                            @foreach($subKomponen->instrumenPenilaians()->orderBy('no_urutan')->get() as $instrumenItem)
                                                <!-- Instrumen Row (A1, A2, A3, dst.) -->
                                                <tr class="table-light">
                                                    <td>
                                                        <strong>{{ $komponenLetters[$subKomponenIndex] }}{{ $instrumenItem->no_urutan }}</strong>
                                                    </td>
                                                    <td>
                                                        <div class="text-sm">
                                                            <strong>{{ $instrumenItem->indikator_kinerja }}</strong>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="text-sm">
                                                            {{ $instrumenItem->evidensi_kinerja }}
                                                        </div>
                                                    </td>
                                                    <td class="text-center">
                                                        <span class="badge badge-success">{{ $instrumenItem->skor_min }}</span>
                                                    </td>
                                                    <td class="text-center">
                                                        <span class="badge badge-danger">{{ $instrumenItem->skor_max }}</span>
                                                    </td>
                                                    <td>
                                                        <span class="badge badge-light">Instrumen</span>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        @endforeach
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        
                        <!-- Summary Information -->
                        <div class="row mt-3">
                            <div class="col-md-12">
                                <div class="alert alert-info">
                                    <h5><i class="fas fa-info-circle"></i> Ringkasan Struktur</h5>
                                    <div class="row">
                                        <div class="col-md-3">
                                            <strong>Total Komponen:</strong> {{ $instrumen->komponenPenilaians()->count() }}
                                        </div>
                                        <div class="col-md-3">
                                            <strong>Total Sub Komponen:</strong> {{ $instrumen->komponenPenilaians()->withCount('subKomponens')->get()->sum('sub_komponens_count') }}
                                        </div>
                                        <div class="col-md-3">
                                            <strong>Total Instrumen:</strong> {{ $instrumen->komponenPenilaians()->withCount(['subKomponens' => function($query) { $query->withCount('instrumenPenilaians'); }])->get()->sum('sub_komponens_count') }}
                                        </div>
                                        <div class="col-md-3">
                                            <strong>Status:</strong> 
                                            <span class="badge badge-{{ $instrumen->is_active ? 'success' : 'danger' }}">
                                                {{ $instrumen->is_active ? 'Aktif' : 'Nonaktif' }}
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @else
        <div class="row mt-4">
            <div class="col-md-12">
                <div class="card card-warning card-outline">
                    <div class="card-body text-center py-4">
                        <i class="fas fa-exclamation-triangle fa-3x text-warning mb-3"></i>
                        <h5>Belum Ada Komponen Penilaian</h5>
                        <p class="text-muted">Instrumen ini belum memiliki komponen penilaian. Silakan hubungi admin untuk menambahkan komponen.</p>
                    </div>
                </div>
            </div>
        </div>
        @endif

        <!-- Action Buttons -->
        <div class="row mt-4">
            <div class="col-md-12 text-center">
                <a href="{{ route('pengawas.instrumen.index') }}" class="btn btn-secondary">
                    <i class="fas fa-arrow-left"></i> Kembali ke Daftar
                </a>
                @if($instrumen->komponenPenilaians()->count() > 0)
                <a href="{{ route('pengawas.items.index', $instrumen) }}" class="btn btn-primary">
                    <i class="fas fa-list"></i> Lihat Detail Komponen
                </a>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection
