@extends('layouts.app')

@section('title', 'Detail Distribusi Instrumen')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-eye"></i> Detail Distribusi Instrumen
                    </h3>
                    <div class="card-tools">
                        <a href="{{ route('pengawas.distribusi.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Kembali
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            {{ session('success') }}
                        </div>
                    @endif

                    <!-- Distribusi Information -->
                    <div class="row mb-4">
                        <div class="col-md-8">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">
                                        <i class="fas fa-info-circle"></i> Informasi Distribusi
                                    </h4>
                                </div>
                                <div class="card-body">
                                    <dl class="row">
                                        <dt class="col-sm-3">Instrumen:</dt>
                                        <dd class="col-sm-9">
                                            <strong>{{ $distribusi->instrumen->judul }}</strong>
                                            <br>
                                            <small class="text-muted">{{ $distribusi->instrumen->tahun_ajaran }} - Semester {{ $distribusi->instrumen->semester }}</small>
                                        </dd>

                                        <dt class="col-sm-3">Lembaga:</dt>
                                        <dd class="col-sm-9">
                                            <strong>{{ $distribusi->lembaga->nama_lembaga }}</strong>
                                            <br>
                                            <small class="text-muted">{{ $distribusi->lembaga->jenis }} - {{ $distribusi->lembaga->kecamatan_name ?? $distribusi->lembaga->kecamatan }}</small>
                                        </dd>

                                        <dt class="col-sm-3">Tanggal Distribusi:</dt>
                                        <dd class="col-sm-9">{{ $distribusi->tanggal_distribusi->format('d F Y') }}</dd>

                                        <dt class="col-sm-3">Deadline:</dt>
                                        <dd class="col-sm-9">
                                            {{ $distribusi->deadline->format('d F Y') }}
                                            @if($distribusi->deadline->isPast() && $distribusi->status == 'active')
                                                <span class="badge badge-danger ml-2">Terlambat</span>
                                            @elseif($distribusi->deadline->diffInDays() <= 7 && $distribusi->status == 'active')
                                                <span class="badge badge-warning ml-2">Mendekati Deadline</span>
                                            @endif
                                        </dd>

                                        <dt class="col-sm-3">Status:</dt>
                                        <dd class="col-sm-9">
                                            @if($distribusi->status == 'active')
                                                <span class="badge badge-success">Aktif</span>
                                            @else
                                                <span class="badge badge-secondary">Ditutup</span>
                                            @endif
                                        </dd>

                                        <dt class="col-sm-3">Komponen:</dt>
                                        <dd class="col-sm-9">
                                            @if($distribusi->komponen)
                                                <span class="badge badge-info">
                                                    <i class="fas fa-puzzle-piece"></i> {{ $distribusi->komponen->nama_komponen }}
                                                </span>
                                                @if($distribusi->komponen->deskripsi)
                                                    <br><small class="text-muted">{{ $distribusi->komponen->deskripsi }}</small>
                                                @endif
                                            @else
                                                <span class="badge badge-success">
                                                    <i class="fas fa-check-circle"></i> Semua Komponen
                                                </span>
                                            @endif
                                        </dd>
                                    </dl>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">
                                        <i class="fas fa-chart-pie"></i> Statistik Penilaian
                                    </h4>
                                </div>
                                <div class="card-body">
                                    <div class="row text-center">
                                        <div class="col-6">
                                            <div class="border-right">
                                                <h3 class="text-primary">{{ $penilaianStats['total_kepala'] }}</h3>
                                                <small class="text-muted">Total Kepala</small>
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <h3 class="text-success">{{ $penilaianStats['validated'] }}</h3>
                                            <small class="text-muted">Selesai</small>
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="row">
                                        <div class="col-6">
                                            <small class="text-muted">
                                                <i class="fas fa-clock text-warning"></i> Draft: {{ $penilaianStats['draft'] }}
                                            </small>
                                        </div>
                                        <div class="col-6">
                                            <small class="text-muted">
                                                <i class="fas fa-paper-plane text-info"></i> Submitted: {{ $penilaianStats['submitted'] }}
                                            </small>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-6">
                                            <small class="text-muted">
                                                <i class="fas fa-edit text-warning"></i> Revision: {{ $penilaianStats['revision'] }}
                                            </small>
                                        </div>
                                        <div class="col-6">
                                            <small class="text-muted">
                                                <i class="fas fa-check-circle text-success"></i> Validated: {{ $penilaianStats['validated'] }}
                                            </small>
                                        </div>
                                    </div>
                                    
                                    @if($penilaianStats['total_kepala'] > 0)
                                    @php
                                        $percentage = round(($penilaianStats['validated'] / $penilaianStats['total_kepala']) * 100, 1);
                                    @endphp
                                    <div class="mt-3">
                                        <div class="progress" style="height: 20px;">
                                            <div class="progress-bar bg-success" role="progressbar" style="width: {{ $percentage }}%" aria-valuenow="{{ $percentage }}" aria-valuemin="0" aria-valuemax="100">
                                                {{ $percentage }}%
                                            </div>
                                        </div>
                                        <small class="text-muted">Progress Penyelesaian</small>
                                    </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Penilaian Kepala Table -->
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">
                                <i class="fas fa-user-tie"></i> Status Penilaian Kepala
                            </h4>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th width="5%">No</th>
                                            <th>Nama Kepala</th>
                                            <th>Email</th>
                                            <th>Lembaga</th>
                                            <th>Status</th>
                                            <th>Tanggal Submit</th>
                                            <th>Tanggal Validasi</th>
                                            <th width="10%">Aksi</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($distribusi->penilaianKepala as $penilaian)
                                        <tr>
                                            <td>{{ $loop->iteration }}</td>
                                            <td>
                                                <strong>{{ $penilaian->kepala->name ?? '-' }}</strong>
                                            </td>
                                            <td>{{ $penilaian->kepala->email ?? '-' }}</td>
                                            <td>{{ $distribusi->lembaga->nama_lembaga ?? '-' }}</td>
                                            <td>
                                                @switch($penilaian->status)
                                                    @case('draft')
                                                        <span class="badge badge-secondary">Draft</span>
                                                        @break
                                                    @case('submitted')
                                                        <span class="badge badge-primary">Submitted</span>
                                                        @break
                                                    @case('revision')
                                                        <span class="badge badge-warning">Revision</span>
                                                        @break
                                                    @case('validated')
                                                        <span class="badge badge-success">Validated</span>
                                                        @break
                                                    @case('final')
                                                        <span class="badge badge-primary">Final</span>
                                                        @break
                                                @endswitch
                                            </td>
                                            <td>
                                                @if($penilaian->tanggal_submit)
                                                    {{ $penilaian->tanggal_submit->format('d/m/Y H:i') }}
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                            <td>
                                                @if($penilaian->tanggal_validasi)
                                                    {{ $penilaian->tanggal_validasi->format('d/m/Y H:i') }}
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                            <td>
                                                <a href="{{ route('pengawas.penilaian.show', $penilaian->id) }}" class="btn btn-info btn-sm" title="Review/Isi Penilaian">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                            </td>
                                        </tr>
                                        @empty
                                        <tr>
                                            <td colspan="8" class="text-center">
                                                <div class="py-4">
                                                    <i class="fas fa-user-tie fa-3x text-muted mb-3"></i>
                                                    <h5 class="text-muted">Belum ada data penilaian kepala</h5>
                                                    <p class="text-muted">Kepala belum mulai mengisi instrumen penilaian.</p>
                                                </div>
                                            </td>
                                        </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card-footer">
                    <div class="d-flex justify-content-between">
                        <a href="{{ route('pengawas.distribusi.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Kembali ke Daftar
                        </a>
                        
                        @if($distribusi->status == 'active')
                            <form action="{{ route('pengawas.distribusi.close', $distribusi->id) }}" method="POST" class="d-inline" onsubmit="return confirm('Apakah Anda yakin ingin menutup distribusi ini? Tindakan ini tidak dapat dibatalkan.')">
                                @csrf
                                <button type="submit" class="btn btn-warning">
                                    <i class="fas fa-lock"></i> Tutup Distribusi
                                </button>
                            </form>
                        @else
                            <span class="text-muted">
                                <i class="fas fa-lock"></i> Distribusi sudah ditutup
                            </span>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Auto-hide alerts after 5 seconds
    setTimeout(function() {
        $('.alert').fadeOut('slow');
    }, 5000);
});
</script>
@endpush
