@extends('layouts.app')

@section('title', 'Distribusi Instrumen')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-share-alt"></i> Distribusi Instrumen
                    </h3>
                    <div class="card-tools">
                        <a href="{{ route('pengawas.distribusi.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> Distribusi Baru
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            {{ session('success') }}
                        </div>
                    @endif

                    @if(session('error'))
                        <div class="alert alert-danger alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            {{ session('error') }}
                        </div>
                    @endif

                    <!-- Statistics Cards -->
                    <div class="row mb-4">
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-info">
                                <div class="inner">
                                    <h3>{{ $stats['total_distribusi'] }}</h3>
                                    <p>Total Distribusi</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-share-alt"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-success">
                                <div class="inner">
                                    <h3>{{ $stats['active_distribusi'] }}</h3>
                                    <p>Distribusi Aktif</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-play-circle"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-warning">
                                <div class="inner">
                                    <h3>{{ $stats['completed_penilaian'] }}</h3>
                                    <p>Penilaian Selesai</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-check-circle"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-secondary">
                                <div class="inner">
                                    <h3>{{ $stats['in_progress'] }}</h3>
                                    <p>Dalam Proses</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-clock"></i>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Distribusi Table -->
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th width="5%">No</th>
                                    <th>Instrumen</th>
                                    <th>Lembaga</th>
                                    <th>Tanggal Distribusi</th>
                                    <th>Deadline</th>
                                    <th>Status</th>
                                    <th>Progress Penilaian</th>
                                    <th width="15%">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($distribusi as $item)
                                <tr>
                                    <td>{{ $loop->iteration + ($distribusi->currentPage() - 1) * $distribusi->perPage() }}</td>
                                    <td>
                                        <strong>{{ $item->instrumen->judul }}</strong>
                                        <br>
                                        <small class="text-muted">{{ $item->instrumen->tahun_ajaran }} - Semester {{ $item->instrumen->semester }}</small>
                                        @if($item->komponen)
                                            <br>
                                            <span class="badge badge-info">
                                                <i class="fas fa-puzzle-piece"></i> {{ $item->komponen->nama_komponen }}
                                            </span>
                                        @else
                                            <br>
                                            <span class="badge badge-success">
                                                <i class="fas fa-check-circle"></i> Semua Komponen
                                            </span>
                                        @endif
                                    </td>
                                    <td>
                                        <strong>{{ $item->lembaga->nama_lembaga }}</strong>
                                        <br>
                                        <small class="text-muted">{{ $item->lembaga->jenis }}</small>
                                    </td>
                                    <td>{{ $item->tanggal_distribusi->format('d/m/Y') }}</td>
                                    <td>
                                        {{ $item->deadline->format('d/m/Y') }}
                                        @if($item->deadline->isPast() && $item->status == 'active')
                                            <br><small class="text-danger"><i class="fas fa-exclamation-triangle"></i> Terlambat</small>
                                        @endif
                                    </td>
                                    <td>
                                        @if($item->status == 'active')
                                            <span class="badge badge-success">Aktif</span>
                                        @else
                                            <span class="badge badge-secondary">Ditutup</span>
                                        @endif
                                    </td>
                                    <td>
                                        @php
                                            $total = $item->penilaianKepala()->count();
                                            $completed = $item->penilaianKepala()->whereIn('status', ['validated', 'final'])->count();
                                            $percentage = $total > 0 ? round(($completed / $total) * 100, 1) : 0;
                                        @endphp

                                        <div class="progress mb-1" style="height: 20px;">
                                            <div class="progress-bar" role="progressbar" style="width: {{ $percentage }}%" aria-valuenow="{{ $percentage }}" aria-valuemin="0" aria-valuemax="100">
                                                {{ $percentage }}%
                                            </div>
                                        </div>
                                        <small class="text-muted">{{ $completed }}/{{ $total }} kepala</small>
                                    </td>
                                    <td>
                                        <a href="{{ route('pengawas.distribusi.show', $item->id) }}" class="btn btn-info btn-sm" title="Lihat Detail">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        
                                        @if($item->status == 'active')
                                            <form action="{{ route('pengawas.distribusi.close', $item->id) }}" method="POST" class="d-inline" onsubmit="return confirm('Apakah Anda yakin ingin menutup distribusi ini?')">
                                                @csrf
                                                <button type="submit" class="btn btn-warning btn-sm" title="Tutup Distribusi">
                                                    <i class="fas fa-lock"></i>
                                                </button>
                                            </form>
                                        @endif
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="8" class="text-center">
                                        <div class="py-4">
                                            <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                                            <h5 class="text-muted">Belum ada distribusi instrumen</h5>
                                            <p class="text-muted">Mulai dengan mendistribusikan instrumen ke lembaga binaan Anda.</p>
                                            <a href="{{ route('pengawas.distribusi.create') }}" class="btn btn-primary">
                                                <i class="fas fa-plus"></i> Distribusi Baru
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    @if($distribusi->hasPages())
                    <div class="d-flex justify-content-center">
                        {{ $distribusi->links('pagination::bootstrap-4-custom') }}
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

@push('styles')
<style>
    /* Hide duplicate pagination if any */
    .card-body > .d-flex:not(:last-child) nav,
    .card-body > nav:not(:last-of-type) {
        display: none !important;
    }
    
    /* Fix pagination arrow button sizes - make all buttons consistent */
    .pagination .page-link {
        min-width: 38px;
        text-align: center;
        padding: 0.5rem 0.75rem;
        font-size: 0.875rem !important;
        line-height: 1.5;
        display: inline-flex;
        align-items: center;
        justify-content: center;
    }
    
    /* Specifically target first and last buttons (prev/next arrows) */
    .pagination .page-item:first-child .page-link,
    .pagination .page-item:last-child .page-link {
        min-width: 38px;
        max-width: 38px;
        font-size: 0.875rem !important;
        padding: 0.5rem 0.5rem;
        font-weight: normal;
    }
    
    /* Ensure all page links have same height */
    .pagination .page-item {
        height: 38px;
    }
    
    .pagination .page-item .page-link {
        height: 38px;
    }
    
    /* Hide duplicate navigation elements */
    .card-body nav ~ nav,
    .d-flex nav ~ nav {
        display: none !important;
    }
</style>
@endpush
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Auto-hide alerts after 5 seconds
    setTimeout(function() {
        $('.alert').fadeOut('slow');
    }, 5000);
});
</script>
@endpush