@extends('layouts.app')

@section('title', 'Distribusi Instrumen Baru')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
<div class="card">
    <div class="card-header">
        <h3 class="card-title">
                        <i class="fas fa-plus"></i> Distribusi Instrumen Baru
        </h3>
        <div class="card-tools">
                        <a href="{{ route('pengawas.distribusi.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Kembali
            </a>
        </div>
                </div>
                <form action="{{ route('pengawas.distribusi.store') }}" method="POST">
                    @csrf
                    <div class="card-body">
                        @if(session('error'))
                            <div class="alert alert-danger alert-dismissible">
                                <button type="button" class="close" data-dismiss="alert">&times;</button>
                                {{ session('error') }}
                            </div>
                        @endif

                        <div class="row">
                            <!-- Instrumen Selection -->
                            <div class="col-md-6">
                                <div class="card">
                                    <div class="card-header">
                                        <h3 class="card-title">
                                            <i class="fas fa-clipboard-list"></i> Pilih Instrumen
                                        </h3>
    </div>
    <div class="card-body">
                                        <div class="form-group">
                                            <label for="instrumen_id">Instrumen <span class="text-danger">*</span></label>
                                            <select class="form-control @error('instrumen_id') is-invalid @enderror" 
                                                    id="instrumen_id" name="instrumen_id" required>
                                                <option value="">Pilih Instrumen...</option>
                                                @foreach($instrumen as $item)
                                                    <option value="{{ $item->id }}" 
                                                            data-tahun="{{ $item->tahun_ajaran }}"
                                                            data-semester="{{ $item->semester }}"
                                                            data-deskripsi="{{ $item->deskripsi }}">
                                                        {{ $item->judul }} ({{ $item->tahun_ajaran }} - Semester {{ $item->semester }})
                                                    </option>
                                                @endforeach
                                            </select>
                                            @error('instrumen_id')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>

                                        <!-- Jenis Distribusi -->
                                        <div class="form-group">
                                            <label>Jenis Distribusi <span class="text-danger">*</span></label>
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="jenis_distribusi" 
                                                       id="semua_komponen" value="semua_komponen" 
                                                       {{ old('jenis_distribusi', 'semua_komponen') == 'semua_komponen' ? 'checked' : '' }}>
                                                <label class="form-check-label" for="semua_komponen">
                                                    <strong>Semua Komponen</strong>
                                                    <br><small class="text-muted">Distribusikan semua komponen dalam instrumen ini</small>
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="jenis_distribusi" 
                                                       id="per_komponen" value="per_komponen"
                                                       {{ old('jenis_distribusi') == 'per_komponen' ? 'checked' : '' }}>
                                                <label class="form-check-label" for="per_komponen">
                                                    <strong>Per Komponen</strong>
                                                    <br><small class="text-muted">Pilih komponen tertentu saja untuk didistribusi</small>
                                                </label>
                                            </div>
                                            @error('jenis_distribusi')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>

                                        <!-- Komponen Selection -->
                                        <div id="komponen-selection" class="form-group" style="display: none;">
                                            <label for="komponen_ids">Pilih Komponen <span class="text-danger">*</span></label>
                                            <div id="komponen-list" class="border rounded p-3" style="max-height: 200px; overflow-y: auto;">
                                                <div class="text-center text-muted py-3">
                                                    <i class="fas fa-spinner fa-spin"></i> Memuat komponen...
                                                </div>
                                            </div>
                                            @error('komponen_ids')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>

                                        <!-- Instrumen Details -->
                                        <div id="instrumen-details" class="mt-3" style="display: none;">
        <div class="alert alert-info">
                                                <h6><i class="fas fa-info-circle"></i> Detail Instrumen:</h6>
                                                <div id="instrumen-info"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Deadline -->
                            <div class="col-md-6">
                                <div class="card">
                                    <div class="card-header">
                                        <h3 class="card-title">
                                            <i class="fas fa-calendar-alt"></i> Deadline
                                        </h3>
                                    </div>
                                    <div class="card-body">
                                        <div class="form-group">
                                            <label for="deadline">Deadline Pengisian <span class="text-danger">*</span></label>
                                            <input type="date" 
                                                   class="form-control @error('deadline') is-invalid @enderror" 
                                                   id="deadline" 
                                                   name="deadline" 
                                                   value="{{ old('deadline', now()->addDays(30)->format('Y-m-d')) }}"
                                                   min="{{ now()->addDay()->format('Y-m-d') }}"
                                                   required>
                                            @error('deadline')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                            <small class="form-text text-muted">
                                                Deadline minimal 1 hari dari hari ini
                                            </small>
                                        </div>

                                        <div class="form-group">
                                            <label>Durasi Pengisian:</label>
                                            <div class="input-group">
                                                <input type="number" id="duration" class="form-control" value="30" min="1" max="365">
                                                <div class="input-group-append">
                                                    <span class="input-group-text">hari</span>
                                                </div>
                                            </div>
                                            <small class="form-text text-muted">
                                                Klik "Set Deadline" untuk mengatur deadline otomatis
                                            </small>
                                            <button type="button" class="btn btn-sm btn-outline-primary mt-2" id="set-deadline">
                                                <i class="fas fa-calendar-plus"></i> Set Deadline
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Lembaga Selection -->
                        <div class="row mt-4">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header">
                                        <h3 class="card-title">
                                            <i class="fas fa-school"></i> Pilih Lembaga Binaan
                                        </h3>
                                        <div class="card-tools">
                                            <button type="button" class="btn btn-sm btn-outline-primary" id="select-all">
                                                <i class="fas fa-check-square"></i> Pilih Semua
                                            </button>
                                            <button type="button" class="btn btn-sm btn-outline-secondary" id="deselect-all">
                                                <i class="fas fa-square"></i> Batal Semua
                                            </button>
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        @error('lembaga_ids')
                                            <div class="alert alert-danger">
                                                {{ $message }}
                                            </div>
                                        @enderror

                                        <div class="row">
                                            @forelse($lembaga as $item)
                                            <div class="col-md-6 col-lg-4 mb-3">
                                                <div class="card lembaga-card">
                                                    <div class="card-body">
                                                        <div class="form-check">
                                                            <input class="form-check-input lembaga-checkbox" 
                                                                   type="checkbox" 
                                                                   name="lembaga_ids[]" 
                                                                   value="{{ $item->id }}" 
                                                                   id="lembaga_{{ $item->id }}"
                                                                   {{ in_array($item->id, old('lembaga_ids', [])) ? 'checked' : '' }}>
                                                            <label class="form-check-label" for="lembaga_{{ $item->id }}">
                                                                <strong>{{ $item->nama_lembaga }}</strong>
                                                            </label>
                                                        </div>
                                                        <div class="mt-2">
                                                            <small class="text-muted">
                                                                <i class="fas fa-tag"></i> {{ $item->jenis }}<br>
                                                                <i class="fas fa-map-marker-alt"></i> {{ $item->kecamatan_name ?? $item->kecamatan }}<br>
                                                                <i class="fas fa-users"></i> {{ $item->guru->count() }} guru
                                                            </small>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            @empty
                                            <div class="col-12">
                                                <div class="alert alert-warning">
                                                    <i class="fas fa-exclamation-triangle"></i>
                                                    <strong>Belum ada lembaga binaan!</strong>
                                                    <p class="mb-0">Anda belum diassign ke lembaga manapun. Hubungi admin untuk mengassign lembaga binaan.</p>
                                                </div>
                                            </div>
                                            @endforelse
                                        </div>

                                        <div class="mt-3">
                                            <small class="text-muted">
                                                <i class="fas fa-info-circle"></i>
                                                Total lembaga yang dipilih: <span id="selected-count">0</span>
                                            </small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card-footer">
                        <div class="d-flex justify-content-between">
                            <a href="{{ route('pengawas.distribusi.index') }}" class="btn btn-secondary">
                                <i class="fas fa-times"></i> Batal
                            </a>
                            <button type="submit" class="btn btn-primary" id="submit-btn" disabled>
                                <i class="fas fa-share-alt"></i> Distribusikan Instrumen
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Show instrument details when selected
    $('#instrumen_id').on('change', function() {
        const selectedOption = $(this).find('option:selected');
        const detailsDiv = $('#instrumen-details');
        const infoDiv = $('#instrumen-info');
        const komponenSelection = $('#komponen-selection');
        
        if ($(this).val()) {
            const tahun = selectedOption.data('tahun');
            const semester = selectedOption.data('semester');
            const deskripsi = selectedOption.data('deskripsi');
            
            infoDiv.html(`
                <strong>Tahun Ajaran:</strong> ${tahun}<br>
                <strong>Semester:</strong> ${semester}<br>
                <strong>Deskripsi:</strong> ${deskripsi || 'Tidak ada deskripsi'}
            `);
            detailsDiv.show();
            
            // Load komponen if per_komponen is selected
            if ($('#per_komponen').is(':checked')) {
                loadKomponen($(this).val());
            }
            
            validateForm();
        } else {
            detailsDiv.hide();
            komponenSelection.hide();
            validateForm();
        }
    });

    // Handle jenis distribusi change
    $('input[name="jenis_distribusi"]').on('change', function() {
        const komponenSelection = $('#komponen-selection');
        
        if ($(this).val() === 'per_komponen') {
            const instrumenId = $('#instrumen_id').val();
            if (instrumenId) {
                loadKomponen(instrumenId);
            }
            komponenSelection.show();
        } else {
            komponenSelection.hide();
        }
        
        validateForm();
    });

    // Load komponen via AJAX
    function loadKomponen(instrumenId) {
        const komponenList = $('#komponen-list');
        
        komponenList.html(`
            <div class="text-center text-muted py-3">
                <i class="fas fa-spinner fa-spin"></i> Memuat komponen...
            </div>
        `);

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        
        $.get('/pengawas/distribusi/komponen', { instrumen_id: instrumenId })
            .done(function(data) {
                if (data.length > 0) {
                    let html = '';
                    data.forEach(function(komponen) {
                        html += `
                            <div class="form-check">
                                <input class="form-check-input komponen-checkbox" type="checkbox" 
                                       name="komponen_ids[]" value="${komponen.id}" 
                                       id="komponen_${komponen.id}">
                                <label class="form-check-label" for="komponen_${komponen.id}">
                                    <strong>${komponen.nama_komponen}</strong>
                                    <br><small class="text-muted">${komponen.deskripsi || 'Tidak ada deskripsi'}</small>
                                </label>
                            </div>
                        `;
                    });
                    
                    html += `
                        <div class="mt-3">
                            <button type="button" class="btn btn-sm btn-outline-primary" id="select-all-komponen">
                                <i class="fas fa-check-square"></i> Pilih Semua
                            </button>
                            <button type="button" class="btn btn-sm btn-outline-secondary" id="deselect-all-komponen">
                                <i class="fas fa-square"></i> Batal Semua
                            </button>
                        </div>
                    `;
                    
                    komponenList.html(html);
                    
                    // Add event handlers for komponen selection
                    $('.komponen-checkbox').on('change', validateForm);
                    $('#select-all-komponen').on('click', function() {
                        $('.komponen-checkbox').prop('checked', true);
                        validateForm();
                    });
                    $('#deselect-all-komponen').on('click', function() {
                        $('.komponen-checkbox').prop('checked', false);
                        validateForm();
                    });
                } else {
                    komponenList.html(`
                        <div class="text-center text-muted py-3">
                            <i class="fas fa-exclamation-triangle"></i>
                            Tidak ada komponen untuk instrumen ini
                        </div>
                    `);
                }
            })
            .fail(function() {
                komponenList.html(`
                    <div class="text-center text-danger py-3">
                        <i class="fas fa-exclamation-circle"></i>
                        Gagal memuat komponen
                    </div>
                `);
            });
    }

    // Set deadline based on duration
    $('#set-deadline').on('click', function() {
        const duration = parseInt($('#duration').val());
        const deadline = new Date();
        deadline.setDate(deadline.getDate() + duration);
        $('#deadline').val(deadline.toISOString().split('T')[0]);
    });

    // Select all lembaga
    $('#select-all').on('click', function() {
        $('.lembaga-checkbox').prop('checked', true);
        updateSelectedCount();
        validateForm();
    });

    // Deselect all lembaga
    $('#deselect-all').on('click', function() {
        $('.lembaga-checkbox').prop('checked', false);
        updateSelectedCount();
        validateForm();
    });

    // Update selected count when checkbox changes
    $('.lembaga-checkbox').on('change', function() {
        updateSelectedCount();
        validateForm();
    });

    // Update selected count
    function updateSelectedCount() {
        const count = $('.lembaga-checkbox:checked').length;
        $('#selected-count').text(count);
    }

    // Validate form
    function validateForm() {
        const instrumenSelected = $('#instrumen_id').val() !== '';
        const lembagaSelected = $('.lembaga-checkbox:checked').length > 0;
        const deadlineSet = $('#deadline').val() !== '';
        
        // Check komponen selection if per_komponen is selected
        let komponenValid = true;
        if ($('#per_komponen').is(':checked')) {
            komponenValid = $('.komponen-checkbox:checked').length > 0;
        }
        
        $('#submit-btn').prop('disabled', !(instrumenSelected && lembagaSelected && deadlineSet && komponenValid));
    }

    // Initial validation
    validateForm();
    updateSelectedCount();

    // Validate on deadline change
    $('#deadline').on('change', validateForm);
});
</script>
@endpush

@push('styles')
<style>
.lembaga-card {
    border: 2px solid #e3e6f0;
    transition: all 0.3s ease;
}

.lembaga-card:hover {
    border-color: #5a5c69;
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(0,0,0,0.1);
}

.lembaga-checkbox:checked + label {
    color: #1cc88a !important;
}

.lembaga-card:has(.lembaga-checkbox:checked) {
    border-color: #1cc88a;
    background-color: #f8fff9;
}
</style>
@endpush