@extends('layouts.app')

@section('title', 'Dashboard Pengawas')

@section('breadcrumb')
<li class="breadcrumb-item active">Dashboard</li>
@endsection

@section('content')
<!-- Info boxes -->
<div class="row">
    <div class="col-12 col-sm-6 col-md-3">
        <div class="info-box">
            <span class="info-box-icon bg-info elevation-1"><i class="fas fa-school"></i></span>
            <div class="info-box-content">
                <span class="info-box-text">Lembaga Binaan</span>
                <span class="info-box-number">{{ Auth::user()->lembaga()->count() }}</span>
            </div>
        </div>
    </div>
    <div class="col-12 col-sm-6 col-md-3">
        <div class="info-box mb-3">
            <span class="info-box-icon bg-success elevation-1"><i class="fas fa-clipboard-list"></i></span>
            <div class="info-box-content">
                <span class="info-box-text">Instrumen Aktif</span>
                <span class="info-box-number">{{ \App\Models\Instrumen::where('is_active', true)->count() }}</span>
            </div>
        </div>
    </div>
    <div class="clearfix hidden-md-up"></div>
    <div class="col-12 col-sm-6 col-md-3">
        <div class="info-box mb-3">
            <span class="info-box-icon bg-warning elevation-1"><i class="fas fa-share-alt"></i></span>
            <div class="info-box-content">
                <span class="info-box-text">Distribusi Aktif</span>
                <span class="info-box-number">{{ \App\Models\DistribusiInstrumen::whereHas('lembaga', function($q) { $q->where('pengawas_id', Auth::id()); })->where('status', 'active')->count() }}</span>
            </div>
        </div>
    </div>
    <div class="col-12 col-sm-6 col-md-3">
        <div class="info-box mb-3">
            <span class="info-box-icon bg-danger elevation-1"><i class="fas fa-check-circle"></i></span>
            <div class="info-box-content">
                <span class="info-box-text">Menunggu Validasi</span>
                <span class="info-box-number">{{ \App\Models\PenilaianKepala::where('pengawas_id', Auth::id())->where('status', 'submitted')->count() }}</span>
            </div>
        </div>
    </div>
</div>

<!-- Main row -->
<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Lembaga Binaan</h3>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Nama Lembaga</th>
                                <th>Jenis</th>
                                <th>NPSN/NSM</th>
                                <th>Kepala</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse(Auth::user()->lembaga()->take(5)->get() as $lembaga)
                            <tr>
                                <td>{{ $lembaga->nama_lembaga }}</td>
                                <td><span class="badge badge-info">{{ $lembaga->jenis }}</span></td>
                                <td>{{ $lembaga->npsn_nsm }}</td>
                                <td>{{ $lembaga->nama_kepala }}</td>
                                <td><span class="badge badge-success">Aktif</span></td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="5" class="text-center">Belum ada lembaga binaan</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Instrumen Terbaru</h3>
            </div>
            <div class="card-body">
                <ul class="list-group list-group-flush">
                    @forelse(\App\Models\Instrumen::where('is_active', true)->latest()->take(3)->get() as $instrumen)
                    <li class="list-group-item d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="mb-1">{{ $instrumen->judul }}</h6>
                            <small class="text-muted">{{ $instrumen->tahun_ajaran }} - Semester {{ $instrumen->semester }}</small>
                        </div>
                        <span class="badge badge-{{ $instrumen->is_active ? 'success' : 'secondary' }}">
                            {{ $instrumen->is_active ? 'Aktif' : 'Nonaktif' }}
                        </span>
                    </li>
                    @empty
                    <li class="list-group-item text-center text-muted">Belum ada instrumen</li>
                    @endforelse
                </ul>
            </div>
        </div>
    </div>
</div>
@endsection