@extends('layouts.app')

@section('title', 'Profil Kepala Madrasah')

@section('content')
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">
                        <i class="fas fa-user"></i> Profil Kepala Madrasah
                    </h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('kepala.dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item active">Profil</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-4">
                    <!-- Profile Card -->
                    <div class="card card-primary card-outline">
                        <div class="card-body box-profile">
                            <div class="text-center">
                                @if($user->foto_profil)
                                    <img class="profile-user-img img-fluid img-circle" 
                                         src="{{ Storage::url($user->foto_profil) }}" 
                                         alt="Foto Profil">
                                @else
                                    <img class="profile-user-img img-fluid img-circle" 
                                         src="{{ asset('vendor/adminlte/dist/img/avatar5.png') }}" 
                                         alt="Foto Profil">
                                @endif
                            </div>

                            <h3 class="profile-username text-center">{{ $user->name }}</h3>
                            
                            @if($user->kepala)
                                <p class="text-muted text-center">{{ $user->kepala->nama_lengkap }}</p>
                                <p class="text-muted text-center">
                                    <i class="fas fa-envelope"></i> {{ $user->email }}
                                </p>
                                @if($user->phone)
                                    <p class="text-muted text-center">
                                        <i class="fas fa-phone"></i> {{ $user->phone }}
                                    </p>
                                @endif
                            @endif

                            <ul class="list-group list-group-unbordered mb-3">
                                <li class="list-group-item">
                                    <b>Role</b> <a class="float-right">
                                        <span class="badge badge-success">Kepala Madrasah</span>
                                    </a>
                                </li>
                                @if($user->kepala && $user->kepala->nip)
                                    <li class="list-group-item">
                                        <b>NIP</b> <a class="float-right">{{ $user->kepala->nip }}</a>
                                    </li>
                                @endif
                                @if($user->kepala && $user->kepala->nuptk)
                                    <li class="list-group-item">
                                        <b>NUPTK</b> <a class="float-right">{{ $user->kepala->nuptk }}</a>
                                    </li>
                                @endif
                            </ul>

                            <div class="row">
                                <div class="col-6">
                                    <a href="{{ route('kepala.profile.edit') }}" class="btn btn-primary btn-block">
                                        <i class="fas fa-edit"></i> Edit Profil
                                    </a>
                                </div>
                                <div class="col-6">
                                    <a href="{{ route('kepala.profile.edit-password') }}" class="btn btn-warning btn-block">
                                        <i class="fas fa-key"></i> Ubah Password
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-8">
                    <!-- Profile Details -->
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fas fa-info-circle"></i> Detail Profil
                            </h3>
                        </div>
                        <div class="card-body">
                            @if($user->kepala)
                                <div class="row">
                                    <div class="col-md-6">
                                        <strong><i class="fas fa-user"></i> Nama Lengkap</strong>
                                        <p class="text-muted">{{ $user->kepala->nama_lengkap }}</p>
                                    </div>
                                    <div class="col-md-6">
                                        <strong><i class="fas fa-calendar"></i> Tanggal Lahir</strong>
                                        <p class="text-muted">{{ $user->kepala->tanggal_lahir ? $user->kepala->tanggal_lahir->format('d/m/Y') : '-' }}</p>
                                    </div>
                                </div>
                                <hr>
                                <div class="row">
                                    <div class="col-md-6">
                                        <strong><i class="fas fa-map-marker-alt"></i> Tempat Lahir</strong>
                                        <p class="text-muted">{{ $user->kepala->tempat_lahir }}</p>
                                    </div>
                                    <div class="col-md-6">
                                        <strong><i class="fas fa-venus-mars"></i> Jenis Kelamin</strong>
                                        <p class="text-muted">{{ $user->kepala->jenis_kelamin == 'L' ? 'Laki-laki' : 'Perempuan' }}</p>
                                    </div>
                                </div>
                                <hr>
                                <div class="row">
                                    <div class="col-md-6">
                                        <strong><i class="fas fa-graduation-cap"></i> Pendidikan Terakhir</strong>
                                        <p class="text-muted">{{ $user->kepala->pendidikan_terakhir }}</p>
                                    </div>
                                    <div class="col-md-6">
                                        <strong><i class="fas fa-book"></i> Jurusan</strong>
                                        <p class="text-muted">{{ $user->kepala->jurusan ?: '-' }}</p>
                                    </div>
                                </div>
                                <hr>
                                <div class="row">
                                    <div class="col-12">
                                        <strong><i class="fas fa-home"></i> Alamat</strong>
                                        <p class="text-muted">{{ $user->kepala->alamat }}</p>
                                    </div>
                                </div>
                            @else
                                <div class="alert alert-warning">
                                    <h5><i class="fas fa-exclamation-triangle"></i> Profil Belum Lengkap</h5>
                                    <p>Silakan lengkapi profil Anda untuk mengakses fitur lengkap.</p>
                                    <a href="{{ route('kepala.profile.edit') }}" class="btn btn-warning">
                                        <i class="fas fa-edit"></i> Lengkapi Profil
                                    </a>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection
