@extends('layouts.app')

@section('title', 'Edit Profil Kepala Madrasah')

@section('content')
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">
                        <i class="fas fa-edit"></i> Edit Profil Kepala Madrasah
                    </h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('kepala.dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('kepala.profile.index') }}">Profil</a></li>
                        <li class="breadcrumb-item active">Edit</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fas fa-user-edit"></i> Form Edit Profil
                            </h3>
                        </div>
                        <form action="{{ route('kepala.profile.update') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            @method('PUT')
                            <div class="card-body">
                                <!-- Basic Information -->
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="name">Nama Pengguna <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control @error('name') is-invalid @enderror" 
                                                   id="name" name="name" value="{{ old('name', $user->name) }}" required>
                                            @error('name')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="email">Email <span class="text-danger">*</span></label>
                                            <input type="email" class="form-control @error('email') is-invalid @enderror" 
                                                   id="email" name="email" value="{{ old('email', $user->email) }}" required>
                                            @error('email')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="phone">No. Telepon</label>
                                            <input type="text" class="form-control @error('phone') is-invalid @enderror" 
                                                   id="phone" name="phone" value="{{ old('phone', $user->phone) }}">
                                            @error('phone')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="foto_profil">Foto Profil</label>
                                            <input type="file" class="form-control @error('foto_profil') is-invalid @enderror" 
                                                   id="foto_profil" name="foto_profil" accept="image/*">
                                            @error('foto_profil')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                            <small class="form-text text-muted">Format: JPEG, PNG, JPG, GIF, WEBP. Maksimal 5MB.</small>
                                        </div>
                                    </div>
                                </div>

                                <hr>

                                <!-- Professional Information -->
                                <h5><i class="fas fa-briefcase"></i> Informasi Profesional</h5>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="nip">NIP</label>
                                            <input type="text" class="form-control @error('nip') is-invalid @enderror" 
                                                   id="nip" name="nip" value="{{ old('nip', $user->kepala?->nip) }}">
                                            @error('nip')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="nuptk">NUPTK</label>
                                            <input type="text" class="form-control @error('nuptk') is-invalid @enderror" 
                                                   id="nuptk" name="nuptk" value="{{ old('nuptk', $user->kepala?->nuptk) }}">
                                            @error('nuptk')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="nama_lengkap">Nama Lengkap <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control @error('nama_lengkap') is-invalid @enderror" 
                                                   id="nama_lengkap" name="nama_lengkap" value="{{ old('nama_lengkap', $user->kepala?->nama_lengkap) }}" required>
                                            @error('nama_lengkap')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="gelar_depan">Gelar Depan</label>
                                            <input type="text" class="form-control @error('gelar_depan') is-invalid @enderror" 
                                                   id="gelar_depan" name="gelar_depan" value="{{ old('gelar_depan', $user->kepala?->gelar_depan) }}">
                                            @error('gelar_depan')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="gelar_belakang">Gelar Belakang</label>
                                            <input type="text" class="form-control @error('gelar_belakang') is-invalid @enderror" 
                                                   id="gelar_belakang" name="gelar_belakang" value="{{ old('gelar_belakang', $user->kepala?->gelar_belakang) }}">
                                            @error('gelar_belakang')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="pendidikan_terakhir">Pendidikan Terakhir <span class="text-danger">*</span></label>
                                            <select class="form-control @error('pendidikan_terakhir') is-invalid @enderror" 
                                                    id="pendidikan_terakhir" name="pendidikan_terakhir" required>
                                                <option value="">Pilih Pendidikan</option>
                                                <option value="SMA/SMK" {{ old('pendidikan_terakhir', $user->kepala?->pendidikan_terakhir) == 'SMA/SMK' ? 'selected' : '' }}>SMA/SMK</option>
                                                <option value="D1" {{ old('pendidikan_terakhir', $user->kepala?->pendidikan_terakhir) == 'D1' ? 'selected' : '' }}>D1</option>
                                                <option value="D2" {{ old('pendidikan_terakhir', $user->kepala?->pendidikan_terakhir) == 'D2' ? 'selected' : '' }}>D2</option>
                                                <option value="D3" {{ old('pendidikan_terakhir', $user->kepala?->pendidikan_terakhir) == 'D3' ? 'selected' : '' }}>D3</option>
                                                <option value="D4" {{ old('pendidikan_terakhir', $user->kepala?->pendidikan_terakhir) == 'D4' ? 'selected' : '' }}>D4</option>
                                                <option value="S1" {{ old('pendidikan_terakhir', $user->kepala?->pendidikan_terakhir) == 'S1' ? 'selected' : '' }}>S1</option>
                                                <option value="S2" {{ old('pendidikan_terakhir', $user->kepala?->pendidikan_terakhir) == 'S2' ? 'selected' : '' }}>S2</option>
                                                <option value="S3" {{ old('pendidikan_terakhir', $user->kepala?->pendidikan_terakhir) == 'S3' ? 'selected' : '' }}>S3</option>
                                            </select>
                                            @error('pendidikan_terakhir')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="jurusan">Jurusan</label>
                                            <input type="text" class="form-control @error('jurusan') is-invalid @enderror" 
                                                   id="jurusan" name="jurusan" value="{{ old('jurusan', $user->kepala?->jurusan) }}">
                                            @error('jurusan')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <hr>

                                <!-- Personal Information -->
                                <h5><i class="fas fa-user"></i> Informasi Pribadi</h5>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="tempat_lahir">Tempat Lahir <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control @error('tempat_lahir') is-invalid @enderror" 
                                                   id="tempat_lahir" name="tempat_lahir" value="{{ old('tempat_lahir', $user->kepala?->tempat_lahir) }}" required>
                                            @error('tempat_lahir')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="tanggal_lahir">Tanggal Lahir <span class="text-danger">*</span></label>
                                            <input type="date" class="form-control @error('tanggal_lahir') is-invalid @enderror" 
                                                   id="tanggal_lahir" name="tanggal_lahir" 
                                                   value="{{ old('tanggal_lahir', $user->kepala?->tanggal_lahir?->format('Y-m-d')) }}" required>
                                            @error('tanggal_lahir')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="jenis_kelamin">Jenis Kelamin <span class="text-danger">*</span></label>
                                            <select class="form-control @error('jenis_kelamin') is-invalid @enderror" 
                                                    id="jenis_kelamin" name="jenis_kelamin" required>
                                                <option value="">Pilih Jenis Kelamin</option>
                                                <option value="L" {{ old('jenis_kelamin', $user->kepala?->jenis_kelamin) == 'L' ? 'selected' : '' }}>Laki-laki</option>
                                                <option value="P" {{ old('jenis_kelamin', $user->kepala?->jenis_kelamin) == 'P' ? 'selected' : '' }}>Perempuan</option>
                                            </select>
                                            @error('jenis_kelamin')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="telepon">No. Telepon</label>
                                            <input type="text" class="form-control @error('telepon') is-invalid @enderror" 
                                                   id="telepon" name="telepon" value="{{ old('telepon', $user->kepala?->telepon) }}">
                                            @error('telepon')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-12">
                                        <div class="form-group">
                                            <label for="alamat">Alamat <span class="text-danger">*</span></label>
                                            <textarea class="form-control @error('alamat') is-invalid @enderror" 
                                                      id="alamat" name="alamat" rows="3" required>{{ old('alamat', $user->kepala?->alamat) }}</textarea>
                                            @error('alamat')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="card-footer">
                                <div class="row">
                                    <div class="col-md-6">
                                        <a href="{{ route('kepala.profile.index') }}" class="btn btn-secondary">
                                            <i class="fas fa-arrow-left"></i> Kembali
                                        </a>
                                    </div>
                                    <div class="col-md-6 text-right">
                                        <button type="submit" class="btn btn-primary">
                                            <i class="fas fa-save"></i> Simpan Perubahan
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>

                <div class="col-md-4">
                    <!-- Photo Preview -->
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fas fa-image"></i> Preview Foto
                            </h3>
                        </div>
                        <div class="card-body text-center">
                            @if($user->foto_profil)
                                <img id="photo-preview" class="img-fluid rounded" 
                                     src="{{ Storage::url($user->foto_profil) }}" 
                                     alt="Foto Profil" style="max-height: 200px;">
                            @else
                                <img id="photo-preview" class="img-fluid rounded" 
                                     src="{{ asset('vendor/adminlte/dist/img/avatar5.png') }}" 
                                     alt="Foto Profil" style="max-height: 200px;">
                            @endif
                            <p class="text-muted mt-2">Foto akan terupdate setelah disimpan</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const photoInput = document.getElementById('foto_profil');
    const photoPreview = document.getElementById('photo-preview');
    
    photoInput.addEventListener('change', function(e) {
        const file = e.target.files[0];
        if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
                photoPreview.src = e.target.result;
            };
            reader.readAsDataURL(file);
        }
    });
});
</script>
@endpush
