@extends('layouts.app')

@section('content')
<div class="container mx-auto px-4 py-6">
    <div class="flex items-center justify-between mb-4">
        <h1 class="text-xl font-semibold">Detail Penilaian #{{ $penilaian->id }}</h1>
        <div>
            @if(in_array($penilaian->status, ['validated', 'final']))
            <a href="{{ route('kepala.penilaian.raport', $penilaian->id) }}" class="btn btn-success" target="_blank" title="Download Raport PDF">
                <i class="fas fa-file-pdf"></i>
            </a>
            @endif
            <a href="{{ route('kepala.penilaian.index') }}" class="btn btn-secondary" title="Kembali ke Daftar Penilaian">
                <i class="fas fa-arrow-left"></i>
            </a>
        </div>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
        <div class="card">
            <div class="card-body">
                <div class="mb-2"><strong>Pengawas:</strong> {{ $penilaian->pengawas?->name ?? '-' }}</div>
                <div class="mb-2"><strong>Status:</strong> {{ ucfirst($penilaian->status) }}</div>
                <div class="mb-2"><strong>Tanggal Submit:</strong> {{ optional($penilaian->tanggal_submit)->format('d/m/Y H:i') ?? '-' }}</div>
                @if($penilaian->catatan_pengawas)
                    <div class="mt-2">
                        <strong>Catatan Pengawas:</strong>
                        <p class="mb-0">{{ $penilaian->catatan_pengawas }}</p>
                    </div>
                @endif
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-body p-0 overflow-x-auto">
            <table class="table w-full">
                <thead>
                    <tr>
                        <th>Item</th>
                        <th>Nilai Pengawas</th>
                        <th>Catatan</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($penilaian->jawabanKepala as $j)
                        <tr>
                            <td>{{ $j->instrumenItem?->indikator_kinerja ?? 'Item #' . $j->instrumen_item_id }}</td>
                            <td>{{ $j->nilai_pengawas ?? '-' }}</td>
                            <td>{{ $j->catatan_pengawas ?? '-' }}</td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="3" class="text-center py-6">Belum ada jawaban.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection


