@extends('layouts.app')

@section('content')
<div class="container mx-auto px-4 py-6">
    <h1 class="text-xl font-semibold mb-4">Penilaian Saya</h1>

    <div class="card">
        <div class="card-body p-0 overflow-x-auto">
            <table class="table w-full">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Pengawas</th>
                        <th>Status</th>
                        <th>Tanggal Submit</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($items as $item)
                        <tr>
                            <td>{{ $item->id }}</td>
                            <td>{{ $item->pengawas?->name ?? '-' }}</td>
                            <td>{{ ucfirst($item->status) }}</td>
                            <td>{{ optional($item->tanggal_submit)->format('d/m/Y H:i') ?? '-' }}</td>
                            <td>
                                <div class="btn-group" role="group">
                                    <a href="{{ route('kepala.penilaian.show', $item->id) }}" class="btn btn-sm btn-primary" title="Lihat Detail Penilaian">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    @if(in_array($item->status, ['validated', 'final']))
                                    <a href="{{ route('kepala.penilaian.raport', $item->id) }}" class="btn btn-sm btn-success" target="_blank" title="Download Raport PDF">
                                        <i class="fas fa-file-pdf"></i>
                                    </a>
                                    @endif
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="text-center py-6">Belum ada penilaian.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <div class="mt-4">
        {{ $items->links() }}
    </div>
</div>
@endsection


