@extends('layouts.app')

@section('title', 'Review Penilaian Guru')

@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{ route('kepala.penilaian.index') }}">Penilaian</a></li>
<li class="breadcrumb-item"><a href="{{ route('kepala.penilaian.review') }}">Review</a></li>
<li class="breadcrumb-item active">Detail</li>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-edit"></i> Review Penilaian Guru
                    </h3>
                    <div class="card-tools">
                        @if($penilaianGuru->status == 'validated' || $penilaianGuru->status == 'final')
                            <a href="{{ route('kepala.penilaian.raport', $penilaianGuru->id) }}" class="btn btn-success btn-sm mr-2">
                                <i class="fas fa-file-pdf"></i> Download Raport PDF
                            </a>
                        @endif
                        <a href="{{ route('kepala.penilaian.review') }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left"></i> Kembali
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            {{ session('success') }}
                        </div>
                    @endif

                    @if(session('error'))
                        <div class="alert alert-danger alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            {{ session('error') }}
                        </div>
                    @endif

                    <!-- Guru Information -->
                    <div class="row mb-4">
                        <div class="col-md-8">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">
                                        <i class="fas fa-user"></i> Informasi Guru
                                    </h4>
                                </div>
                                <div class="card-body">
                                    <dl class="row">
                                        <dt class="col-sm-3">Nama Lengkap:</dt>
                                        <dd class="col-sm-9">
                                            <strong>{{ $penilaianGuru->guru->nama_lengkap }}</strong>
                                            @if($penilaianGuru->guru->gelar_depan || $penilaianGuru->guru->gelar_belakang)
                                                <br><small class="text-muted">{{ $penilaianGuru->guru->gelar_depan }} {{ $penilaianGuru->guru->nama_lengkap }}{{ $penilaianGuru->guru->gelar_belakang ? ', ' . $penilaianGuru->guru->gelar_belakang : '' }}</small>
                                            @endif
                                        </dd>

                                        <dt class="col-sm-3">NIP:</dt>
                                        <dd class="col-sm-9">{{ $penilaianGuru->guru->nip ?? '-' }}</dd>

                                        <dt class="col-sm-3">Mata Pelajaran:</dt>
                                        <dd class="col-sm-9">{{ $penilaianGuru->guru->mata_pelajaran ?? '-' }}</dd>

                                        <dt class="col-sm-3">Instrumen:</dt>
                                        <dd class="col-sm-9">
                                            <strong>{{ $penilaianGuru->distribusiInstrumen->instrumen->judul }}</strong>
                                            @if($penilaianGuru->distribusiInstrumen->komponen)
                                                <br><small class="text-muted">{{ $penilaianGuru->distribusiInstrumen->komponen->nama_komponen }}</small>
                                            @endif
                                        </dd>

                                        <dt class="col-sm-3">Tanggal Submit:</dt>
                                        <dd class="col-sm-9">
                                            @if($penilaianGuru->tanggal_submit)
                                                {{ $penilaianGuru->tanggal_submit->format('d F Y H:i') }}
                                                <br><small class="text-muted">{{ $penilaianGuru->tanggal_submit->diffForHumans() }}</small>
                                            @else
                                                <span class="text-muted">-</span>
                                            @endif
                                        </dd>

                                        <dt class="col-sm-3">Status:</dt>
                                        <dd class="col-sm-9">
                                            @switch($penilaianGuru->status)
                                                @case('submitted')
                                                    <span class="badge badge-warning">
                                                        <i class="fas fa-paper-plane"></i> Menunggu Review
                                                    </span>
                                                    @break
                                                @case('validated')
                                                    <span class="badge badge-success">
                                                        <i class="fas fa-check-circle"></i> Validated
                                                    </span>
                                                    @break
                                                @case('revision')
                                                    <span class="badge badge-info">
                                                        <i class="fas fa-edit"></i> Perlu Revisi
                                                    </span>
                                                    @break
                                            @endswitch
                                        </dd>
                                    </dl>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">
                                        <i class="fas fa-chart-bar"></i> Statistik Penilaian
                                    </h4>
                                </div>
                                <div class="card-body">
                                    <div class="row text-center">
                                        <div class="col-6">
                                            <div class="border-right">
                                                <h3 class="text-primary">{{ $jawabanGuru->count() }}</h3>
                                                <small class="text-muted">Total Item</small>
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <h3 class="text-success">
                                                @if($penilaianGuru->rata_rata)
                                                    {{ number_format($penilaianGuru->rata_rata, 2) }}
                                                @else
                                                    -
                                                @endif
                                            </h3>
                                            <small class="text-muted">Rata-rata</small>
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="row">
                                        <div class="col-12">
                                            <small class="text-muted">
                                                <i class="fas fa-calculator text-info"></i> Total Nilai: 
                                                <strong>{{ $penilaianGuru->total_nilai ?? 0 }}</strong>
                                            </small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Review Form -->
                    @if($penilaianGuru->status == 'submitted')
                        <form action="{{ route('kepala.penilaian.update', $penilaianGuru->id) }}" method="POST">
                            @csrf
                            @method('PUT')
                            
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">
                                        <i class="fas fa-edit"></i> Form Review Penilaian
                                    </h4>
                                </div>
                                <div class="card-body">
                                    @foreach($jawabanGuru as $jawaban)
                                        @if($jawaban->instrumenItem)
                                        <div class="form-group">
                                            <div class="row">
                                                <div class="col-md-8">
                                                    <label class="font-weight-bold">
                                                        {{ $jawaban->instrumenItem->no_urutan }}. {{ $jawaban->instrumenItem->indikator_kinerja }}
                                                    </label>
                                                    
                                                    @if($jawaban->instrumenItem->evidensi_kinerja)
                                                        <p class="text-muted small">{{ $jawaban->instrumenItem->evidensi_kinerja }}</p>
                                                    @endif

                                                    <!-- Jawaban Guru -->
                                                    <div class="alert alert-light">
                                                        <strong>Jawaban Guru:</strong>
                                                        @if($jawaban->keterangan_bukti)
                                                            <p class="mb-1">
                                                                <strong>Keterangan Bukti:</strong> {{ $jawaban->keterangan_bukti }}
                                                            </p>
                                                        @else
                                                            <p class="mb-1 text-muted">Guru belum memberikan keterangan bukti</p>
                                                        @endif
                                                        @if($jawaban->url_bukti)
                                                            <p class="mb-1">
                                                                <strong>URL Bukti:</strong> 
                                                                <a href="{{ $jawaban->url_bukti }}" target="_blank" class="btn btn-sm btn-primary">
                                                                    <i class="fas fa-external-link-alt"></i> Lihat Bukti
                                                                </a>
                                                            </p>
                                                        @endif
                                                    </div>
                                                </div>
                                                <div class="col-md-4">
                                                    <label for="jawaban_{{ $jawaban->id }}_nilai_kepala">Nilai Kepala Madrasah</label>
                                                    <select name="jawaban[{{ $jawaban->id }}][nilai_kepala]" 
                                                            id="jawaban_{{ $jawaban->id }}_nilai_kepala" 
                                                            class="form-control @error('jawaban.'.$jawaban->id.'.nilai_kepala') is-invalid @enderror" required>
                                                        <option value="">Pilih Nilai</option>
                                                        @for($i = $jawaban->instrumenItem->skor_min; $i <= $jawaban->instrumenItem->skor_max; $i++)
                                                            @php
                                                                $skorLabels = [
                                                                    1 => 'Sangat Kurang',
                                                                    2 => 'Kurang', 
                                                                    3 => 'Cukup',
                                                                    4 => 'Baik',
                                                                    5 => 'Sangat Baik'
                                                                ];
                                                                $label = $skorLabels[$i] ?? "Skor $i";
                                                            @endphp
                                                            <option value="{{ $i }}" {{ old('jawaban.'.$jawaban->id.'.nilai_kepala', $jawaban->nilai_kepala) == $i ? 'selected' : '' }}>
                                                                {{ $i }} - {{ $label }}
                                                            </option>
                                                        @endfor
                                                    </select>
                                                    @error('jawaban.'.$jawaban->id.'.nilai_kepala')
                                                        <div class="invalid-feedback">{{ $message }}</div>
                                                    @enderror

                                                    <label for="jawaban_{{ $jawaban->id }}_catatan_kepala" class="mt-2">Catatan</label>
                                                    <textarea name="jawaban[{{ $jawaban->id }}][catatan_kepala]" 
                                                              id="jawaban_{{ $jawaban->id }}_catatan_kepala" 
                                                              class="form-control @error('jawaban.'.$jawaban->id.'.catatan_kepala') is-invalid @enderror" 
                                                              rows="3" 
                                                              placeholder="Berikan catatan atau saran...">{{ old('jawaban.'.$jawaban->id.'.catatan_kepala', $jawaban->catatan_kepala) }}</textarea>
                                                    @error('jawaban.'.$jawaban->id.'.catatan_kepala')
                                                        <div class="invalid-feedback">{{ $message }}</div>
                                                    @enderror
                                                </div>
                                            </div>
                                        </div>
                                        <hr>
                                        @else
                                        <!-- Instrumen Item tidak ditemukan -->
                                        <div class="form-group">
                                            <div class="alert alert-warning">
                                                <strong>Peringatan:</strong> Instrumen item dengan ID {{ $jawaban->instrumen_item_id }} tidak ditemukan dalam database. 
                                                Jawaban guru ID: {{ $jawaban->id }}
                                            </div>
                                        </div>
                                        <hr>
                                        @endif
                                    @endforeach

                                    <!-- Catatan Umum -->
                                    <div class="form-group">
                                        <label for="catatan_kepala">Catatan Umum</label>
                                        <textarea name="catatan_kepala" 
                                                  id="catatan_kepala" 
                                                  class="form-control @error('catatan_kepala') is-invalid @enderror" 
                                                  rows="4" 
                                                  placeholder="Berikan catatan umum untuk penilaian ini...">{{ old('catatan_kepala', $penilaianGuru->catatan_kepala) }}</textarea>
                                        @error('catatan_kepala')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <!-- Status Decision -->
                                    <div class="form-group">
                                        <label>Keputusan Review</label>
                                        <div class="form-check">
                                            <input class="form-check-input" type="radio" name="status" id="status_validated" value="validated" {{ old('status', $penilaianGuru->status) == 'validated' ? 'checked' : '' }}>
                                            <label class="form-check-label text-success" for="status_validated">
                                                <i class="fas fa-check-circle"></i> Setujui Penilaian
                                            </label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="radio" name="status" id="status_revision" value="revision" {{ old('status', $penilaianGuru->status) == 'revision' ? 'checked' : '' }}>
                                            <label class="form-check-label text-warning" for="status_revision">
                                                <i class="fas fa-edit"></i> Perlu Revisi
                                            </label>
                                        </div>
                                        @error('status')
                                            <div class="invalid-feedback d-block">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <div class="d-flex justify-content-between">
                                        <a href="{{ route('kepala.penilaian.review') }}" class="btn btn-secondary">
                                            <i class="fas fa-arrow-left"></i> Batal
                                        </a>
                                        <button type="submit" class="btn btn-primary">
                                            <i class="fas fa-save"></i> Simpan Review
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    @else
                        <!-- View Only Mode -->
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">
                                    <i class="fas fa-eye"></i> Detail Penilaian
                                </h4>
                            </div>
                            <div class="card-body">
                                @foreach($jawabanGuru as $jawaban)
                                    @if($jawaban->instrumenItem)
                                    <div class="form-group">
                                        <div class="row">
                                            <div class="col-md-8">
                                                <label class="font-weight-bold">
                                                    {{ $jawaban->instrumenItem->no_urutan }}. {{ $jawaban->instrumenItem->indikator_kinerja }}
                                                </label>
                                                
                                                @if($jawaban->instrumenItem->evidensi_kinerja)
                                                    <p class="text-muted small">{{ $jawaban->instrumenItem->evidensi_kinerja }}</p>
                                                @endif

                                                <!-- Jawaban Guru -->
                                                <div class="alert alert-light">
                                                    <strong>Jawaban Guru:</strong>
                                                    @if($jawaban->keterangan_bukti)
                                                        <p class="mb-1">
                                                            <strong>Keterangan Bukti:</strong> {{ $jawaban->keterangan_bukti }}
                                                        </p>
                                                    @else
                                                        <p class="mb-1 text-muted">Guru belum memberikan keterangan bukti</p>
                                                    @endif
                                                    @if($jawaban->url_bukti)
                                                        <p class="mb-1">
                                                            <strong>URL Bukti:</strong> 
                                                            <a href="{{ $jawaban->url_bukti }}" target="_blank" class="btn btn-sm btn-primary">
                                                                <i class="fas fa-external-link-alt"></i> Lihat Bukti
                                                            </a>
                                                        </p>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="alert alert-info">
                                                    <strong>Nilai Kepala Madrasah:</strong>
                                                    <h4 class="text-primary">{{ $jawaban->nilai_kepala ?? '-' }}</h4>
                                                    @if($jawaban->catatan_kepala)
                                                        <p class="mb-0"><strong>Catatan:</strong> {{ $jawaban->catatan_kepala }}</p>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <hr>
                                    @else
                                    <!-- Instrumen Item tidak ditemukan -->
                                    <div class="form-group">
                                        <div class="alert alert-warning">
                                            <strong>Peringatan:</strong> Instrumen item dengan ID {{ $jawaban->instrumen_item_id }} tidak ditemukan dalam database. 
                                            Jawaban guru ID: {{ $jawaban->id }}
                                        </div>
                                    </div>
                                    <hr>
                                    @endif
                                @endforeach

                                @if($penilaianGuru->catatan_kepala)
                                    <div class="alert alert-info">
                                        <strong>Catatan Umum:</strong>
                                        <p class="mb-0">{{ $penilaianGuru->catatan_kepala }}</p>
                                    </div>
                                @endif
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Auto-hide success/error alerts after 5 seconds (not all alerts)
    setTimeout(function() {
        $('.alert-success, .alert-danger').fadeOut('slow');
    }, 5000);

    // Form validation
    $('form').on('submit', function(e) {
        var allFilled = true;
        $('select[name*="[nilai_kepala]"]').each(function() {
            if (!$(this).val()) {
                allFilled = false;
                $(this).addClass('is-invalid');
            } else {
                $(this).removeClass('is-invalid');
            }
        });

        if (!allFilled) {
            e.preventDefault();
            alert('Mohon isi semua nilai penilaian sebelum menyimpan.');
            return false;
        }
    });
});
</script>
@endpush
