@extends('layouts.app')

@section('title', 'Review Penilaian')

@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{ route('kepala.penilaian.index') }}">Penilaian</a></li>
<li class="breadcrumb-item active">Review</li>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-eye"></i> Review Penilaian Guru
                    </h3>
                    <div class="card-tools">
                        <a href="{{ route('kepala.penilaian.index') }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left"></i> Kembali
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            {{ session('success') }}
                        </div>
                    @endif

                    @if(session('error'))
                        <div class="alert alert-danger alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            {{ session('error') }}
                        </div>
                    @endif

                    <!-- Statistics Cards -->
                    <div class="row mb-4">
                        <div class="col-lg-6 col-6">
                            <div class="small-box bg-warning">
                                <div class="inner">
                                    <h3>{{ $stats['pending_review'] }}</h3>
                                    <p>Menunggu Review</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-paper-plane"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6 col-6">
                            <div class="small-box bg-success">
                                <div class="inner">
                                    <h3>{{ $stats['total_reviewed'] }}</h3>
                                    <p>Sudah Direview</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-check-circle"></i>
                                </div>
                            </div>
                        </div>
                    </div>

                    @if($penilaianGuru->count() > 0)
                        <!-- Review Table -->
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th width="5%">No</th>
                                        <th>Nama Guru</th>
                                        <th>NIP</th>
                                        <th>Instrumen</th>
                                        <th>Tanggal Submit</th>
                                        <th>Status</th>
                                        <th width="15%">Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($penilaianGuru as $penilaian)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>
                                            <strong>{{ $penilaian->guru->nama_lengkap }}</strong>
                                            @if($penilaian->guru->gelar_depan || $penilaian->guru->gelar_belakang)
                                                <br><small class="text-muted">{{ $penilaian->guru->gelar_depan }} {{ $penilaian->guru->nama_lengkap }}{{ $penilaian->guru->gelar_belakang ? ', ' . $penilaian->guru->gelar_belakang : '' }}</small>
                                            @endif
                                        </td>
                                        <td>{{ $penilaian->guru->nip ?? '-' }}</td>
                                        <td>
                                            <strong>{{ $penilaian->distribusiInstrumen->instrumen->judul }}</strong>
                                            @if($penilaian->distribusiInstrumen->komponen)
                                                <br><small class="text-muted">{{ $penilaian->distribusiInstrumen->komponen->nama_komponen }}</small>
                                            @endif
                                        </td>
                                        <td>
                                            @if($penilaian->tanggal_submit)
                                                {{ $penilaian->tanggal_submit->format('d/m/Y H:i') }}
                                                <br><small class="text-muted">{{ $penilaian->tanggal_submit->diffForHumans() }}</small>
                                            @else
                                                <span class="text-muted">-</span>
                                            @endif
                                        </td>
                                        <td>
                                            <span class="badge badge-warning">
                                                <i class="fas fa-paper-plane"></i> Menunggu Review
                                            </span>
                                            <br><small class="text-muted">Siap untuk direview</small>
                                        </td>
                                        <td>
                                            <a href="{{ route('kepala.penilaian.show', $penilaian->id) }}" class="btn btn-primary btn-sm" title="Review Penilaian">
                                                <i class="fas fa-edit"></i> Review
                                            </a>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <!-- Pagination -->
                        @if($penilaianGuru->hasPages())
                            <div class="d-flex justify-content-center">
                                {{ $penilaianGuru->links() }}
                            </div>
                        @endif
                    @else
                        <!-- Empty State -->
                        <div class="text-center py-5">
                            <i class="fas fa-check-circle fa-4x text-success mb-3"></i>
                            <h4 class="text-success">Tidak Ada Penilaian yang Menunggu Review</h4>
                            <p class="text-muted">Semua penilaian guru sudah direview atau belum ada yang submit.</p>
                            <a href="{{ route('kepala.penilaian.index') }}" class="btn btn-primary">
                                <i class="fas fa-arrow-left"></i> Kembali ke Daftar Penilaian
                            </a>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Auto-hide alerts after 5 seconds
    setTimeout(function() {
        $('.alert').fadeOut('slow');
    }, 5000);
});
</script>
@endpush
