@extends('layouts.app')

@section('title', 'Penilaian Guru')

@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{ route('kepala.penilaian.index') }}">Penilaian</a></li>
<li class="breadcrumb-item active">Daftar</li>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-star"></i> Penilaian Guru
                    </h3>
                    <div class="card-tools">
                        <a href="{{ route('kepala.penilaian.review') }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-eye"></i> Review Penilaian
                            @if($stats['submitted'] > 0)
                                <span class="badge badge-light ml-1">{{ $stats['submitted'] }}</span>
                            @endif
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            {{ session('success') }}
                        </div>
                    @endif

                    @if(session('error'))
                        <div class="alert alert-danger alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            {{ session('error') }}
                        </div>
                    @endif

                    <!-- Statistics Cards -->
                    <div class="row mb-4">
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-info">
                                <div class="inner">
                                    <h3>{{ $stats['total_penilaian'] }}</h3>
                                    <p>Total Penilaian</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-clipboard-list"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-warning">
                                <div class="inner">
                                    <h3>{{ $stats['submitted'] }}</h3>
                                    <p>Menunggu Review</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-paper-plane"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-success">
                                <div class="inner">
                                    <h3>{{ $stats['validated'] }}</h3>
                                    <p>Sudah Disetujui</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-check-circle"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-secondary">
                                <div class="inner">
                                    <h3>{{ $stats['revision'] }}</h3>
                                    <p>Perlu Revisi</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-edit"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-primary">
                                <div class="inner">
                                    <h3>{{ $stats['final'] }}</h3>
                                    <p>Sudah Final</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-flag-checkered"></i>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Penilaian Table -->
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th width="5%">No</th>
                                    <th>Nama Guru</th>
                                    <th>NIP</th>
                                    <th>Instrumen</th>
                                    <th>Status</th>
                                    <th>Tanggal Submit</th>
                                    <th>Nilai</th>
                                    <th width="15%">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($penilaianGuru as $penilaian)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>
                                        <strong>{{ $penilaian->guru->nama_lengkap }}</strong>
                                        @if($penilaian->guru->gelar_depan || $penilaian->guru->gelar_belakang)
                                            <br><small class="text-muted">{{ $penilaian->guru->gelar_depan }} {{ $penilaian->guru->nama_lengkap }}{{ $penilaian->guru->gelar_belakang ? ', ' . $penilaian->guru->gelar_belakang : '' }}</small>
                                        @endif
                                    </td>
                                    <td>{{ $penilaian->guru->nip ?? '-' }}</td>
                                    <td>
                                        <strong>{{ $penilaian->distribusiInstrumen->instrumen->judul }}</strong>
                                        @if($penilaian->distribusiInstrumen->komponen)
                                            <br><small class="text-muted">{{ $penilaian->distribusiInstrumen->komponen->nama_komponen }}</small>
                                        @endif
                                    </td>
                                    <td>
                                        @switch($penilaian->status)
                                            @case('draft')
                                                <span class="badge badge-secondary">
                                                    <i class="fas fa-clock"></i> Draft
                                                </span>
                                                <br><small class="text-muted">Guru belum submit</small>
                                                @break
                                            @case('submitted')
                                                <span class="badge badge-warning">
                                                    <i class="fas fa-paper-plane"></i> Menunggu Review
                                                </span>
                                                <br><small class="text-muted">Siap untuk direview</small>
                                                @break
                                            @case('revision')
                                                <span class="badge badge-info">
                                                    <i class="fas fa-edit"></i> Perlu Revisi
                                                </span>
                                                <br><small class="text-muted">Guru perlu memperbaiki</small>
                                                @break
                                            @case('validated')
                                                <span class="badge badge-success">
                                                    <i class="fas fa-check-circle"></i> Validated
                                                </span>
                                                <br><small class="text-muted">Sudah disetujui</small>
                                                @break
                                            @case('final')
                                                <span class="badge badge-primary">
                                                    <i class="fas fa-flag-checkered"></i> Final
                                                </span>
                                                <br><small class="text-muted">Sudah disubmit ke pengawas</small>
                                                @break
                                        @endswitch
                                    </td>
                                    <td>
                                        @if($penilaian->tanggal_submit)
                                            {{ $penilaian->tanggal_submit->format('d/m/Y H:i') }}
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($penilaian->rata_rata)
                                            <strong class="text-success">{{ number_format($penilaian->rata_rata, 2) }}</strong>
                                            <br><small class="text-muted">Total: {{ $penilaian->total_nilai }}</small>
                                        @else
                                            <span class="text-muted">Belum dinilai</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($penilaian->status == 'submitted')
                                            <a href="{{ route('kepala.penilaian.show', $penilaian->id) }}" class="btn btn-primary btn-sm" title="Review Penilaian">
                                                <i class="fas fa-edit"></i> Review
                                            </a>
                                        @elseif($penilaian->status == 'draft')
                                            <span class="text-muted">Menunggu guru</span>
                                        @else
                                            <div class="btn-group" role="group">
                                                <a href="{{ route('kepala.penilaian.show', $penilaian->id) }}" class="btn btn-info btn-sm" title="Lihat Detail">
                                                    <i class="fas fa-eye"></i> Lihat
                                                </a>
                                                @if($penilaian->status == 'validated' || $penilaian->status == 'final')
                                                    <a href="{{ route('kepala.penilaian.raport', $penilaian->id) }}" class="btn btn-success btn-sm" title="Download Raport PDF">
                                                        <i class="fas fa-file-pdf"></i> PDF
                                                    </a>
                                                @endif
                                            </div>
                                        @endif
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="8" class="text-center">
                                        <div class="py-4">
                                            <i class="fas fa-clipboard-list fa-3x text-muted mb-3"></i>
                                            <h5 class="text-muted">Belum ada data penilaian guru</h5>
                                            <p class="text-muted">Guru belum mulai mengisi instrumen penilaian.</p>
                                        </div>
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    @if($penilaianGuru->hasPages())
                        <div class="d-flex justify-content-center">
                            {{ $penilaianGuru->links() }}
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Auto-hide alerts after 5 seconds
    setTimeout(function() {
        $('.alert').fadeOut('slow');
    }, 5000);
});
</script>
@endpush
