<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Profil Lembaga</title>
    <style>
        body {
            font-family: 'Times New Roman', serif;
            font-size: 11px;
            line-height: 1.4;
            margin: 0;
            padding: 15px;
            color: #000;
        }
        
        .header {
            text-align: center;
            margin-bottom: 15px;
            border-bottom: 2px solid #000;
            padding-bottom: 8px;
        }
        
        .header h1 {
            font-size: 16px;
            font-weight: bold;
            margin: 5px 0 3px 0;
            text-transform: uppercase;
        }
        
        .header h2 {
            font-size: 12px;
            font-weight: bold;
            margin: 3px 0;
        }
        
        .header p {
            margin: 3px 0;
            font-size: 10px;
        }
        
        .logo-container {
            text-align: center;
            margin-bottom: 8px;
        }
        
        .logo-container img {
            max-height: 60px;
            max-width: 200px;
        }
        
        .content-section {
            margin-bottom: 12px;
        }
        
        .content-section h3 {
            font-size: 12px;
            font-weight: bold;
            margin: 8px 0 5px 0;
            text-decoration: underline;
            border-bottom: 1px solid #000;
            padding-bottom: 3px;
        }
        
        .info-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 8px;
        }
        
        .info-table td {
            padding: 3px 8px;
            vertical-align: top;
        }
        
        .info-table td:first-child {
            width: 35%;
            font-weight: bold;
        }
        
        .info-table td:last-child {
            width: 65%;
        }
        
        .footer {
            margin-top: 20px;
            text-align: center;
            font-size: 10px;
            color: #666;
            border-top: 1px solid #ddd;
            padding-top: 5px;
        }
        
        .signature-section {
            margin-top: 25px;
            text-align: center;
        }
        
        .signature-line {
            width: 200px;
            height: 1px;
            border-top: 1px solid #000;
            margin: 30px auto 3px auto;
        }
        
        .signature-section p {
            margin: 3px 0;
            font-size: 11px;
        }
    </style>
</head>
<body>
    <!-- Header -->
    <div class="header">
        @if(isset($logoBase64) && $logoBase64)
        <div class="logo-container">
            <img src="{{ $logoBase64 }}" alt="Logo Lembaga" style="max-height: 60px; max-width: 200px;">
        </div>
        @endif
        <h1>{{ $lembaga->nama_lembaga }}</h1>
        <h2>PROFIL LEMBAGA</h2>
        <p style="margin: 3px 0; font-size: 10px;">Dicetak pada: {{ $tanggal }}</p>
    </div>

    <!-- Identitas Lembaga -->
    <div class="content-section">
        <h3>I. IDENTITAS LEMBAGA</h3>
        <table class="info-table">
            <tr>
                <td>Nama Lembaga</td>
                <td>: {{ $lembaga->nama_lembaga }}</td>
            </tr>
            <tr>
                <td>NSM</td>
                <td>: {{ $lembaga->npsn_nsm }}</td>
            </tr>
            <tr>
                <td>Jenis</td>
                <td>: {{ $lembaga->jenis }}</td>
            </tr>
            <tr>
                <td>Akreditasi</td>
                <td>: {{ $lembaga->akreditasi ?: '-' }}</td>
            </tr>
            <tr>
                <td>Tahun Berdiri</td>
                <td>: {{ $lembaga->tahun_berdiri ?: '-' }}</td>
            </tr>
        </table>
    </div>

    <!-- Alamat -->
    <div class="content-section">
        <h3>II. ALAMAT LEMBAGA</h3>
        <table class="info-table">
            <tr>
                <td>Alamat Lengkap</td>
                <td>: {{ $lembaga->alamat_lengkap }}</td>
            </tr>
            <tr>
                <td>Kelurahan</td>
                <td>: {{ $lembaga->kelurahan_name ?? $lembaga->kelurahan }}</td>
            </tr>
            <tr>
                <td>Kecamatan</td>
                <td>: {{ $lembaga->kecamatan_name ?? $lembaga->kecamatan }}</td>
            </tr>
            <tr>
                <td>Kabupaten</td>
                <td>: {{ $kabupaten }}</td>
            </tr>
            <tr>
                <td>Provinsi</td>
                <td>: {{ $lembaga->provinsi_name ?? $lembaga->provinsi }}</td>
            </tr>
            <tr>
                <td>Kode Pos</td>
                <td>: {{ $lembaga->kode_pos ?: '-' }}</td>
            </tr>
        </table>
    </div>

    <!-- Kontak -->
    <div class="content-section">
        <h3>III. KONTAK</h3>
        <table class="info-table">
            <tr>
                <td>Telepon</td>
                <td>: {{ $lembaga->telepon ?: '-' }}</td>
            </tr>
            <tr>
                <td>Email</td>
                <td>: {{ $lembaga->email ?: '-' }}</td>
            </tr>
            <tr>
                <td>Website</td>
                <td>: {{ $lembaga->website ?: '-' }}</td>
            </tr>
        </table>
    </div>

    <!-- Kepala Lembaga -->
    <div class="content-section">
        <h3>IV. KEPALA LEMBAGA</h3>
        <table class="info-table">
            <tr>
                <td>Nama Kepala</td>
                <td>: {{ $lembaga->kepala->name ?? $lembaga->nama_kepala ?? '-' }}</td>
            </tr>
            <tr>
                <td>NIP</td>
                <td>: {{ $lembaga->kepala->nip ?? $lembaga->nip_kepala ?? '-' }}</td>
            </tr>
        </table>
    </div>

    <!-- Pengawas -->
    @if($lembaga->pengawas)
    <div class="content-section">
        <h3>V. PENGAWAS</h3>
        <table class="info-table">
            <tr>
                <td>Nama Pengawas</td>
                <td>: {{ $lembaga->pengawas->name }}</td>
            </tr>
            <tr>
                <td>Email</td>
                <td>: {{ $lembaga->pengawas->email }}</td>
            </tr>
        </table>
    </div>
    @endif

    <!-- Footer -->
    <div class="footer">
        <p>{{ $kabupaten }}, {{ $tanggal }}</p>
    </div>

    <!-- Signature -->
    <div class="signature-section">
        <div class="signature-line"></div>
        <p><strong>{{ $lembaga->kepala->name ?? $lembaga->nama_kepala ?? 'Kepala Lembaga' }}</strong></p>
        <p>Kepala {{ $lembaga->nama_lembaga }}</p>
    </div>
</body>
</html>

