@extends('layouts.app')

@section('title', 'Informasi Lembaga')

@section('breadcrumb')
<li class="breadcrumb-item active">Lembaga Saya</li>
@endsection

@section('content')
<div class="row">
    <!-- Info Cards -->
    <div class="col-md-4">
        <div class="info-box bg-info">
            <span class="info-box-icon"><i class="fas fa-school"></i></span>
            <div class="info-box-content">
                <span class="info-box-text">Nama Lembaga</span>
                <span class="info-box-number">{{ Str::limit($lembaga->nama_lembaga, 15) }}</span>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="info-box bg-success">
            <span class="info-box-icon"><i class="fas fa-users"></i></span>
            <div class="info-box-content">
                <span class="info-box-text">Total Guru</span>
                <span class="info-box-number">{{ $lembaga->guru()->count() }}</span>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="info-box bg-warning">
            <span class="info-box-icon"><i class="fas fa-user-tie"></i></span>
            <div class="info-box-content">
                <span class="info-box-text">Pengawas</span>
                <span class="info-box-number">{{ $lembaga->pengawas ? Str::limit($lembaga->pengawas->name, 10) : 'Belum ada' }}</span>
            </div>
        </div>
    </div>
</div>

<div class="row mt-4">
    <!-- Lembaga Information -->
    <div class="col-md-8">
        <div class="card card-primary card-outline">
            <div class="card-header">
                <h3 class="card-title">
                    <i class="fas fa-info-circle"></i> Informasi Lembaga
                </h3>
                <div class="card-tools">
                    <a href="{{ route('kepala.lembaga.download-cover-raport') }}" class="btn btn-info btn-sm" target="_blank" title="Download Cover Raport PDF">
                        <i class="fas fa-file-alt"></i>
                    </a>
                    <a href="{{ route('kepala.lembaga.download-profil') }}" class="btn btn-success btn-sm" target="_blank" title="Download Profil PDF">
                        <i class="fas fa-file-pdf"></i>
                    </a>
                    <a href="{{ route('kepala.lembaga.edit') }}" class="btn btn-warning btn-sm" title="Edit Data Lembaga">
                        <i class="fas fa-edit"></i>
                    </a>
                </div>
            </div>
            <div class="card-body">
                <!-- Logo Lembaga -->
                @if($lembaga->logo_lembaga)
                    <div class="row mb-4">
                        <div class="col-12">
                            <div class="text-center">
                                <h5><i class="fas fa-image"></i> Logo Lembaga</h5>
                                <img src="{{ Storage::url($lembaga->logo_lembaga) }}" 
                                     alt="Logo {{ $lembaga->nama_lembaga }}" 
                                     class="img-fluid rounded shadow" 
                                     style="max-height: 200px; max-width: 300px;">
                                <p class="text-muted mt-2">
                                    <small>Logo dapat diubah melalui menu Edit</small>
                                </p>
                            </div>
                        </div>
                    </div>
                    <hr>
                @endif
                <dl class="row">
                    <dt class="col-sm-3">Nama Lembaga:</dt>
                    <dd class="col-sm-9"><strong>{{ $lembaga->nama_lembaga }}</strong></dd>
                    
                    <dt class="col-sm-3">NSM:</dt>
                    <dd class="col-sm-9">{{ $lembaga->npsn_nsm }}</dd>
                    
                    <dt class="col-sm-3">Jenis:</dt>
                    <dd class="col-sm-9">
                        <span class="badge badge-{{ $lembaga->jenis == 'RA' ? 'primary' : ($lembaga->jenis == 'MI' ? 'success' : ($lembaga->jenis == 'MTs' ? 'info' : 'warning')) }}">
                            {{ $lembaga->jenis }}
                        </span>
                    </dd>
                    
                    <dt class="col-sm-3">Alamat:</dt>
                    <dd class="col-sm-9">{{ $lembaga->alamat_lengkap }}</dd>
                    
                    <dt class="col-sm-3">Kelurahan:</dt>
                    <dd class="col-sm-9">{{ $lembaga->kelurahan_name ?? $lembaga->kelurahan }}</dd>
                    
                    <dt class="col-sm-3">Kecamatan:</dt>
                    <dd class="col-sm-9">{{ $lembaga->kecamatan_name ?? $lembaga->kecamatan }}</dd>
                    
                    <dt class="col-sm-3">Kabupaten:</dt>
                    <dd class="col-sm-9">{{ $lembaga->kabupaten_name ?? $lembaga->kabupaten }}</dd>
                    
                    <dt class="col-sm-3">Provinsi:</dt>
                    <dd class="col-sm-9">{{ $lembaga->provinsi_name ?? $lembaga->provinsi }}</dd>
                    
                    <dt class="col-sm-3">Kode Pos:</dt>
                    <dd class="col-sm-9">{{ $lembaga->kode_pos }}</dd>
                    
                    <dt class="col-sm-3">Telepon:</dt>
                    <dd class="col-sm-9">{{ $lembaga->telepon ?: '-' }}</dd>
                    
                    <dt class="col-sm-3">Email:</dt>
                    <dd class="col-sm-9">{{ $lembaga->email ?: '-' }}</dd>
                    
                    <dt class="col-sm-3">Website:</dt>
                    <dd class="col-sm-9">
                        @if($lembaga->website)
                            <a href="{{ $lembaga->website }}" target="_blank">{{ $lembaga->website }}</a>
                        @else
                            -
                        @endif
                    </dd>
                    
                    <dt class="col-sm-3">Nama Kepala:</dt>
                    <dd class="col-sm-9">
                        <strong>{{ $lembaga->kepala->name ?? $lembaga->nama_kepala ?? 'Belum ada kepala' }}</strong>
                        @if($lembaga->kepala_id)
                            <br><small class="text-success"><i class="fas fa-check-circle"></i> Terintegrasi dengan akun sistem</small>
                        @else
                            <br><small class="text-warning"><i class="fas fa-exclamation-triangle"></i> Belum terintegrasi dengan akun</small>
                        @endif
                    </dd>
                    
                    <dt class="col-sm-3">NIP Kepala:</dt>
                    <dd class="col-sm-9">{{ $lembaga->kepala->nip ?? $lembaga->nip_kepala ?? '-' }}</dd>
                    
                    <dt class="col-sm-3">Akreditasi:</dt>
                    <dd class="col-sm-9">{{ $lembaga->akreditasi ?: '-' }}</dd>
                    
                    <dt class="col-sm-3">Tahun Berdiri:</dt>
                    <dd class="col-sm-9">{{ $lembaga->tahun_berdiri ?: '-' }}</dd>
                </dl>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="col-md-4">
        <div class="card card-success card-outline">
            <div class="card-header">
                <h3 class="card-title">
                    <i class="fas fa-bolt"></i> Aksi Cepat
                </h3>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="{{ route('kepala.lembaga.download-cover-raport') }}" class="btn btn-info" target="_blank" title="Download Cover Raport PDF">
                        <i class="fas fa-file-alt"></i> Download Cover Raport
                    </a>
                    <a href="{{ route('kepala.lembaga.download-profil') }}" class="btn btn-success" target="_blank" title="Download Profil Lembaga PDF">
                        <i class="fas fa-file-pdf"></i> Download Profil PDF
                    </a>
                    <a href="{{ route('kepala.lembaga.edit') }}" class="btn btn-warning" title="Edit Data Lembaga">
                        <i class="fas fa-edit"></i> Edit Data Lembaga
                    </a>
                    <a href="{{ route('kepala.instrumen.index') }}" class="btn btn-primary" title="Lihat Instrumen">
                        <i class="fas fa-clipboard-list"></i> Lihat Instrumen
                    </a>
                </div>
            </div>
        </div>

        <!-- Pengawas Information -->
        <div class="card card-info card-outline mt-3">
            <div class="card-header">
                <h3 class="card-title">
                    <i class="fas fa-user-tie"></i> Pengawas
                </h3>
            </div>
            <div class="card-body">
                @if($lembaga->pengawas)
                    <p><strong>Nama:</strong> {{ $lembaga->pengawas->name }}</p>
                    <p><strong>Email:</strong> {{ $lembaga->pengawas->email }}</p>
                    <p><strong>Status:</strong> 
                        <span class="badge badge-{{ $lembaga->pengawas->is_active ? 'success' : 'danger' }}">
                            {{ $lembaga->pengawas->is_active ? 'Aktif' : 'Nonaktif' }}
                        </span>
                    </p>
                @else
                    <p class="text-muted">Belum ada pengawas yang ditugaskan</p>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection
