<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cover Raport Penilaian Kinerja Kepala Madrasah</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Times New Roman', serif;
            font-size: 14px;
            line-height: 1.6;
            margin: 0;
            padding: 0;
            color: #000;
            width: 100%;
            height: 100vh;
        }
        
        .cover-container {
            width: 100%;
            height: 100vh;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            text-align: center;
            padding: 60px 50px;
            margin: 0 auto;
            max-width: 100%;
            box-sizing: border-box;
        }
        
        .title {
            font-size: 20px;
            font-weight: bold;
            text-transform: uppercase;
            margin: 0 auto 40px auto;
            letter-spacing: 2px;
            width: 100%;
            text-align: center;
        }
        
        .tahun {
            font-size: 18px;
            font-weight: bold;
            margin: 0 auto 100px auto;
            width: 100%;
            text-align: center;
        }
        
        .logo-container {
            margin: 100px auto 100px auto;
            min-height: 250px;
            display: flex;
            align-items: center;
            justify-content: center;
            width: 100%;
        }
        
        .logo-container img {
            max-height: 250px;
            max-width: 500px;
            width: auto;
            height: auto;
            display: block;
            margin: 0 auto;
        }
        
        .nama-lembaga {
            font-size: 22px;
            font-weight: bold;
            margin: 0 auto 40px auto;
            text-transform: uppercase;
            width: 100%;
            text-align: center;
        }
        
        .alamat {
            font-size: 14px;
            line-height: 1.8;
            margin: 0 auto;
            width: 100%;
            max-width: 600px;
            text-align: center;
            word-wrap: break-word;
            overflow-wrap: break-word;
        }
    </style>
</head>
<body>
    <div class="cover-container">
        <div class="title">
            RAPORT PENILAIAN KINERJA KEPALA MADRASAH
        </div>
        
        <div class="tahun">
            TAHUN {{ $tahun }}
        </div>
        
        @if(isset($logoBase64) && $logoBase64)
        <div class="logo-container">
            <img src="{{ $logoBase64 }}" alt="Logo Lembaga">
        </div>
        @else
        <div class="logo-container" style="min-height: 120px;">
            <!-- Space for logo if not available -->
        </div>
        @endif
        
        <div class="nama-lembaga">
            {{ $lembaga->nama_lembaga }}
        </div>
        
        <div class="alamat">
            {{ $alamat }}
        </div>
    </div>
</body>
</html>

